/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.tests.temp.headless;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.ctf.core.context.CtfTmfContext;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;

public class Benchmark {
    public static void main(String[] args) {
        String TRACE_PATH = "testfiles/kernel";
        int NUM_LOOPS = 100;
        boolean USE_TEXT = true;
        long nbEvent = 0L;
        Vector<Double> benchs = new Vector<Double>();
        int loops = 0;
        while (loops < 100) {
            nbEvent = 0L;
            CtfTmfTrace trace = new CtfTmfTrace();
            try {
                trace.initTrace(null, "testfiles/kernel", CtfTmfEvent.class);
            }
            catch (TmfTraceException e) {
                loops = 101;
                break;
            }
            long start = System.nanoTime();
            if (nbEvent != -1L) {
                CtfTmfContext traceReader = (CtfTmfContext)trace.seekEvent(0L);
                start = System.nanoTime();
                CtfTmfEvent current = traceReader.getCurrentEvent();
                while (current != null) {
                    System.out.println("Event " + ++nbEvent + " Time " + current.getTimestamp().toString() + " type " + current.getType().getName() + " on CPU " + current.getCPU() + " " + current.getContent().toString());
                    boolean hasMore = traceReader.advance();
                    current = traceReader.getCurrentEvent();
                }
            }
            long stop = System.nanoTime();
            System.out.print('.');
            double time = (double)(stop - start) / (double)nbEvent;
            benchs.add(time);
            trace.dispose();
            ++loops;
        }
        System.out.println("");
        double avg = 0.0;
        Iterator iterator = benchs.iterator();
        while (iterator.hasNext()) {
            double val = (Double)iterator.next();
            avg += val;
        }
        System.out.println("Time to read = " + (avg /= (double)benchs.size()) + " events/ns");
        for (Double val : benchs) {
            System.out.print(val);
            System.out.print(", ");
        }
    }
}

