/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.tests.temp.request;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;

public class TmfSchedulerTest {
    @Rule
    public TestRule globalTimeout = new Timeout(1L, TimeUnit.MINUTES);
    private static final @NonNull CtfTestTrace testTrace = CtfTestTrace.KERNEL;
    private static final int NB_EVENTS_TRACE = 695319;
    private static final int NB_EVENTS_TIME_RANGE = 155133;
    private CtfTmfTrace fixture;
    private long fStartTime;
    private long fEndTime;
    private TmfTimeRange fForegroundTimeRange;
    private final List<String> fOrderList = new ArrayList<String>();
    private int fForegroundId = 0;
    private int fBackgroundId = 0;

    @Before
    public void setUp() {
        this.fixture = CtfTmfTestTraceUtils.getTrace(testTrace);
        this.fixture.indexTrace(true);
        this.fStartTime = this.fixture.getStartTime().toNanos();
        this.fEndTime = this.fixture.getEndTime().toNanos();
        long foregroundStartTime = this.fStartTime + (this.fEndTime - this.fStartTime) / 4L;
        long foregroundEndTime = this.fStartTime + (this.fEndTime - this.fStartTime) / 2L;
        this.fForegroundTimeRange = new TmfTimeRange(TmfTimestamp.fromNanos((long)foregroundStartTime), TmfTimestamp.fromNanos((long)foregroundEndTime));
    }

    @After
    public void tearDown() {
        if (this.fixture != null) {
            this.fixture.dispose();
        }
    }

    @Test
    public void backgroundRequest() {
        BackgroundRequest background = new BackgroundRequest(TmfTimeRange.ETERNITY);
        this.fixture.sendRequest((ITmfEventRequest)background);
        try {
            background.waitForCompletion();
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
        Assert.assertEquals((long)695319L, (long)background.getNbEvents());
    }

    @Test
    public void foregroundRequest() {
        ForegroundRequest foreground = new ForegroundRequest(TmfTimeRange.ETERNITY);
        this.fixture.sendRequest((ITmfEventRequest)foreground);
        try {
            foreground.waitForCompletion();
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
        Assert.assertEquals((long)695319L, (long)foreground.getNbEvents());
    }

    @Test
    public void TestMultiRequest1() {
        BackgroundRequest background = new BackgroundRequest(TmfTimeRange.ETERNITY);
        ForegroundRequest foreground = new ForegroundRequest(TmfTimeRange.ETERNITY);
        this.fixture.sendRequest((ITmfEventRequest)background);
        this.fixture.sendRequest((ITmfEventRequest)foreground);
        try {
            background.waitForCompletion();
            foreground.waitForCompletion();
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
        Assert.assertEquals((long)695319L, (long)background.getNbEvents());
        Assert.assertEquals((long)695319L, (long)foreground.getNbEvents());
    }

    @Test
    public void TestMultiRequest2() {
        BackgroundRequest background2 = new BackgroundRequest(TmfTimeRange.ETERNITY);
        ForegroundRequest foreground2 = new ForegroundRequest(this.fForegroundTimeRange);
        this.fixture.sendRequest((ITmfEventRequest)background2);
        this.fixture.sendRequest((ITmfEventRequest)foreground2);
        try {
            background2.waitForCompletion();
            foreground2.waitForCompletion();
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
        Assert.assertEquals((long)695319L, (long)background2.getNbEvents());
        Assert.assertEquals((long)155133L, (long)foreground2.getNbEvents());
    }

    @Test
    public void TestMultiRequest3() {
        ForegroundRequest foreground3 = new ForegroundRequest(TmfTimeRange.ETERNITY);
        this.fixture.sendRequest((ITmfEventRequest)foreground3);
        TmfSelectionRangeUpdatedSignal signal3 = new TmfSelectionRangeUpdatedSignal((Object)this, this.fForegroundTimeRange.getStartTime());
        this.fixture.broadcast((TmfSignal)signal3);
        try {
            foreground3.waitForCompletion();
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
        Assert.assertEquals((long)695319L, (long)foreground3.getNbEvents());
    }

    @Test
    public void TestMultiRequest4() {
        ForegroundRequest foreground4 = new ForegroundRequest(this.fForegroundTimeRange);
        this.fixture.sendRequest((ITmfEventRequest)foreground4);
        TmfSelectionRangeUpdatedSignal signal4 = new TmfSelectionRangeUpdatedSignal((Object)this, TmfTimestamp.fromSeconds((long)(this.fStartTime + (this.fEndTime - this.fStartTime) / 8L)));
        this.fixture.broadcast((TmfSignal)signal4);
        try {
            foreground4.waitForCompletion();
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
        Assert.assertEquals((long)155133L, (long)foreground4.getNbEvents());
    }

    @Test
    public void TestMultiRequest5() {
        ForegroundRequest foreground5 = new ForegroundRequest(this.fForegroundTimeRange);
        this.fixture.sendRequest((ITmfEventRequest)foreground5);
        TmfSelectionRangeUpdatedSignal signal5 = new TmfSelectionRangeUpdatedSignal((Object)this, TmfTimestamp.fromSeconds((long)(this.fEndTime - (this.fEndTime - this.fStartTime) / 4L)));
        this.fixture.broadcast((TmfSignal)signal5);
        try {
            foreground5.waitForCompletion();
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
        Assert.assertEquals((long)155133L, (long)foreground5.getNbEvents());
    }

    @Test
    public void TestMultiRequest6() {
        BackgroundRequest background6 = new BackgroundRequest(TmfTimeRange.ETERNITY);
        ForegroundRequest foreground6 = new ForegroundRequest(TmfTimeRange.ETERNITY);
        this.fixture.sendRequest((ITmfEventRequest)background6);
        this.fixture.sendRequest((ITmfEventRequest)foreground6);
        TmfSelectionRangeUpdatedSignal signal6 = new TmfSelectionRangeUpdatedSignal((Object)this, TmfTimestamp.fromSeconds((long)(this.fStartTime + (this.fEndTime - this.fStartTime) / 8L)));
        this.fixture.broadcast((TmfSignal)signal6);
        try {
            background6.waitForCompletion();
            foreground6.waitForCompletion();
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
        Assert.assertEquals((long)695319L, (long)background6.getNbEvents());
        Assert.assertEquals((long)695319L, (long)foreground6.getNbEvents());
    }

    @Test
    public void TestMultiRequest7() {
        ForegroundRequest foreground7 = new ForegroundRequest(TmfTimeRange.ETERNITY);
        ForegroundRequest foreground8 = new ForegroundRequest(this.fForegroundTimeRange);
        BackgroundRequest background7 = new BackgroundRequest(TmfTimeRange.ETERNITY);
        BackgroundRequest background8 = new BackgroundRequest(TmfTimeRange.ETERNITY);
        this.fixture.sendRequest((ITmfEventRequest)foreground7);
        this.fixture.sendRequest((ITmfEventRequest)foreground8);
        this.fixture.sendRequest((ITmfEventRequest)background7);
        this.fixture.sendRequest((ITmfEventRequest)background8);
        try {
            foreground7.waitForCompletion();
            foreground8.waitForCompletion();
            background7.waitForCompletion();
            background8.waitForCompletion();
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
        Assert.assertEquals((long)695319L, (long)foreground7.getNbEvents());
        Assert.assertEquals((long)155133L, (long)foreground8.getNbEvents());
        Assert.assertEquals((long)695319L, (long)background7.getNbEvents());
        Assert.assertEquals((long)695319L, (long)background8.getNbEvents());
    }

    @Test
    public void preemptedForegroundRequest() {
        ForegroundRequest foreground9 = new ForegroundRequest(TmfTimeRange.ETERNITY);
        TmfTimeRange shortTimeRange = new TmfTimeRange(TmfTimestamp.fromNanos((long)this.fStartTime), TmfTimestamp.fromNanos((long)(this.fStartTime + (this.fEndTime - this.fStartTime) / 16L)));
        ForegroundRequest shortForeground = new ForegroundRequest(shortTimeRange);
        this.fixture.sendRequest((ITmfEventRequest)foreground9);
        try {
            foreground9.waitForStart();
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
        this.fixture.sendRequest((ITmfEventRequest)shortForeground);
        try {
            shortForeground.waitForCompletion();
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
        Assert.assertFalse((boolean)foreground9.isCompleted());
    }

    @Test
    public void preemptedBackgroundRequest() {
        BackgroundRequest background9 = new BackgroundRequest(TmfTimeRange.ETERNITY);
        ForegroundRequest foreground10 = new ForegroundRequest(this.fForegroundTimeRange);
        this.fixture.sendRequest((ITmfEventRequest)background9);
        this.fixture.sendRequest((ITmfEventRequest)foreground10);
        try {
            foreground10.waitForCompletion();
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
        Assert.assertTrue((boolean)foreground10.isCompleted());
        Assert.assertFalse((boolean)background9.isCompleted());
    }

    @Ignore
    @Test
    public void executionOrder() {
        LinkedList<String> expectedOrder = new LinkedList<String>();
        expectedOrder.add("FOREGROUND1");
        expectedOrder.add("FOREGROUND2");
        expectedOrder.add("FOREGROUND3");
        expectedOrder.add("FOREGROUND4");
        expectedOrder.add("BACKGROUND1");
        expectedOrder.add("FOREGROUND1");
        expectedOrder.add("FOREGROUND2");
        expectedOrder.add("FOREGROUND3");
        expectedOrder.add("FOREGROUND4");
        expectedOrder.add("BACKGROUND2");
        this.fOrderList.clear();
        this.fForegroundId = 0;
        this.fBackgroundId = 0;
        BackgroundRequest background1 = new BackgroundRequest(TmfTimeRange.ETERNITY);
        BackgroundRequest background2 = new BackgroundRequest(TmfTimeRange.ETERNITY);
        ForegroundRequest foreground1 = new ForegroundRequest(TmfTimeRange.ETERNITY);
        ForegroundRequest foreground2 = new ForegroundRequest(TmfTimeRange.ETERNITY);
        ForegroundRequest foreground3 = new ForegroundRequest(TmfTimeRange.ETERNITY);
        ForegroundRequest foreground4 = new ForegroundRequest(TmfTimeRange.ETERNITY);
        this.fixture.sendRequest((ITmfEventRequest)foreground1);
        this.fixture.sendRequest((ITmfEventRequest)foreground2);
        this.fixture.sendRequest((ITmfEventRequest)foreground3);
        this.fixture.sendRequest((ITmfEventRequest)foreground4);
        this.fixture.sendRequest((ITmfEventRequest)background1);
        this.fixture.sendRequest((ITmfEventRequest)background2);
        try {
            foreground1.waitForCompletion();
            foreground2.waitForCompletion();
            foreground3.waitForCompletion();
            foreground4.waitForCompletion();
            background1.waitForCompletion();
            background2.waitForCompletion();
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
        Assert.assertEquals(expectedOrder, this.fOrderList.subList(0, expectedOrder.size()));
    }

    private class BackgroundRequest
    extends TmfEventRequest {
        private int nbEvents;
        private String backgroundName;

        BackgroundRequest(TmfTimeRange timeRange) {
            super(TmfSchedulerTest.this.fixture.getEventType(), timeRange, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
            this.nbEvents = 0;
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.getExecType().toString()));
            TmfSchedulerTest tmfSchedulerTest2 = TmfSchedulerTest.this;
            int n = tmfSchedulerTest2.fBackgroundId + 1;
            tmfSchedulerTest2.fBackgroundId = n;
            this.backgroundName = stringBuilder.append(n).toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleData(ITmfEvent event) {
            super.handleData(event);
            List list = TmfSchedulerTest.this.fOrderList;
            synchronized (list) {
                if (TmfSchedulerTest.this.fOrderList.isEmpty() || !((String)TmfSchedulerTest.this.fOrderList.get(TmfSchedulerTest.this.fOrderList.size() - 1)).equals(this.backgroundName)) {
                    TmfSchedulerTest.this.fOrderList.add(this.backgroundName);
                }
            }
            ++this.nbEvents;
        }

        public int getNbEvents() {
            return this.nbEvents;
        }
    }

    private class ForegroundRequest
    extends TmfEventRequest {
        private int nbEvents;
        private String foregroundName;

        ForegroundRequest(TmfTimeRange timeRange) {
            super(TmfSchedulerTest.this.fixture.getEventType(), timeRange, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.FOREGROUND);
            this.nbEvents = 0;
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.getExecType().toString()));
            TmfSchedulerTest tmfSchedulerTest2 = TmfSchedulerTest.this;
            int n = tmfSchedulerTest2.fForegroundId + 1;
            tmfSchedulerTest2.fForegroundId = n;
            this.foregroundName = stringBuilder.append(n).toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleData(ITmfEvent event) {
            super.handleData(event);
            List list = TmfSchedulerTest.this.fOrderList;
            synchronized (list) {
                if (TmfSchedulerTest.this.fOrderList.isEmpty() || !((String)TmfSchedulerTest.this.fOrderList.get(TmfSchedulerTest.this.fOrderList.size() - 1)).equals(this.foregroundName)) {
                    TmfSchedulerTest.this.fOrderList.add(this.foregroundName);
                }
            }
            ++this.nbEvents;
        }

        public int getNbEvents() {
            return this.nbEvents;
        }
    }
}

