/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.tests.trace;

import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TmfTraceUtilsSearchingTest {
    private static final @NonNull CtfTestTrace TEST_TRACE = CtfTestTrace.TRACE2;
    private static final long START_RANK = 500L;
    private ITmfTrace fTrace;
    private ITmfEvent fStartEvent;

    @Before
    public void setUp() {
        this.fTrace = CtfTmfTestTraceUtils.getTrace(TEST_TRACE);
        ITmfContext ctx = this.fTrace.seekEvent(500L);
        this.fStartEvent = this.fTrace.getNext(ctx);
        Assert.assertEquals((Object)"softirq_raise", (Object)this.fStartEvent.getName());
    }

    @After
    public void tearDown() {
        if (this.fTrace != null) {
            this.fTrace.dispose();
        }
    }

    @Test
    public void testNextMatchingEvent() {
        ITmfTrace trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        Predicate<@NonNull ITmfEvent> predicate = event -> event.getName().equals("sched_switch");
        ITmfEvent actualEvent = TmfTraceUtils.getNextEventMatching((ITmfTrace)trace, (long)500L, predicate, null);
        ITmfContext ctx = trace.seekEvent(508L);
        ITmfEvent expectedEvent = trace.getNext(ctx);
        Assert.assertEquals((Object)expectedEvent, (Object)actualEvent);
    }

    @Test
    public void testNextMatchingEventProgressMonitor() {
        ITmfTrace trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        Predicate<@NonNull ITmfEvent> predicate = event -> event.getName().equals("sched_switch");
        NullProgressMonitor monitor = new NullProgressMonitor();
        ITmfEvent actualEvent = TmfTraceUtils.getNextEventMatching((ITmfTrace)trace, (long)500L, predicate, (IProgressMonitor)monitor);
        ITmfContext ctx = trace.seekEvent(508L);
        ITmfEvent expectedEvent = trace.getNext(ctx);
        Assert.assertEquals((Object)expectedEvent, (Object)actualEvent);
    }

    @Test
    public void testNextMatchingEventNoMatch() {
        ITmfTrace trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        Predicate<@NonNull ITmfEvent> predicate = event -> event.getName().equals("non-existent-event");
        ITmfEvent actualEvent = TmfTraceUtils.getNextEventMatching((ITmfTrace)trace, (long)500L, predicate, null);
        Assert.assertNull((Object)actualEvent);
    }

    @Test
    public void testNextMatchingEventStartMatches() {
        ITmfTrace trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        Predicate<@NonNull ITmfEvent> predicate = event -> event.getName().equals("softirq_raise");
        ITmfEvent foundEvent = TmfTraceUtils.getNextEventMatching((ITmfTrace)trace, (long)500L, predicate, null);
        Assert.assertNotNull((Object)foundEvent);
        Assert.assertNotEquals((Object)this.fStartEvent, (Object)foundEvent);
    }

    @Test
    public void testNextMatchingEventCancelled() {
        ITmfTrace trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        Predicate<@NonNull ITmfEvent> predicate = event -> event.getName().equals("sched_switch");
        NullProgressMonitor monitor = new NullProgressMonitor();
        monitor.setCanceled(true);
        ITmfEvent actualEvent = TmfTraceUtils.getNextEventMatching((ITmfTrace)trace, (long)500L, predicate, (IProgressMonitor)monitor);
        Assert.assertNull((Object)actualEvent);
    }

    @Test
    public void testPreviousMatchingEvent() {
        ITmfTrace trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        Predicate<@NonNull ITmfEvent> predicate = event -> event.getName().equals("sched_switch");
        ITmfEvent actualEvent = TmfTraceUtils.getPreviousEventMatching((ITmfTrace)trace, (long)500L, predicate, null);
        ITmfContext ctx = trace.seekEvent(455L);
        ITmfEvent expectedEvent = trace.getNext(ctx);
        Assert.assertEquals((Object)expectedEvent, (Object)actualEvent);
    }

    @Test
    public void testPreviousMatchingEventProgressMonitor() {
        ITmfTrace trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        Predicate<@NonNull ITmfEvent> predicate = event -> event.getName().equals("sched_switch");
        NullProgressMonitor monitor = new NullProgressMonitor();
        ITmfEvent actualEvent = TmfTraceUtils.getPreviousEventMatching((ITmfTrace)trace, (long)500L, predicate, (IProgressMonitor)monitor);
        ITmfContext ctx = trace.seekEvent(455L);
        ITmfEvent expectedEvent = trace.getNext(ctx);
        Assert.assertEquals((Object)expectedEvent, (Object)actualEvent);
    }

    @Test
    public void testPreviousMatchingEventNoMatch() {
        ITmfTrace trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        Predicate<@NonNull ITmfEvent> predicate = event -> event.getName().equals("non-existent-event");
        ITmfEvent actualEvent = TmfTraceUtils.getPreviousEventMatching((ITmfTrace)trace, (long)500L, predicate, null);
        Assert.assertNull((Object)actualEvent);
    }

    @Test
    public void testPreviousMatchingEventStartMatches() {
        ITmfTrace trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        Predicate<@NonNull ITmfEvent> predicate = event -> event.getName().equals("softirq_raise");
        ITmfEvent foundEvent = TmfTraceUtils.getPreviousEventMatching((ITmfTrace)trace, (long)500L, predicate, null);
        Assert.assertNotNull((Object)foundEvent);
        Assert.assertNotEquals((Object)this.fStartEvent, (Object)foundEvent);
    }

    @Test
    public void testPreviousMatchingEventFar() {
        ITmfTrace trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        Predicate<@NonNull ITmfEvent> predicate = event -> event.getName().equals("sys_write");
        ITmfEvent actualEvent = TmfTraceUtils.getPreviousEventMatching((ITmfTrace)trace, (long)500L, predicate, null);
        ITmfContext ctx = trace.seekEvent(387L);
        ITmfEvent expectedEvent = trace.getNext(ctx);
        Assert.assertEquals((Object)expectedEvent, (Object)actualEvent);
    }

    @Test
    public void testPreviousMatchingBeginningOfTrace() {
        ITmfTrace trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        int startRank = 3;
        ITmfContext ctx = this.fTrace.seekEvent(3L);
        ITmfEvent startEvent = this.fTrace.getNext(ctx);
        Assert.assertEquals((Object)"exit_syscall", (Object)startEvent.getName());
        Predicate<@NonNull ITmfEvent> predicate = event -> event.getName().equals("sys_mmap");
        ITmfEvent foundEvent = TmfTraceUtils.getPreviousEventMatching((ITmfTrace)trace, (long)3L, predicate, null);
        Assert.assertNull((Object)foundEvent);
        predicate = event -> event.getName().equals("exit_syscall");
        foundEvent = TmfTraceUtils.getPreviousEventMatching((ITmfTrace)trace, (long)3L, predicate, null);
        Assert.assertNull((Object)foundEvent);
    }

    @Test
    public void testPreviousMatchingEventCancelled() {
        ITmfTrace trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        Predicate<@NonNull ITmfEvent> predicate = event -> event.getName().equals("sched_switch");
        NullProgressMonitor monitor = new NullProgressMonitor();
        monitor.setCanceled(true);
        ITmfEvent actualEvent = TmfTraceUtils.getPreviousEventMatching((ITmfTrace)trace, (long)500L, predicate, (IProgressMonitor)monitor);
        Assert.assertNull((Object)actualEvent);
    }
}

