/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.pcap.ui.swtbot.tests;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.results.BoolResult;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.tracecompass.internal.tmf.pcap.core.trace.PcapTrace;
import org.eclipse.tracecompass.internal.tmf.pcap.ui.stream.StreamListView;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.pcap.core.tests.shared.PcapTmfTestTrace;
import org.eclipse.tracecompass.tmf.ui.editors.TmfEventsEditor;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfOpenTraceHelper;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class ImportAndReadPcapTest {
    private static final String NETWORK_PERSPECTIVE_ID = "org.eclipse.linuxtools.tmf.pcap.ui.perspective.network";
    private static final String TRACE_PROJECT_NAME = "test";
    private static SWTWorkbenchBot fBot;
    private ITmfEvent fDesired1;
    private static PcapTmfTestTrace pttt;
    private static final Logger fLogger;

    static {
        pttt = PcapTmfTestTrace.BENCHMARK_TRACE;
        fLogger = Logger.getRootLogger();
    }

    @BeforeClass
    public static void init() {
        SWTBotUtils.initialize();
        SWTBotPreferences.TIMEOUT = 300000L;
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
        fBot = new SWTWorkbenchBot();
        List openViews = fBot.views();
        for (SWTBotView view : openViews) {
            if (!view.getTitle().equals("Welcome")) continue;
            view.close();
            fBot.waitUntil(ConditionHelpers.ViewIsClosed((SWTBotView)view));
        }
        ImportAndReadPcapTest.switchNetworkPerspective();
        SWTBotUtils.waitForJobs();
    }

    @AfterClass
    public static void terminate() {
        fLogger.removeAllAppenders();
    }

    private static void switchNetworkPerspective() {
        final Exception[] retE = new Exception[1];
        if (!((Boolean)UIThreadRunnable.syncExec((Result)new BoolResult(){

            public Boolean run() {
                try {
                    PlatformUI.getWorkbench().showPerspective(ImportAndReadPcapTest.NETWORK_PERSPECTIVE_ID, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                }
                catch (WorkbenchException e) {
                    retE[0] = e;
                    return false;
                }
                return true;
            }
        })).booleanValue()) {
            Assert.fail((String)retE[0].getMessage());
        }
    }

    @Test
    public void test() {
        Assume.assumeTrue((boolean)pttt.exists());
        SWTBotUtils.createProject((String)TRACE_PROJECT_NAME);
        ImportAndReadPcapTest.openTrace();
        this.openEditor();
        ImportAndReadPcapTest.testHV(ImportAndReadPcapTest.getViewPart("Histogram"));
        this.testStreamView(ImportAndReadPcapTest.getViewPartRef("Stream List"));
        fBot.closeAllEditors();
        SWTBotUtils.deleteProject((String)TRACE_PROJECT_NAME, (SWTWorkbenchBot)fBot);
    }

    private void testStreamView(IViewReference viewPart) {
        SWTBotView botView = new SWTBotView(viewPart, fBot);
        StreamListView slv = (StreamListView)ImportAndReadPcapTest.getViewPart("Stream List");
        botView.setFocus();
        SWTBotTree botTree = fBot.tree();
        Assert.assertNotNull((Object)botTree);
        TmfSelectionRangeUpdatedSignal signal = new TmfSelectionRangeUpdatedSignal((Object)slv, this.fDesired1.getTimestamp());
        slv.broadcast((TmfSignal)signal);
        SWTBotUtils.waitForJobs();
        SWTBotUtils.delay((long)1000L);
    }

    private static void openTrace() {
        final Exception[] exception = new Exception[]{null};
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                try {
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(ImportAndReadPcapTest.TRACE_PROJECT_NAME);
                    TmfTraceFolder destinationFolder = TmfProjectRegistry.getProject((IProject)project, (boolean)true).getTracesFolder();
                    String absolutePath = new File(pttt.getTrace().getPath()).getAbsolutePath();
                    TmfOpenTraceHelper.openTraceFromPath((TmfTraceFolder)destinationFolder, (String)absolutePath, (Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"org.eclipse.linuxtools.tmf.pcap.core.pcaptrace");
                }
                catch (CoreException e) {
                    exception[0] = e;
                }
            }
        });
        if (exception[0] != null) {
            Assert.fail((String)exception[0].getMessage());
        }
        SWTBotUtils.delay((long)1000L);
        SWTBotUtils.waitForJobs();
    }

    private void openEditor() {
        final ArrayList editorRefs = new ArrayList();
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                IEditorReference[] ieds = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
                editorRefs.addAll(Arrays.asList(ieds));
            }
        });
        Assert.assertFalse((boolean)editorRefs.isEmpty());
        IEditorPart iep = null;
        for (IEditorReference ied : editorRefs) {
            if (!ied.getTitle().equals(pttt.getTrace().getName())) continue;
            iep = ied.getEditor(true);
            break;
        }
        Assert.assertNotNull(iep);
        this.fDesired1 = ImportAndReadPcapTest.getEvent(100);
        final TmfEventsEditor tmfEd = (TmfEventsEditor)iep;
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                tmfEd.setFocus();
                tmfEd.selectionChanged(new SelectionChangedEvent((ISelectionProvider)tmfEd, (ISelection)new StructuredSelection((Object)ImportAndReadPcapTest.this.fDesired1)));
            }
        });
        SWTBotUtils.waitForJobs();
        SWTBotUtils.delay((long)1000L);
        Assert.assertNotNull((Object)tmfEd);
    }

    private static void testHV(IViewPart vp) {
        Assert.assertNotNull((Object)vp);
    }

    private static ITmfEvent getEvent(int rank) {
        PcapTrace trace = pttt.getTrace();
        ITmfContext ctx = trace.seekEvent(0L);
        int i = 0;
        while (i < rank) {
            trace.getNext(ctx);
            ++i;
        }
        ITmfEvent ret = trace.getNext(ctx);
        trace.dispose();
        return ret;
    }

    private static IViewPart getViewPart(final String viewTile) {
        final IViewPart[] vps = new IViewPart[1];
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                IViewReference[] viewRefs;
                IViewReference[] iViewReferenceArray = viewRefs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
                int n = viewRefs.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewReference viewRef = iViewReferenceArray[n2];
                    IViewPart vp = viewRef.getView(true);
                    if (vp.getTitle().equals(viewTile)) {
                        vps[0] = vp;
                        return;
                    }
                    ++n2;
                }
            }
        });
        return vps[0];
    }

    private static IViewReference getViewPartRef(final String viewTile) {
        final IViewReference[] vrs = new IViewReference[1];
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                IViewReference[] viewRefs;
                IViewReference[] iViewReferenceArray = viewRefs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
                int n = viewRefs.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewReference viewRef = iViewReferenceArray[n2];
                    IViewPart vp = viewRef.getView(true);
                    if (vp.getTitle().equals(viewTile)) {
                        vrs[0] = viewRef;
                        return;
                    }
                    ++n2;
                }
            }
        });
        return vrs[0];
    }
}

