/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared;

import java.awt.AWTException;
import java.awt.Robot;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBotControl;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.hamcrest.SelfDescribing;

public class SWTBotSash
extends AbstractSWTBotControl<Sash> {
    public SWTBotSash(Sash w, SelfDescribing description) throws WidgetNotFoundException {
        super((Control)w, description);
    }

    public Point getPoint() {
        return (Point)UIThreadRunnable.syncExec((Result)new Result<Point>(){

            public Point run() {
                return ((Sash)SWTBotSash.this.widget).toDisplay(0, ((Sash)SWTBotSash.this.widget).getSize().y / 2);
            }
        });
    }

    public void drag(Point dst) {
        final Point src = this.getPoint();
        try {
            final Robot awtRobot = new Robot();
            int magDist = (src.x - dst.x) * (src.x - dst.x) + (src.y - dst.y) * (src.y - dst.y);
            int steps = Math.max(1, (int)Math.sqrt((double)magDist / 100.0));
            final int stepX = (dst.x - src.x) / steps;
            final int stepY = (dst.y - src.y) / steps;
            this.syncExec(new VoidResult(){

                public void run() {
                    awtRobot.mouseMove(src.x, src.y);
                    SWTBotUtils.delay(15L);
                    awtRobot.mousePress(16);
                }
            });
            int i = 0;
            while (i < steps) {
                final int index = i++;
                this.asyncExec(new VoidResult(){

                    public void run() {
                        int x = src.x + index * stepX;
                        int y = src.y + index * stepY;
                        awtRobot.mouseMove(x, y);
                    }
                });
                SWTBotUtils.delay(10L);
            }
            SWTBotUtils.delay(100L);
            this.syncExec(new VoidResult(){

                public void run() {
                    awtRobot.mouseRelease(16);
                }
            });
        }
        catch (AWTException e) {
            throw new RuntimeException(e);
        }
    }
}

