/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.viewers.events;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTableItem;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.tracecompass.tmf.core.io.BufferedRandomAccessFile;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.views.colors.ColorSetting;
import org.eclipse.tracecompass.tmf.ui.views.colors.ColorSettingsManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class ColorsViewTest {
    private static final String XMLSTUB_ID = "org.eclipse.linuxtools.tmf.core.tests.xmlstub";
    private static final String TRACE_START = "<trace>";
    private static final String EVENT_BEGIN = "<event timestamp=\"";
    private static final String EVENT_MIDDLE = " \" name=\"event\"><field name=\"field\" value=\"";
    private static final String EVENT_END = "\" type=\"int\" /></event>";
    private static final String TRACE_END = "</trace>";
    private static final String PROJECT_NAME = "TestForFiltering";
    private static final Logger fLogger = Logger.getRootLogger();
    private static SWTWorkbenchBot fBot;
    private static File fFileLocation;

    private static String makeEvent(int ts, int val) {
        return EVENT_BEGIN + Integer.toString(ts) + EVENT_MIDDLE + Integer.toString(val) + EVENT_END + "\n";
    }

    @BeforeClass
    public static void init() throws IOException {
        SWTBotUtils.initialize();
        Thread.currentThread().setName("SWTBot Thread");
        SWTBotPreferences.TIMEOUT = 20000L;
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout()));
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.closeView("welcome", fBot);
        SWTBotUtils.switchToTracingPerspective();
        SWTBotUtils.waitForJobs();
        fFileLocation = File.createTempFile("sample", ".xml");
        Throwable throwable = null;
        Object var1_2 = null;
        try (BufferedRandomAccessFile braf = new BufferedRandomAccessFile(fFileLocation, "rw");){
            braf.writeBytes(TRACE_START);
            int i = 0;
            while (i < 100) {
                braf.writeBytes(ColorsViewTest.makeEvent(i * 100, i % 4));
                ++i;
            }
            braf.writeBytes(TRACE_END);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Before
    public void beforeTest() {
        SWTBotUtils.createProject(PROJECT_NAME);
        SWTBotTreeItem treeItem = SWTBotUtils.selectTracesFolder(fBot, PROJECT_NAME);
        Assert.assertNotNull((Object)treeItem);
        SWTBotUtils.openTrace(PROJECT_NAME, fFileLocation.getAbsolutePath(), XMLSTUB_ID);
        SWTBotUtils.openView("org.eclipse.linuxtools.tmf.ui.views.colors");
    }

    @AfterClass
    public static void cleanUp() {
        fLogger.removeAllAppenders();
        fFileLocation.delete();
    }

    @After
    public void tearDown() {
        fBot.closeAllEditors();
        SWTBotUtils.deleteProject(PROJECT_NAME, fBot);
        SWTBotUtils.closeViewById("org.eclipse.linuxtools.tmf.ui.views.colors", fBot);
    }

    @Test
    public void testYellow() {
        SWTBotView viewBot = fBot.viewById("org.eclipse.linuxtools.tmf.ui.views.colors");
        viewBot.setFocus();
        String insert = "Insert new color setting";
        String increasePriority = "Increase priority";
        String decreasePriority = "Decrease priority";
        String delete = "Delete color setting";
        viewBot.toolbarButton("Insert new color setting").click();
        viewBot.toolbarButton("Insert new color setting").click();
        viewBot.toolbarButton("Insert new color setting").click();
        viewBot.toolbarButton("Insert new color setting").click();
        viewBot.toolbarButton("Increase priority").click();
        viewBot.toolbarButton("Decrease priority").click();
        viewBot.toolbarButton("Delete color setting").click();
        viewBot.bot().label(0).setFocus();
        viewBot.toolbarButton("Delete color setting").click();
        viewBot.bot().label(0).setFocus();
        viewBot.toolbarButton("Delete color setting").click();
        final RGB foreground = new RGB(0, 0, 0);
        final RGB background = new RGB(255, 255, 0);
        final ColorSetting[] cs = new ColorSetting[1];
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                cs[0] = new ColorSetting(foreground, background, foreground, (ITmfFilterTreeNode)new PassAll());
                ColorSettingsManager.setColorSettings((ColorSetting[])cs);
            }
        });
        SWTBotTable eventsEditor = SWTBotUtils.activeEventsEditor(fBot).bot().table();
        SWTBotUtils.waitForJobs();
        eventsEditor.select(new int[]{2});
        final SWTBotTableItem tableItem = eventsEditor.getTableItem(2);
        RGB fgc = (RGB)UIThreadRunnable.syncExec((Result)new Result<RGB>(){

            public RGB run() {
                return ((TableItem)tableItem.widget).getForeground().getRGB();
            }
        });
        RGB bgc = (RGB)UIThreadRunnable.syncExec((Result)new Result<RGB>(){

            public RGB run() {
                return ((TableItem)tableItem.widget).getBackground().getRGB();
            }
        });
        Assert.assertEquals((String)"Fg", (Object)foreground, (Object)fgc);
        Assert.assertEquals((String)"Bg", (Object)background, (Object)bgc);
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                ColorSettingsManager.setColorSettings((ColorSetting[])new ColorSetting[0]);
            }
        });
    }

    private static final class PassAll
    implements ITmfFilterTreeNode {
        private PassAll() {
        }

        public boolean matches(ITmfEvent event) {
            return true;
        }

        public void setParent(ITmfFilterTreeNode parent) {
        }

        public ITmfFilterTreeNode replaceChild(int index, ITmfFilterTreeNode node) {
            return null;
        }

        public ITmfFilterTreeNode removeChild(ITmfFilterTreeNode node) {
            return null;
        }

        public ITmfFilterTreeNode remove() {
            return null;
        }

        public boolean hasChildren() {
            return false;
        }

        public List<String> getValidChildren() {
            return Collections.EMPTY_LIST;
        }

        public ITmfFilterTreeNode getParent() {
            return null;
        }

        public String getNodeName() {
            return "YES";
        }

        public int getChildrenCount() {
            return 0;
        }

        public @NonNull ITmfFilterTreeNode[] getChildren() {
            return null;
        }

        public ITmfFilterTreeNode getChild(int index) {
            return null;
        }

        public int addChild(ITmfFilterTreeNode node) {
            return 0;
        }

        public ITmfFilterTreeNode clone() {
            return null;
        }

        public String toString(boolean explicit) {
            return this.toString();
        }

        public String toString() {
            return this.getNodeName();
        }
    }
}

