/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.viewers.events;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.tracecompass.tmf.core.tests.TmfCoreTestPlugin;
import org.eclipse.tracecompass.tmf.ui.editors.TmfTraceColumnManager;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class MovableColumnEventsEditorTest {
    private static final String TRACE_PROJECT_NAME = "test";
    private static final String COLUMN_TRACE = "syslog_collapse";
    private static final String COLUMN_TRACE_PATH = "testfiles/syslog_collapse";
    private static final String COLUMN_TRACE_TYPE = "org.eclipse.linuxtools.tmf.tests.stubs.trace.text.testsyslog";
    private static final String[] BEFORE_COLS = new String[]{"", "Timestamp", "Host", "Logger", "File", "Line", "Message"};
    private static final String[] AFTER_COLS = new String[]{"", "Timestamp", "Logger", "Host", "File", "Line", "Message"};
    private static File fTestFile = null;
    private static SWTWorkbenchBot fBot;
    private static final Logger fLogger;

    static {
        fLogger = Logger.getRootLogger();
    }

    @BeforeClass
    public static void init() {
        SWTBotUtils.initialize();
        URL location = FileLocator.find((Bundle)TmfCoreTestPlugin.getDefault().getBundle(), (IPath)new Path(COLUMN_TRACE_PATH), null);
        try {
            URI uri = FileLocator.toFileURL((URL)location).toURI();
            fTestFile = new File(uri);
        }
        catch (IOException | URISyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
        Assume.assumeTrue((boolean)fTestFile.exists());
        SWTBotPreferences.TIMEOUT = 20000L;
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.closeView("Welcome", fBot);
        SWTBotUtils.switchToTracingPerspective();
        SWTBotUtils.waitForJobs();
    }

    @AfterClass
    public static void tearDown() {
        fLogger.removeAllAppenders();
    }

    @Test
    public void testReorder() {
        SWTBotUtils.createProject(TRACE_PROJECT_NAME);
        SWTBotUtils.openTrace(TRACE_PROJECT_NAME, fTestFile.getAbsolutePath(), COLUMN_TRACE_TYPE);
        SWTBotEditor editorBot = SWTBotUtils.activateEditor(fBot, fTestFile.getName());
        SWTBotTable tableBot = editorBot.bot().table();
        SWTBotUtils.maximizeTable(tableBot);
        Assert.assertArrayEquals((String)"Before reorder", (Object[])BEFORE_COLS, (Object[])tableBot.columns().toArray());
        final Table table = (Table)tableBot.widget;
        int[] nArray = new int[7];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 2;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        final int[] newColOrder = nArray;
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                table.setColumnOrder(newColOrder);
            }
        });
        editorBot.close();
        SWTBotUtils.openTrace(TRACE_PROJECT_NAME, fTestFile.getAbsolutePath(), COLUMN_TRACE_TYPE);
        editorBot = SWTBotUtils.activateEditor(fBot, fTestFile.getName());
        tableBot = editorBot.bot().table();
        SWTBotUtils.maximizeTable(tableBot);
        Assert.assertArrayEquals((String)"After reorder", (Object[])AFTER_COLS, (Object[])tableBot.columns().toArray());
        editorBot.close();
        TmfTraceColumnManager.clearColumnOrder((String)COLUMN_TRACE_TYPE);
        Assert.assertNull((String)"After clear", (Object)TmfTraceColumnManager.loadColumnOrder((String)COLUMN_TRACE_TYPE));
        SWTBotUtils.openTrace(TRACE_PROJECT_NAME, fTestFile.getAbsolutePath(), COLUMN_TRACE_TYPE);
        editorBot = SWTBotUtils.activateEditor(fBot, fTestFile.getName());
        tableBot = editorBot.bot().table();
        SWTBotUtils.maximizeTable(tableBot);
        Assert.assertNull((String)"After reset", (Object)TmfTraceColumnManager.loadColumnOrder((String)COLUMN_TRACE_TYPE));
        Assert.assertArrayEquals((String)"After reset", (Object[])BEFORE_COLS, (Object[])tableBot.columns().toArray());
        fBot.closeAllEditors();
        SWTBotUtils.deleteProject(TRACE_PROJECT_NAME, fBot);
    }
}

