/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.viewers.events;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.tracecompass.tmf.core.io.BufferedRandomAccessFile;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotSash;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class TmfAlignTimeAxisTest {
    private static final int SYNC_DELAY = 1000;
    private static final String TRACE_START = "<trace>";
    private static final String EVENT_BEGIN = "<event timestamp=\"";
    private static final String EVENT_MIDDLE = " \" name=\"event\"><field name=\"field\" value=\"";
    private static final String EVENT_END = "\" type=\"int\" /></event>";
    private static final String TRACE_END = "</trace>";
    private static final String PROJET_NAME = "TestAxisAlignment";
    private static final int NUM_EVENTS = 100;
    private static final float EDITOR_AREA_RATIO = 0.1f;
    private static final Logger fLogger = Logger.getRootLogger();
    private static SWTWorkbenchBot fBot;
    private static File fLocation;
    private static final BaseMatcher<Sash> SASH_MATCHER;

    static {
        SASH_MATCHER = new SashMatcher();
    }

    private static String makeEvent(int ts, int val) {
        return EVENT_BEGIN + Integer.toString(ts) + EVENT_MIDDLE + Integer.toString(val) + EVENT_END + "\n";
    }

    @BeforeClass
    public static void init() throws IOException {
        SWTBotUtils.initialize();
        Thread.currentThread().setName("SWTBot Thread");
        SWTBotPreferences.TIMEOUT = 20000L;
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout()));
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        SWTBotUtils.closeView("welcome", bot);
        SWTBotUtils.switchToTracingPerspective();
        SWTBotUtils.waitForJobs();
        fLocation = File.createTempFile("sample", ".xml");
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedRandomAccessFile braf = new BufferedRandomAccessFile(fLocation, "rw");){
            braf.writeBytes(TRACE_START);
            int i = 0;
            while (i < 100) {
                braf.writeBytes(TmfAlignTimeAxisTest.makeEvent(i * 100, i % 4));
                ++i;
            }
            braf.writeBytes(TRACE_END);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        SWTBotUtils.createProject(PROJET_NAME);
        SWTBotUtils.selectTracesFolder(bot, PROJET_NAME);
    }

    @AfterClass
    public static void cleanup() {
        SWTBotUtils.deleteProject(PROJET_NAME, new SWTWorkbenchBot());
        fLocation.delete();
        fLogger.removeAllAppenders();
    }

    @Before
    public void before() {
        SWTBotUtils.openTrace(PROJET_NAME, fLocation.getAbsolutePath(), "org.eclipse.linuxtools.tmf.core.tests.xmlstub");
    }

    @After
    public void after() {
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        SWTBotUtils.activeEventsEditor(bot).close();
        SWTBotUtils.switchToTracingPerspective();
    }

    @Test
    public void testMoveHistogramCallstackFollows() {
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.switchToPerspective("org.eclipse.linuxtools.tmf.test.align.1");
        TmfAlignTimeAxisTest.testOverlap("org.eclipse.linuxtools.tmf.ui.views.histogram", "org.eclipse.linuxtools.tmf.ui.views.callstack");
    }

    @Test
    public void testMoveCallstackHistogramFollows() {
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.switchToPerspective("org.eclipse.linuxtools.tmf.test.align.1");
        TmfAlignTimeAxisTest.testOverlap("org.eclipse.linuxtools.tmf.ui.views.callstack", "org.eclipse.linuxtools.tmf.ui.views.histogram");
    }

    @Test
    public void testOverlappingHistogramMove() {
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.switchToPerspective("org.eclipse.linuxtools.tmf.test.align.2");
        TmfAlignTimeAxisTest.testOverlap("org.eclipse.linuxtools.tmf.ui.views.histogram", "org.eclipse.linuxtools.tmf.ui.views.callstack");
    }

    @Test
    public void testOverlappingTimechartMove() {
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.switchToPerspective("org.eclipse.linuxtools.tmf.test.align.2");
        TmfAlignTimeAxisTest.testOverlap("org.eclipse.linuxtools.tmf.ui.views.callstack", "org.eclipse.linuxtools.tmf.ui.views.histogram");
    }

    @Test
    public void testNotOverlappingHistogramMove() {
        fBot = new SWTWorkbenchBot();
        TmfAlignTimeAxisTest.testNonOverlap("org.eclipse.linuxtools.tmf.ui.views.histogram", "org.eclipse.linuxtools.tmf.ui.views.callstack");
    }

    @Test
    public void testNotOverlappingCallstackMove() {
        fBot = new SWTWorkbenchBot();
        TmfAlignTimeAxisTest.testNonOverlap("org.eclipse.linuxtools.tmf.ui.views.callstack", "org.eclipse.linuxtools.tmf.ui.views.histogram");
    }

    private static void testNonOverlap(String vId1, String vId2) {
        int offset = 100;
        SWTBotUtils.switchToPerspective("org.eclipse.linuxtools.tmf.test.align.3");
        SWTBotUtils.waitForJobs();
        SWTBotUtils.delay(1000L);
        SWTBotView masterView = fBot.viewById(vId1);
        SWTBotView slaveView = fBot.viewById(vId2);
        Sash slaveSash = (Sash)slaveView.bot().widget(SASH_MATCHER, 0);
        SWTBotSash slaveSashBot = new SWTBotSash(slaveSash, null);
        Point before = slaveSashBot.getPoint();
        TmfAlignTimeAxisTest.drag(masterView, 100);
        SWTBotUtils.waitForJobs();
        SWTBotUtils.delay(1000L);
        Assert.assertEquals((Object)before, (Object)slaveSashBot.getPoint());
        TmfAlignTimeAxisTest.drag(masterView, -100);
        SWTBotUtils.delay(1000L);
    }

    private static void drag(SWTBotView view, final int offset) {
        final SashForm sashForm = (SashForm)view.bot().widget((Matcher)new SashFormMatcher(), 0);
        Assert.assertNotNull((Object)sashForm);
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                int[] originalWeights = sashForm.getWeights();
                int[] newWeights = Arrays.copyOf(originalWeights, originalWeights.length);
                newWeights[0] = newWeights[0] + offset;
                newWeights[1] = newWeights[1] - offset;
                sashForm.setWeights(newWeights);
                sashForm.getParent().layout();
            }
        });
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                sashForm.getChildren()[0].notifyListeners(11, null);
                sashForm.getChildren()[1].notifyListeners(11, null);
                sashForm.getChildren()[2].notifyListeners(13, null);
            }
        });
    }

    private static void testOverlap(String masterView, String slaveView) {
        int offset = 100;
        int delta = 50;
        SWTBotUtils.waitForJobs();
        SWTBotUtils.delay(1000L);
        SWTBotView masterViewBot = fBot.viewById(masterView);
        Sash masterSash = (Sash)masterViewBot.bot().widget(SASH_MATCHER, 0);
        SWTBotSash masterSashBot = new SWTBotSash(masterSash, null);
        SWTBotView slaveViewBot = fBot.viewById(slaveView);
        Sash slaveSash = (Sash)slaveViewBot.bot().widget(SASH_MATCHER, 0);
        SWTBotSash slaveSashBot = new SWTBotSash(slaveSash, null);
        double masterOriginalSashX = masterSashBot.getPoint().x;
        Assert.assertEquals((String)"Approx align", (double)masterOriginalSashX, (double)slaveSashBot.getPoint().x, (double)50.0);
        TmfAlignTimeAxisTest.drag(masterViewBot, 100);
        SWTBotUtils.waitForJobs();
        SWTBotUtils.delay(1000L);
        double masterNewSashX = masterSashBot.getPoint().x;
        Assert.assertEquals((String)"Approx align", (double)masterNewSashX, (double)slaveSashBot.getPoint().x, (double)50.0);
        Assert.assertEquals((double)masterOriginalSashX, (double)(masterNewSashX - 100.0), (double)50.0);
        TmfAlignTimeAxisTest.drag(masterViewBot, -100);
        SWTBotUtils.delay(1000L);
    }

    public static class AlignPerspectiveFactory1
    implements IPerspectiveFactory {
        public static final String ID = "org.eclipse.linuxtools.tmf.test.align.1";

        public void createInitialLayout(IPageLayout layout) {
            if (layout == null) {
                return;
            }
            layout.setEditorAreaVisible(true);
            layout.setEditorAreaVisible(true);
            IFolderLayout topLeftFolder = layout.createFolder("topLeftFolder", 1, 0.15f, "org.eclipse.ui.editorss");
            topLeftFolder.addView("org.eclipse.ui.navigator.ProjectExplorer");
            IFolderLayout topRightFolder = layout.createFolder("topRightFolder", 4, 0.1f, "org.eclipse.ui.editorss");
            topRightFolder.addView("org.eclipse.linuxtools.tmf.ui.views.histogram");
            IFolderLayout middleRightFolder = layout.createFolder("middleRightFolder", 4, 0.5f, "topRightFolder");
            middleRightFolder.addView("org.eclipse.linuxtools.tmf.ui.views.callstack");
            IFolderLayout bottomRightFolder = layout.createFolder("bottomRightFolder", 4, 0.65f, "middleRightFolder");
            bottomRightFolder.addView("org.eclipse.linuxtools.tmf.ui.views.timechart");
            layout.addPerspectiveShortcut(ID);
            layout.addNewWizardShortcut("org.eclipse.linuxtools.tmf.ui.views.ui.wizards.newProject");
        }
    }

    public static class AlignPerspectiveFactory2
    implements IPerspectiveFactory {
        public static final String ID = "org.eclipse.linuxtools.tmf.test.align.2";

        public void createInitialLayout(IPageLayout layout) {
            if (layout == null) {
                return;
            }
            layout.setEditorAreaVisible(true);
            layout.setEditorAreaVisible(true);
            IFolderLayout topLeftFolder = layout.createFolder("topLeftFolder", 1, 0.15f, "org.eclipse.ui.editorss");
            topLeftFolder.addView("org.eclipse.ui.navigator.ProjectExplorer");
            IFolderLayout middleRightFolder = layout.createFolder("middleRightFolder", 4, 0.1f, "org.eclipse.ui.editorss");
            middleRightFolder.addView("org.eclipse.linuxtools.tmf.ui.views.histogram");
            middleRightFolder.addView("org.eclipse.linuxtools.tmf.ui.views.timechart");
            IFolderLayout bottomRightFolder = layout.createFolder("bottomRightFolder", 4, 0.65f, "middleRightFolder");
            bottomRightFolder.addView("org.eclipse.linuxtools.tmf.ui.views.callstack");
            layout.addPerspectiveShortcut(ID);
            layout.addNewWizardShortcut("org.eclipse.linuxtools.tmf.ui.views.ui.wizards.newProject");
        }
    }

    public static class AlignPerspectiveFactory3
    implements IPerspectiveFactory {
        public static final String ID = "org.eclipse.linuxtools.tmf.test.align.3";

        public void createInitialLayout(IPageLayout layout) {
            if (layout == null) {
                return;
            }
            layout.setEditorAreaVisible(true);
            layout.setEditorAreaVisible(true);
            IFolderLayout topLeftFolder = layout.createFolder("topLeftFolder", 1, 0.15f, "org.eclipse.ui.editorss");
            topLeftFolder.addView("org.eclipse.ui.navigator.ProjectExplorer");
            IFolderLayout bottomLeftFolder = layout.createFolder("bottomLeftFolder", 4, 0.5f, "topLeftFolder");
            bottomLeftFolder.addView("org.eclipse.linuxtools.tmf.ui.views.callstack");
            IFolderLayout middleRightFolder = layout.createFolder("middleRightFolder", 4, 0.1f, "org.eclipse.ui.editorss");
            middleRightFolder.addView("org.eclipse.linuxtools.tmf.ui.views.histogram");
            IFolderLayout bottomRightFolder = layout.createFolder("bottomRightFolder", 4, 0.65f, "middleRightFolder");
            bottomRightFolder.addView("org.eclipse.linuxtools.tmf.ui.views.timechart");
            layout.addPerspectiveShortcut(ID);
            layout.addNewWizardShortcut("org.eclipse.linuxtools.tmf.ui.views.ui.wizards.newProject");
        }
    }

    private static final class SashFormMatcher
    extends BaseMatcher<SashForm> {
        private SashFormMatcher() {
        }

        public boolean matches(Object item) {
            return item instanceof SashForm;
        }

        public void describeTo(Description description) {
        }
    }

    private static final class SashMatcher
    extends BaseMatcher<Sash> {
        private SashMatcher() {
        }

        public boolean matches(Object item) {
            return item instanceof Sash;
        }

        public void describeTo(Description description) {
        }
    }
}

