/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.markers;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.tracecompass.tmf.ui.markers.PeriodicMarkerEventSource;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.MarkerEvent;
import org.junit.Assert;
import org.junit.Test;

public class PeriodicMarkerEventSourceTest {
    private static final @NonNull String CATEGORY = "Category";
    private static final @NonNull RGBA COLOR = new RGBA(255, 0, 0, 64);
    private static final @NonNull RGBA ODD_COLOR = new RGBA(0, 255, 0, 64);
    private static final @NonNull RGBA EVEN_COLOR = new RGBA(0, 0, 255, 64);

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidPeriod() {
        new PeriodicMarkerEventSource(CATEGORY, PeriodicMarkerEventSource.Reference.ZERO, 0.0, 0L, COLOR, false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidRollover() {
        new PeriodicMarkerEventSource(CATEGORY, PeriodicMarkerEventSource.Reference.ZERO, 100.0, -1L, COLOR, false);
    }

    @Test
    public void testLineMarkerEventSource() {
        PeriodicMarkerEventSource source = new PeriodicMarkerEventSource(CATEGORY, PeriodicMarkerEventSource.Reference.ZERO, 100.0, 0L, COLOR, false);
        Assert.assertEquals(Arrays.asList(CATEGORY), (Object)source.getMarkerCategories());
        List<IMarkerEvent> expected = Arrays.asList(new MarkerEvent(null, 0L, 0L, CATEGORY, COLOR, "0", false), new MarkerEvent(null, 100L, 0L, CATEGORY, COLOR, "1", false), new MarkerEvent(null, 200L, 0L, CATEGORY, COLOR, "2", false), new MarkerEvent(null, 300L, 0L, CATEGORY, COLOR, "3", false));
        PeriodicMarkerEventSourceTest.assertMarkerListEquals(expected, source.getMarkerList(CATEGORY, 50L, 250L, 1L, (IProgressMonitor)new NullProgressMonitor()));
    }

    @Test
    public void testAlternateShadingMarkerEventSource() {
        PeriodicMarkerEventSource source = new PeriodicMarkerEventSource(CATEGORY, PeriodicMarkerEventSource.Reference.ZERO, 100.0, 0L, EVEN_COLOR, ODD_COLOR, false);
        Assert.assertEquals(Arrays.asList(CATEGORY), (Object)source.getMarkerCategories());
        List<IMarkerEvent> expected = Arrays.asList(new MarkerEvent(null, 0L, 100L, CATEGORY, EVEN_COLOR, "0", false), new MarkerEvent(null, 100L, 100L, CATEGORY, ODD_COLOR, "1", false), new MarkerEvent(null, 200L, 100L, CATEGORY, EVEN_COLOR, "2", false), new MarkerEvent(null, 300L, 100L, CATEGORY, ODD_COLOR, "3", false));
        PeriodicMarkerEventSourceTest.assertMarkerListEquals(expected, source.getMarkerList(CATEGORY, 50L, 250L, 1L, (IProgressMonitor)new NullProgressMonitor()));
    }

    @Test
    public void testNextPreviousIncluded() {
        PeriodicMarkerEventSource source = new PeriodicMarkerEventSource(CATEGORY, PeriodicMarkerEventSource.Reference.ZERO, 100.0, 0L, COLOR, false);
        List<IMarkerEvent> expected = Arrays.asList(new MarkerEvent(null, -100L, 0L, CATEGORY, COLOR, "-1", false), new MarkerEvent(null, 0L, 0L, CATEGORY, COLOR, "0", false), new MarkerEvent(null, 100L, 0L, CATEGORY, COLOR, "1", false), new MarkerEvent(null, 200L, 0L, CATEGORY, COLOR, "2", false), new MarkerEvent(null, 300L, 0L, CATEGORY, COLOR, "3", false), new MarkerEvent(null, 400L, 0L, CATEGORY, COLOR, "4", false));
        PeriodicMarkerEventSourceTest.assertMarkerListEquals(expected, source.getMarkerList(CATEGORY, 0L, 300L, 1L, (IProgressMonitor)new NullProgressMonitor()));
    }

    @Test
    public void testRollover() {
        PeriodicMarkerEventSource source = new PeriodicMarkerEventSource(CATEGORY, PeriodicMarkerEventSource.Reference.ZERO, 100.0, 4L, COLOR, false);
        List<IMarkerEvent> expected = Arrays.asList(new MarkerEvent(null, -100L, 0L, CATEGORY, COLOR, "3", false), new MarkerEvent(null, 0L, 0L, CATEGORY, COLOR, "0", false), new MarkerEvent(null, 100L, 0L, CATEGORY, COLOR, "1", false), new MarkerEvent(null, 200L, 0L, CATEGORY, COLOR, "2", false), new MarkerEvent(null, 300L, 0L, CATEGORY, COLOR, "3", false), new MarkerEvent(null, 400L, 0L, CATEGORY, COLOR, "0", false));
        PeriodicMarkerEventSourceTest.assertMarkerListEquals(expected, source.getMarkerList(CATEGORY, 0L, 300L, 1L, (IProgressMonitor)new NullProgressMonitor()));
    }

    @Test
    public void testFractionalPeriod() {
        PeriodicMarkerEventSource source = new PeriodicMarkerEventSource(CATEGORY, PeriodicMarkerEventSource.Reference.ZERO, 33.333333333333336, 0L, EVEN_COLOR, ODD_COLOR, false);
        List<IMarkerEvent> expected = Arrays.asList(new MarkerEvent(null, -33L, 33L, CATEGORY, ODD_COLOR, "-1", false), new MarkerEvent(null, 0L, 33L, CATEGORY, EVEN_COLOR, "0", false), new MarkerEvent(null, 33L, 34L, CATEGORY, ODD_COLOR, "1", false), new MarkerEvent(null, 67L, 33L, CATEGORY, EVEN_COLOR, "2", false), new MarkerEvent(null, 100L, 33L, CATEGORY, ODD_COLOR, "3", false), new MarkerEvent(null, 133L, 34L, CATEGORY, EVEN_COLOR, "4", false));
        PeriodicMarkerEventSourceTest.assertMarkerListEquals(expected, source.getMarkerList(CATEGORY, 0L, 100L, 1L, (IProgressMonitor)new NullProgressMonitor()));
    }

    @Test
    public void testSmallPeriod() {
        PeriodicMarkerEventSource source = new PeriodicMarkerEventSource(CATEGORY, PeriodicMarkerEventSource.Reference.ZERO, 0.3333333333333333, 0L, EVEN_COLOR, ODD_COLOR, false);
        List<IMarkerEvent> expected = Arrays.asList(new MarkerEvent(null, -1L, 0L, CATEGORY, ODD_COLOR, "-3", false), new MarkerEvent(null, 0L, 0L, CATEGORY, EVEN_COLOR, "0", false), new MarkerEvent(null, 1L, 0L, CATEGORY, ODD_COLOR, "3", false), new MarkerEvent(null, 2L, 0L, CATEGORY, EVEN_COLOR, "6", false), new MarkerEvent(null, 3L, 0L, CATEGORY, ODD_COLOR, "9", false));
        PeriodicMarkerEventSourceTest.assertMarkerListEquals(expected, source.getMarkerList(CATEGORY, 0L, 2L, 1L, (IProgressMonitor)new NullProgressMonitor()));
    }

    @Test
    public void testReference() {
        PeriodicMarkerEventSource.Reference reference = new PeriodicMarkerEventSource.Reference(250L, 10);
        PeriodicMarkerEventSource source = new PeriodicMarkerEventSource(CATEGORY, reference, 100.0, 0L, COLOR, false);
        List<IMarkerEvent> expected = Arrays.asList(new MarkerEvent(null, -50L, 0L, CATEGORY, COLOR, "7", false), new MarkerEvent(null, 50L, 0L, CATEGORY, COLOR, "8", false), new MarkerEvent(null, 150L, 0L, CATEGORY, COLOR, "9", false), new MarkerEvent(null, 250L, 0L, CATEGORY, COLOR, "10", false), new MarkerEvent(null, 350L, 0L, CATEGORY, COLOR, "11", false));
        PeriodicMarkerEventSourceTest.assertMarkerListEquals(expected, source.getMarkerList(CATEGORY, 0L, 300L, 1L, (IProgressMonitor)new NullProgressMonitor()));
    }

    @Test
    public void testResolution() {
        PeriodicMarkerEventSource source = new PeriodicMarkerEventSource(CATEGORY, PeriodicMarkerEventSource.Reference.ZERO, 10.0, 0L, EVEN_COLOR, ODD_COLOR, false);
        Assert.assertEquals(Arrays.asList(CATEGORY), (Object)source.getMarkerCategories());
        List<IMarkerEvent> expected = Arrays.asList(new MarkerEvent(null, -20L, 10L, CATEGORY, EVEN_COLOR, "-2", false), new MarkerEvent(null, 10L, 10L, CATEGORY, ODD_COLOR, "1", false), new MarkerEvent(null, 40L, 10L, CATEGORY, EVEN_COLOR, "4", false), new MarkerEvent(null, 70L, 10L, CATEGORY, ODD_COLOR, "7", false), new MarkerEvent(null, 100L, 10L, CATEGORY, EVEN_COLOR, "10", false), new MarkerEvent(null, 130L, 10L, CATEGORY, ODD_COLOR, "13", false));
        PeriodicMarkerEventSourceTest.assertMarkerListEquals(expected, source.getMarkerList(CATEGORY, 0L, 100L, 25L, (IProgressMonitor)new NullProgressMonitor()));
    }

    private static void assertMarkerListEquals(@NonNull List<IMarkerEvent> expectedList, @NonNull List<@NonNull IMarkerEvent> markerList) {
        Assert.assertEquals((long)expectedList.size(), (long)markerList.size());
        int i = 0;
        while (i < expectedList.size()) {
            IMarkerEvent expected = expectedList.get(i);
            IMarkerEvent marker = markerList.get(i);
            Assert.assertEquals((String)marker.toString(), (Object)expected.getEntry(), (Object)marker.getEntry());
            Assert.assertEquals((String)marker.toString(), (long)expected.getTime(), (long)marker.getTime());
            Assert.assertEquals((String)marker.toString(), (long)expected.getDuration(), (long)marker.getDuration());
            Assert.assertEquals((String)marker.toString(), (Object)expected.getCategory(), (Object)marker.getCategory());
            Assert.assertEquals((String)marker.toString(), (Object)expected.getLabel(), (Object)marker.getLabel());
            Assert.assertEquals((String)marker.toString(), (Object)expected.getColor(), (Object)marker.getColor());
            ++i;
        }
    }
}

