/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.project.model;

import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfOpenTraceHelper;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.tests.shared.ProjectModelTestData;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProjectModelTraceTest {
    private TmfProjectElement fixture;

    @Before
    public void setUp() {
        try {
            this.fixture = ProjectModelTestData.getFilledProject();
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @After
    public void cleanUp() {
        ProjectModelTestData.deleteProject(this.fixture);
    }

    @Test
    public void testOpenTrace() {
        Assert.assertNotNull((Object)this.fixture);
        TmfTraceElement traceElement = (TmfTraceElement)this.fixture.getTracesFolder().getTraces().get(0);
        ITmfTrace trace = traceElement.getTrace();
        Assert.assertNull((Object)trace);
        TmfOpenTraceHelper.openTraceFromElement((TmfCommonProjectElement)traceElement);
        try {
            ProjectModelTestData.delayUntilTraceOpened((ITmfProjectModelElement)traceElement);
        }
        catch (TimeoutException e) {
            Assert.fail((String)"The trace did not open in a reasonable delay");
        }
        trace = traceElement.getTrace();
        Assert.assertNotNull((Object)trace);
        TmfOpenTraceHelper.openTraceFromElement((TmfCommonProjectElement)traceElement);
        try {
            ProjectModelTestData.delayUntilTraceOpened((ITmfProjectModelElement)traceElement);
        }
        catch (TimeoutException e) {
            Assert.fail((String)"The trace did not open in a reasonable delay");
        }
        ITmfTrace trace2 = TmfTraceManager.getInstance().getActiveTrace();
        Assert.assertTrue((trace2 == trace ? 1 : 0) != 0);
        trace = traceElement.getTrace();
        Assert.assertTrue((trace2 == trace ? 1 : 0) != 0);
    }
}

