/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.markers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEventSource;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.MarkerEvent;

@NonNullByDefault
public class PeriodicMarkerEventSource
implements IMarkerEventSource {
    private final String fCategory;
    private final Reference fReference;
    private final double fPeriod;
    private final long fRollover;
    private final RGBA fColor;
    private final @Nullable RGBA fOddColor;
    private final boolean fForeground;

    public PeriodicMarkerEventSource(String category, Reference reference, double period, long rollover, RGBA color, boolean foreground) {
        this(category, reference, period, rollover, foreground, color, null);
    }

    public PeriodicMarkerEventSource(String category, Reference reference, double period, long rollover, RGBA evenColor, RGBA oddColor, boolean foreground) {
        this(category, reference, period, rollover, foreground, evenColor, oddColor);
    }

    private PeriodicMarkerEventSource(String category, Reference reference, double period, long rollover, boolean foreground, RGBA evenColor, @Nullable RGBA oddColor) {
        if (period <= 0.0) {
            throw new IllegalArgumentException("period cannot be less than or equal to zero");
        }
        if (rollover < 0L) {
            throw new IllegalArgumentException("rollover cannot be less than zero");
        }
        this.fCategory = category;
        this.fReference = reference;
        this.fPeriod = period;
        this.fRollover = rollover;
        this.fColor = evenColor;
        this.fOddColor = oddColor;
        this.fForeground = foreground;
    }

    @Override
    public List<String> getMarkerCategories() {
        return Arrays.asList(this.fCategory);
    }

    @Override
    public List<IMarkerEvent> getMarkerList(String category, long startTime, long endTime, long resolution, IProgressMonitor monitor) {
        if (startTime > endTime) {
            return Collections.emptyList();
        }
        ArrayList<IMarkerEvent> markers = new ArrayList<IMarkerEvent>();
        long time = startTime;
        if (Math.round((double)Math.round((double)(time - this.fReference.time) / this.fPeriod) * this.fPeriod + (double)this.fReference.time) >= time) {
            time = (long)((double)time - Math.max(this.fPeriod, (double)resolution));
        }
        while (true) {
            long index = Math.round((double)(time - this.fReference.time) / this.fPeriod) + (long)this.fReference.index;
            time = Math.round((double)(index - (long)this.fReference.index) * this.fPeriod) + this.fReference.time;
            long labelIndex = index;
            if (this.fRollover != 0L && (labelIndex %= this.fRollover) < 0L) {
                labelIndex += this.fRollover;
            }
            if (this.fOddColor == null) {
                markers.add(new MarkerEvent(null, time, 0L, this.fCategory, this.fColor, this.getMarkerLabel(labelIndex), this.fForeground));
            } else {
                RGBA color = index % 2L == 0L ? this.fColor : this.fOddColor;
                long duration = Math.round((double)(index + 1L - (long)this.fReference.index) * this.fPeriod + (double)this.fReference.time) - time;
                markers.add(new MarkerEvent(null, time, duration, this.fCategory, color, this.getMarkerLabel(labelIndex), this.fForeground));
            }
            if (time > endTime) break;
            time = (long)((double)time + Math.max(this.fPeriod, (double)resolution));
        }
        return markers;
    }

    public String getMarkerLabel(long index) {
        return (String)NonNullUtils.checkNotNull((Object)Long.toString(index));
    }

    public static class Reference {
        public static final Reference ZERO = new Reference(0L, 0);
        private final long time;
        private final int index;

        public Reference(long time, int index) {
            this.time = time;
            this.index = index;
        }
    }
}

