/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitDestructorName;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTImplicitNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTImplicitName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluationOwner;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.DestructorCallCollector;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinary;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;

public class CPPASTBinaryExpression
extends ASTNode
implements ICPPASTBinaryExpression,
IASTAmbiguityParent,
ICPPEvaluationOwner {
    private int fOperator;
    private ICPPASTExpression fOperand1;
    private ICPPASTInitializerClause fOperand2;
    private ICPPEvaluation fEvaluation;
    private IASTImplicitName[] fImplicitNames;
    private IASTImplicitDestructorName[] fImplicitDestructorNames;

    public CPPASTBinaryExpression() {
    }

    public CPPASTBinaryExpression(int op, IASTExpression operand1, IASTInitializerClause operand2) {
        this.fOperator = op;
        this.setOperand1(operand1);
        this.setInitOperand2(operand2);
    }

    @Override
    public CPPASTBinaryExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTBinaryExpression copy(IASTNode.CopyStyle style) {
        CPPASTBinaryExpression copy = new CPPASTBinaryExpression(this.fOperator, this.fOperand1 == null ? null : this.fOperand1.copy(style), this.fOperand2 == null ? null : this.fOperand2.copy(style));
        return this.copy(copy, style);
    }

    @Override
    public int getOperator() {
        return this.fOperator;
    }

    @Override
    public IASTExpression getOperand1() {
        return this.fOperand1;
    }

    @Override
    public IASTInitializerClause getInitOperand2() {
        return this.fOperand2;
    }

    @Override
    public IASTExpression getOperand2() {
        if (this.fOperand2 instanceof IASTExpression) {
            return (IASTExpression)((Object)this.fOperand2);
        }
        return null;
    }

    @Override
    public void setOperator(int op) {
        this.assertNotFrozen();
        this.fOperator = op;
    }

    @Override
    public void setOperand1(IASTExpression expression) {
        this.assertNotFrozen();
        if (expression != null) {
            if (!(expression instanceof ICPPASTExpression)) {
                throw new IllegalArgumentException(expression.getClass().getName());
            }
            expression.setParent(this);
            expression.setPropertyInParent(OPERAND_ONE);
        }
        this.fOperand1 = (ICPPASTExpression)expression;
    }

    public void setInitOperand2(IASTInitializerClause operand) {
        this.assertNotFrozen();
        if (operand != null) {
            if (!(operand instanceof ICPPASTInitializerClause)) {
                throw new IllegalArgumentException(operand.getClass().getName());
            }
            operand.setParent(this);
            operand.setPropertyInParent(OPERAND_TWO);
        }
        this.fOperand2 = (ICPPASTInitializerClause)operand;
    }

    @Override
    public void setOperand2(IASTExpression expression) {
        this.setInitOperand2(expression);
    }

    @Override
    public IASTImplicitName[] getImplicitNames() {
        if (this.fImplicitNames == null) {
            ICPPFunction overload = this.getOverload();
            if (overload == null || overload instanceof CPPImplicitFunction && !(overload instanceof ICPPMethod)) {
                this.fImplicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
            } else {
                CPPASTImplicitName operatorName = new CPPASTImplicitName(overload.getNameCharArray(), (IASTNode)this);
                operatorName.setBinding(overload);
                operatorName.setOperator(true);
                operatorName.computeOperatorOffsets(this.fOperand1, true);
                this.fImplicitNames = new IASTImplicitName[]{operatorName};
            }
        }
        return this.fImplicitNames;
    }

    @Override
    public IASTImplicitDestructorName[] getImplicitDestructorNames() {
        if (this.fImplicitDestructorNames == null) {
            this.fImplicitDestructorNames = DestructorCallCollector.getTemporariesDestructorCalls(this);
        }
        return this.fImplicitDestructorNames;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (this.fOperand1 instanceof IASTBinaryExpression || this.fOperand2 instanceof IASTBinaryExpression) {
            return CPPASTBinaryExpression.acceptWithoutRecursion(this, action);
        }
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.fOperand1 != null && !this.fOperand1.accept(action)) {
            return false;
        }
        if (action.shouldVisitImplicitNames && !CPPASTBinaryExpression.acceptByNodes((IASTNode[])this.getImplicitNames(), (ASTVisitor)action)) {
            return false;
        }
        if (this.fOperand2 != null && !this.fOperand2.accept(action)) {
            return false;
        }
        if (action.shouldVisitImplicitDestructorNames && !CPPASTBinaryExpression.acceptByNodes((IASTNode[])this.getImplicitDestructorNames(), (ASTVisitor)action)) {
            return false;
        }
        return !action.shouldVisitExpressions || action.leave(this) != 2;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean acceptWithoutRecursion(IASTBinaryExpression bexpr, ASTVisitor action) {
        stack = new N(bexpr);
        block4: while (stack != null) {
            block11: {
                expr = stack.fExpression;
                if (stack.fState != 0) break block11;
                if (!action.shouldVisitExpressions) ** GOTO lbl-1000
                switch (action.visit(expr)) {
                    case 2: {
                        return false;
                    }
                    case 1: {
                        stack = stack.fNext;
                        continue block4;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        stack.fState = 1;
                        op1 = expr.getOperand1();
                        if (op1 instanceof IASTBinaryExpression) {
                            n = new N((IASTBinaryExpression)op1);
                            n.fNext = stack;
                            stack = n;
                            continue block4;
                        }
                        if (op1 == null || op1.accept(action)) break;
                        return false;
                    }
                }
            }
            if (stack.fState == 1) {
                if (action.shouldVisitImplicitNames && !CPPASTBinaryExpression.acceptByNodes((IASTNode[])((IASTImplicitNameOwner)expr).getImplicitNames(), (ASTVisitor)action)) {
                    return false;
                }
                stack.fState = 2;
                op2 = expr.getOperand2();
                if (op2 instanceof IASTBinaryExpression) {
                    n = new N((IASTBinaryExpression)op2);
                    n.fNext = stack;
                    stack = n;
                    continue;
                }
                if (op2 != null && !op2.accept(action)) {
                    return false;
                }
            }
            if (action.shouldVisitExpressions && action.leave(expr) == 2) {
                return false;
            }
            stack = stack.fNext;
        }
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.fOperand1) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.fOperand1 = (ICPPASTExpression)other;
        }
        if (child == this.fOperand2) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.fOperand2 = (ICPPASTInitializerClause)other;
        }
    }

    @Override
    public ICPPFunction getOverload() {
        ICPPEvaluation eval = this.getEvaluation();
        if (eval instanceof EvalBinary) {
            return ((EvalBinary)eval).getOverload(this);
        }
        return null;
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        if (this.fEvaluation == null) {
            this.fEvaluation = this.computeEvaluation();
        }
        return this.fEvaluation;
    }

    private ICPPEvaluation computeEvaluation() {
        if (this.fOperand1 == null || this.fOperand2 == null) {
            return EvalFixed.INCOMPLETE;
        }
        ICPPEvaluation eval1 = ((ICPPEvaluationOwner)((Object)this.fOperand1)).getEvaluation();
        ICPPEvaluation eval2 = ((ICPPEvaluationOwner)((Object)this.fOperand2)).getEvaluation();
        return new EvalBinary(this.fOperator, eval1, eval2, this);
    }

    @Override
    public IType getExpressionType() {
        return this.getEvaluation().getType(this);
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return this.getEvaluation().getValueCategory(this);
    }

    @Override
    public boolean isLValue() {
        return this.getValueCategory() == IASTExpression.ValueCategory.LVALUE;
    }

    private static class N {
        final IASTBinaryExpression fExpression;
        int fState;
        N fNext;

        N(IASTBinaryExpression expr) {
            this.fExpression = expr;
        }
    }
}

