/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDecltypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluationOwner;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class CPPASTDecltypeSpecifier
extends ASTNode
implements ICPPASTDecltypeSpecifier,
IASTAmbiguityParent {
    private ICPPASTExpression fDecltypeExpression;
    private char[] fSignature;

    public CPPASTDecltypeSpecifier(ICPPASTExpression decltypeExpression) {
        this.fDecltypeExpression = decltypeExpression;
        this.fDecltypeExpression.setParent(this);
    }

    @Override
    public ICPPASTExpression getDecltypeExpression() {
        return this.fDecltypeExpression;
    }

    @Override
    public CPPASTDecltypeSpecifier copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTDecltypeSpecifier copy(IASTNode.CopyStyle style) {
        CPPASTDecltypeSpecifier copy = new CPPASTDecltypeSpecifier((ICPPASTExpression)this.fDecltypeExpression.copy(style));
        return this.copy(copy, style);
    }

    @Override
    public char[] toCharArray() {
        if (this.fSignature == null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(Keywords.cDECLTYPE);
            buffer.append(Keywords.cpLPAREN);
            buffer.append(((ICPPEvaluationOwner)((Object)this.fDecltypeExpression)).getEvaluation().getSignature());
            buffer.append(Keywords.cpRPAREN);
            int len = buffer.length();
            this.fSignature = new char[len];
            buffer.getChars(0, len, this.fSignature, 0);
        }
        return this.fSignature;
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        if (visitor.shouldVisitDecltypeSpecifiers) {
            switch (visitor.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (!this.fDecltypeExpression.accept(visitor)) {
            return false;
        }
        if (visitor.shouldVisitDecltypeSpecifiers) {
            switch (visitor.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public IBinding resolveBinding() {
        IType type = this.fDecltypeExpression.getExpressionType();
        if ((type = SemanticUtil.getNestedType(type, 8)) instanceof IBinding) {
            return (IBinding)((Object)type);
        }
        return null;
    }

    @Override
    public IBinding resolvePreBinding() {
        return this.resolveBinding();
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.fDecltypeExpression) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.fDecltypeExpression = (ICPPASTExpression)other;
            this.fSignature = null;
        }
    }
}

