/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitDestructorName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IProblemType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTypeIdExpression;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluationOwner;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalUnaryTypeID;

public class CPPASTTypeIdExpression
extends ASTNode
implements ICPPASTTypeIdExpression,
ICPPEvaluationOwner {
    private int fOperator;
    private IASTTypeId fTypeId;
    private ICPPEvaluation fEvaluation;

    public CPPASTTypeIdExpression() {
    }

    public CPPASTTypeIdExpression(int op, IASTTypeId typeId) {
        this.fOperator = op;
        this.setTypeId(typeId);
    }

    @Override
    public CPPASTTypeIdExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTTypeIdExpression copy(IASTNode.CopyStyle style) {
        CPPASTTypeIdExpression copy = new CPPASTTypeIdExpression(this.fOperator, this.fTypeId == null ? null : this.fTypeId.copy(style));
        return this.copy(copy, style);
    }

    @Override
    public int getOperator() {
        return this.fOperator;
    }

    @Override
    public void setOperator(int value) {
        this.assertNotFrozen();
        this.fOperator = value;
    }

    @Override
    public void setTypeId(IASTTypeId typeId) {
        this.assertNotFrozen();
        this.fTypeId = typeId;
        if (typeId != null) {
            typeId.setParent(this);
            typeId.setPropertyInParent(TYPE_ID);
        }
    }

    @Override
    public IASTTypeId getTypeId() {
        return this.fTypeId;
    }

    @Override
    public IASTImplicitDestructorName[] getImplicitDestructorNames() {
        return IASTImplicitDestructorName.EMPTY_NAME_ARRAY;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.fTypeId != null && !this.fTypeId.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        if (this.fEvaluation == null) {
            IType type = CPPVisitor.createType(this.fTypeId);
            this.fEvaluation = type == null || type instanceof IProblemType ? EvalFixed.INCOMPLETE : new EvalUnaryTypeID(this.fOperator, type, this);
        }
        return this.fEvaluation;
    }

    @Override
    public IType getExpressionType() {
        return this.getEvaluation().getType(this);
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return this.getEvaluation().getValueCategory(this);
    }

    @Override
    public boolean isLValue() {
        return this.getValueCategory() == IASTExpression.ValueCategory.LVALUE;
    }
}

