/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPAnnotations;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPVariable;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPField
extends PDOMCPPVariable
implements ICPPField {
    protected static final int FIELD_POSITION_OFFSET = 44;
    protected static final int RECORD_SIZE = 46;

    public PDOMCPPField(PDOMLinkage linkage, PDOMNode parent, ICPPField field, boolean setTypeAndValue) throws CoreException {
        super(linkage, parent, field, setTypeAndValue);
        this.setFieldPosition(field);
    }

    public PDOMCPPField(PDOMLinkage linkage, long bindingRecord) {
        super(linkage, bindingRecord);
    }

    @Override
    public void update(PDOMLinkage linkage, IBinding newBinding, IASTNode point) throws CoreException {
        super.update(linkage, newBinding, point);
        if (newBinding instanceof ICPPField) {
            this.setFieldPosition((ICPPField)newBinding);
        }
    }

    @Override
    protected int getRecordSize() {
        return 46;
    }

    @Override
    public int getNodeType() {
        return 9;
    }

    @Override
    public ICPPClassType getClassOwner() {
        return (ICPPClassType)((Object)this.getOwner());
    }

    @Override
    public int getVisibility() {
        return PDOMCPPAnnotations.getVisibility(this.getAnnotations());
    }

    @Override
    public boolean isMutable() {
        return PDOMCPPAnnotations.isMutable(this.getAnnotations());
    }

    @Override
    public boolean isAuto() {
        return false;
    }

    @Override
    public boolean isExtern() {
        return false;
    }

    @Override
    public boolean isExternC() {
        return false;
    }

    @Override
    public boolean isRegister() {
        return false;
    }

    @Override
    public ICompositeType getCompositeTypeOwner() {
        return this.getClassOwner();
    }

    @Override
    public int getFieldPosition() {
        return Short.toUnsignedInt(this.getShort(this.record + 44L)) - 1;
    }

    private void setFieldPosition(ICPPField field) throws CoreException {
        int shiftedPos = field.getFieldPosition() + 1;
        if ((shiftedPos & 0xFFFF0000) != 0) {
            CCorePlugin.log(new IllegalArgumentException("Invalid field position " + field.getFieldPosition()));
            shiftedPos = 0;
        }
        this.getDB().putShort(this.record + 44L, (short)shiftedPos);
    }
}

