/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.jsch.core.commands;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.internal.jsch.core.JSchConnection;
import org.eclipse.remote.internal.jsch.core.commands.AbstractRemoteCommand;
import org.eclipse.remote.internal.jsch.core.commands.FetchInfoCommand;

public class PutInfoCommand
extends AbstractRemoteCommand<Void> {
    private static final int S_IRUSR = 256;
    private static final int S_IWUSR = 128;
    private static final int S_IXUSR = 64;
    private static final int S_IRGRP = 32;
    private static final int S_IWGRP = 16;
    private static final int S_IXGRP = 8;
    private static final int S_IROTH = 4;
    private static final int S_IWOTH = 2;
    private static final int S_IXOTH = 1;
    private final IPath fRemotePath;
    private final IFileInfo fFileInfo;
    private final int fOptions;

    public PutInfoCommand(JSchConnection connection, IFileInfo info, int options, IPath path) {
        super(connection);
        this.fFileInfo = info;
        this.fOptions = options;
        this.fRemotePath = path;
    }

    @Override
    public Void getResult(IProgressMonitor monitor) throws RemoteConnectionException {
        int newMTime;
        IFileInfo info;
        long oldMTime;
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)30);
        FetchInfoCommand command = new FetchInfoCommand(this.getConnection(), this.fRemotePath);
        String quotedPath = this.quote(this.fRemotePath.toString(), true);
        if ((this.fOptions & 0x400) != 0) {
            this.chmod(this.getPermissions(this.fFileInfo), quotedPath, (IProgressMonitor)subMon.newChild(10));
        }
        if ((this.fOptions & 0x800) != 0 && (oldMTime = (info = command.getResult((IProgressMonitor)subMon.newChild(10))).getLastModified()) != (long)(newMTime = (int)(oldMTime / 1000L))) {
            this.setMTime(newMTime, quotedPath, (IProgressMonitor)subMon.newChild(10));
        }
        return null;
    }

    private void chmod(final int permissions, final String path, IProgressMonitor monitor) throws RemoteConnectionException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        AbstractRemoteCommand.SftpCallable<Void> c = new AbstractRemoteCommand.SftpCallable<Void>((AbstractRemoteCommand)this){

            @Override
            public Void call() throws JSchException, SftpException {
                this.getChannel().chmod(permissions, path);
                return null;
            }
        };
        try {
            c.getResult((IProgressMonitor)subMon.newChild(10));
        }
        catch (SftpException e) {
            throw new RemoteConnectionException(e.getMessage());
        }
    }

    private void setMTime(final int mtime, final String path, IProgressMonitor monitor) throws RemoteConnectionException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        AbstractRemoteCommand.SftpCallable<Void> c = new AbstractRemoteCommand.SftpCallable<Void>((AbstractRemoteCommand)this){

            @Override
            public Void call() throws JSchException, SftpException {
                this.getChannel().setMtime(path, mtime);
                return null;
            }
        };
        try {
            c.getResult((IProgressMonitor)subMon.newChild(10));
        }
        catch (SftpException e) {
            throw new RemoteConnectionException(e.getMessage());
        }
    }

    private int getPermissions(IFileInfo info) {
        int permissions = 0;
        if (info.getAttribute(0x400000)) {
            permissions |= 0x100;
        }
        if (info.getAttribute(0x800000)) {
            permissions |= 0x80;
        }
        if (info.getAttribute(0x1000000)) {
            permissions |= 0x40;
        }
        if (info.getAttribute(0x2000000)) {
            permissions |= 0x20;
        }
        if (info.getAttribute(0x4000000)) {
            permissions |= 0x10;
        }
        if (info.getAttribute(0x8000000)) {
            permissions |= 8;
        }
        if (info.getAttribute(0x10000000)) {
            permissions |= 4;
        }
        if (info.getAttribute(0x20000000)) {
            permissions |= 2;
        }
        if (info.getAttribute(0x40000000)) {
            permissions |= 1;
        }
        return permissions;
    }
}

