/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.views;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.internal.analysis.lami.ui.Activator;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiChartModel;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.viewers.ILamiViewer;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.views.LamiReportViewTabPage;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.views.Messages;

public final class LamiViewerControl {
    private final Action fToggleAction;
    private @Nullable ILamiViewer fViewer;

    public LamiViewerControl(final Composite parent, final LamiReportViewTabPage page) {
        this.fToggleAction = new Action(){

            public void run() {
                ILamiViewer viewer = LamiViewerControl.this.fViewer;
                if (viewer == null) {
                    LamiViewerControl.this.fViewer = ILamiViewer.createLamiTable(parent, page);
                } else {
                    viewer.dispose();
                    LamiViewerControl.this.fViewer = null;
                }
                parent.layout();
            }
        };
        this.fToggleAction.setText(Messages.LamiReportView_ActivateTableAction_ButtonName);
        this.fToggleAction.setToolTipText(Messages.LamiReportView_ActivateTableAction_ButtonTooltip);
        this.fToggleAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/table.gif"));
    }

    public LamiViewerControl(final Composite parent, final LamiReportViewTabPage page, final LamiChartModel graphModel) {
        this.fToggleAction = new Action(){

            public void run() {
                ILamiViewer viewer = LamiViewerControl.this.fViewer;
                if (viewer == null) {
                    LamiViewerControl.this.fViewer = ILamiViewer.createLamiChart(parent, page, graphModel);
                } else {
                    viewer.dispose();
                    LamiViewerControl.this.fViewer = null;
                }
                parent.layout();
            }
        };
        this.fToggleAction.setText(String.valueOf(Messages.LamiReportView_ToggleAction_ButtonNamePrefix) + ' ' + graphModel.getName());
        this.fToggleAction.setToolTipText(Messages.LamiReportView_ToggleAction_ButtonTooltip);
        this.fToggleAction.setImageDescriptor(LamiViewerControl.getIconForGraphType(graphModel.getChartType()));
    }

    public @Nullable ILamiViewer getViewer() {
        return this.fViewer;
    }

    public Action getToggleAction() {
        return this.fToggleAction;
    }

    public void dispose() {
        if (this.fViewer != null) {
            this.fViewer.dispose();
        }
    }

    private static @Nullable ImageDescriptor getIconForGraphType(LamiChartModel.ChartType graphType) {
        switch (graphType) {
            case BAR_CHART: {
                return Activator.getDefault().getImageDescripterFromPath("icons/histogram.gif");
            }
        }
        return Activator.getDefault().getImageDescripterFromPath("icons/histogram.gif");
    }
}

