/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.Activator;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.Messages;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.ControlFlowEntry;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;

public class ControlFlowPresentationProvider
extends TimeGraphPresentationProvider {
    private Integer fAverageCharacterWidth = null;

    public ControlFlowPresentationProvider() {
        super(Messages.ControlFlowView_stateTypeName);
    }

    private static State[] getStateValues() {
        return State.values();
    }

    public StateItem[] getStateTable() {
        State[] states = ControlFlowPresentationProvider.getStateValues();
        StateItem[] stateTable = new StateItem[states.length];
        int i = 0;
        while (i < stateTable.length) {
            State state = states[i];
            stateTable[i] = new StateItem(state.rgb, state.toString());
            ++i;
        }
        return stateTable;
    }

    public int getStateTableIndex(ITimeEvent event) {
        if (event instanceof TimeEvent && ((TimeEvent)event).hasValue()) {
            int status = ((TimeEvent)event).getValue();
            return ControlFlowPresentationProvider.getMatchingState(status).ordinal();
        }
        if (event instanceof NullTimeEvent) {
            return -1;
        }
        return -2;
    }

    public String getEventName(ITimeEvent event) {
        TimeEvent ev;
        if (event instanceof TimeEvent && (ev = (TimeEvent)event).hasValue()) {
            return ControlFlowPresentationProvider.getMatchingState(ev.getValue()).toString();
        }
        return Messages.ControlFlowView_multipleStates;
    }

    private static State getMatchingState(int status) {
        switch (status) {
            case 6: {
                return State.WAIT_UNKNOWN;
            }
            case 1: {
                return State.WAIT_BLOCKED;
            }
            case 5: {
                return State.WAIT_FOR_CPU;
            }
            case 2: {
                return State.USERMODE;
            }
            case 3: {
                return State.SYSCALL;
            }
            case 4: {
                return State.INTERRUPTED;
            }
        }
        return State.UNKNOWN;
    }

    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event) {
        LinkedHashMap<String, String> retMap = new LinkedHashMap<String, String>();
        if (!(event instanceof TimeEvent && ((TimeEvent)event).hasValue() && event.getEntry() instanceof ControlFlowEntry)) {
            return retMap;
        }
        ControlFlowEntry entry = (ControlFlowEntry)event.getEntry();
        ITmfStateSystem ssq = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)entry.getTrace(), (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        if (ssq == null) {
            return retMap;
        }
        int tid = entry.getThreadId();
        try {
            int cpusQuark = ssq.getQuarkAbsolute(new String[]{"CPUs"});
            List cpuQuarks = ssq.getSubAttributes(cpusQuark, false);
            for (Integer cpuQuark : cpuQuarks) {
                ITmfStateValue state;
                int currentThreadId;
                int currentThreadQuark = ssq.getQuarkRelative(cpuQuark.intValue(), new String[]{"Current_thread"});
                ITmfStateInterval interval = ssq.querySingleState(event.getTime(), currentThreadQuark);
                if (interval.getStateValue().isNull() || tid != (currentThreadId = (state = interval.getStateValue()).unboxInt())) continue;
                retMap.put(Messages.ControlFlowView_attributeCpuName, ssq.getAttributeName(cpuQuark.intValue()));
                break;
            }
        }
        catch (AttributeNotFoundException | StateValueTypeException | TimeRangeException e) {
            Activator.getDefault().logError("Error in ControlFlowPresentationProvider", e);
        }
        catch (StateSystemDisposedException e) {
            // empty catch block
        }
        int status = ((TimeEvent)event).getValue();
        if (status == 3) {
            int syscallQuark = ssq.optQuarkRelative(entry.getThreadQuark(), new String[]{"System_call"});
            if (syscallQuark == -2) {
                return retMap;
            }
            try {
                ITmfStateInterval value = ssq.querySingleState(event.getTime(), syscallQuark);
                if (!value.getStateValue().isNull()) {
                    ITmfStateValue state = value.getStateValue();
                    retMap.put(Messages.ControlFlowView_attributeSyscallName, state.toString());
                }
            }
            catch (TimeRangeException e) {
                Activator.getDefault().logError("Error in ControlFlowPresentationProvider", e);
            }
            catch (StateSystemDisposedException stateSystemDisposedException) {
                // empty catch block
            }
        }
        return retMap;
    }

    public void postDrawEvent(ITimeEvent event, Rectangle bounds, GC gc) {
        if (this.fAverageCharacterWidth == null) {
            this.fAverageCharacterWidth = gc.getFontMetrics().getAverageCharWidth();
        }
        if (bounds.width <= this.fAverageCharacterWidth) {
            return;
        }
        if (!(event instanceof TimeEvent)) {
            return;
        }
        ControlFlowEntry entry = (ControlFlowEntry)event.getEntry();
        ITmfStateSystem ss = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)entry.getTrace(), (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        if (ss == null) {
            return;
        }
        int status = ((TimeEvent)event).getValue();
        if (status != 3) {
            return;
        }
        int syscallQuark = ss.optQuarkRelative(entry.getThreadQuark(), new String[]{"System_call"});
        if (syscallQuark == -2) {
            return;
        }
        try {
            ITmfStateInterval value = ss.querySingleState(event.getTime(), syscallQuark);
            if (!value.getStateValue().isNull()) {
                ITmfStateValue state = value.getStateValue();
                gc.setForeground(gc.getDevice().getSystemColor(1));
                int beginIndex = 0;
                ITmfTrace trace = entry.getTrace();
                if (trace instanceof IKernelTrace) {
                    IKernelAnalysisEventLayout layout = ((IKernelTrace)trace).getKernelEventLayout();
                    beginIndex = layout.eventSyscallEntryPrefix().length();
                }
                Utils.drawText((GC)gc, (String)state.toString().substring(beginIndex), (int)bounds.x, (int)bounds.y, (int)bounds.width, (int)bounds.height, (boolean)true, (boolean)true);
            }
        }
        catch (TimeRangeException e) {
            Activator.getDefault().logError("Error in ControlFlowPresentationProvider", e);
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
    }

    private static enum State {
        UNKNOWN(new RGB(100, 100, 100)),
        WAIT_UNKNOWN(new RGB(200, 200, 200)),
        WAIT_BLOCKED(new RGB(200, 200, 0)),
        WAIT_FOR_CPU(new RGB(200, 100, 0)),
        USERMODE(new RGB(0, 200, 0)),
        SYSCALL(new RGB(0, 0, 200)),
        INTERRUPTED(new RGB(200, 0, 100));

        public final RGB rgb;

        private State(RGB rgb) {
            this.rgb = rgb;
        }
    }
}

