/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.resources;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.Activator;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.Messages;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.resources.ResourcesEntry;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.ITmfTimeGraphDrawingHelper;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;

public class ResourcesPresentationProvider
extends TimeGraphPresentationProvider {
    private long fLastThreadId = -1L;
    private Color fColorWhite;
    private Color fColorGray;
    private Integer fAverageCharWidth;

    private static State[] getStateValues() {
        return State.values();
    }

    private static State getEventState(TimeEvent event) {
        if (event.hasValue()) {
            ResourcesEntry entry = (ResourcesEntry)event.getEntry();
            int value = event.getValue();
            if (entry.getType() == ResourcesEntry.Type.CPU) {
                if (value == 0) {
                    return State.IDLE;
                }
                if (value == 2) {
                    return State.USERMODE;
                }
                if (value == 4) {
                    return State.SYSCALL;
                }
                if (value == 16) {
                    return State.IRQ;
                }
                if (value == 8) {
                    return State.SOFT_IRQ;
                }
                if (value == 1) {
                    return State.SOFT_IRQ_RAISED;
                }
            } else {
                if (entry.getType() == ResourcesEntry.Type.IRQ) {
                    return State.IRQ_ACTIVE;
                }
                if (entry.getType() == ResourcesEntry.Type.SOFT_IRQ) {
                    if (value == 1) {
                        return State.SOFT_IRQ_RAISED;
                    }
                    return State.SOFT_IRQ_ACTIVE;
                }
            }
        }
        return null;
    }

    public int getStateTableIndex(ITimeEvent event) {
        State state = ResourcesPresentationProvider.getEventState((TimeEvent)event);
        if (state != null) {
            return state.ordinal();
        }
        if (event instanceof NullTimeEvent) {
            return -1;
        }
        return -2;
    }

    public StateItem[] getStateTable() {
        State[] states = ResourcesPresentationProvider.getStateValues();
        StateItem[] stateTable = new StateItem[states.length];
        int i = 0;
        while (i < stateTable.length) {
            State state = states[i];
            stateTable[i] = new StateItem(state.rgb, state.toString());
            ++i;
        }
        return stateTable;
    }

    public String getEventName(ITimeEvent event) {
        State state = ResourcesPresentationProvider.getEventState((TimeEvent)event);
        if (state != null) {
            return state.toString();
        }
        if (event instanceof NullTimeEvent) {
            return null;
        }
        return Messages.ResourcesView_multipleStates;
    }

    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event, long hoverTime) {
        LinkedHashMap<String, String> retMap = new LinkedHashMap<String, String>();
        if (event instanceof TimeEvent && ((TimeEvent)event).hasValue()) {
            TimeEvent tcEvent = (TimeEvent)event;
            ResourcesEntry entry = (ResourcesEntry)event.getEntry();
            if (tcEvent.hasValue()) {
                ITmfStateSystem ss = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)entry.getTrace(), (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
                if (ss == null) {
                    return retMap;
                }
                if (entry.getType().equals((Object)ResourcesEntry.Type.IRQ) || entry.getType().equals((Object)ResourcesEntry.Type.SOFT_IRQ)) {
                    int cpu = tcEvent.getValue();
                    if (cpu >= 0) {
                        retMap.put(Messages.ResourcesView_attributeCpuName, String.valueOf(cpu));
                    }
                } else if (entry.getType().equals((Object)ResourcesEntry.Type.CPU)) {
                    int status = tcEvent.getValue();
                    if (status == 16) {
                        int cpu = entry.getId();
                        try {
                            List fullState = ss.queryFullState(event.getTime());
                            List irqQuarks = ss.getQuarks(new String[]{"CPUs", Integer.toString(cpu), "IRQs", "*"});
                            Iterator iterator = irqQuarks.iterator();
                            while (iterator.hasNext()) {
                                int irqQuark = (Integer)iterator.next();
                                ITmfStateInterval value = (ITmfStateInterval)fullState.get(irqQuark);
                                if (value.getStateValue().isNull()) continue;
                                String irq = ss.getAttributeName(irqQuark);
                                retMap.put(Messages.ResourcesView_attributeIrqName, irq);
                                break;
                            }
                        }
                        catch (StateValueTypeException | TimeRangeException e) {
                            Activator.getDefault().logError("Error in ResourcesPresentationProvider", e);
                        }
                        catch (StateSystemDisposedException e) {}
                    } else if (status == 8) {
                        int cpu = entry.getId();
                        try {
                            List fullState = ss.queryFullState(event.getTime());
                            List softIrqQuarks = ss.getQuarks(new String[]{"CPUs", Integer.toString(cpu), "Soft_IRQs", "*"});
                            Iterator iterator = softIrqQuarks.iterator();
                            while (iterator.hasNext()) {
                                int softIrqQuark = (Integer)iterator.next();
                                ITmfStateInterval value = (ITmfStateInterval)fullState.get(softIrqQuark);
                                if (value.getStateValue().isNull()) continue;
                                String softIrq = ss.getAttributeName(softIrqQuark);
                                retMap.put(Messages.ResourcesView_attributeSoftIrqName, softIrq);
                                break;
                            }
                        }
                        catch (StateValueTypeException | TimeRangeException e) {
                            Activator.getDefault().logError("Error in ResourcesPresentationProvider", e);
                        }
                        catch (StateSystemDisposedException e) {}
                    } else if (status == 2 || status == 4) {
                        try {
                            retMap.put(Messages.ResourcesView_attributeHoverTime, Utils.formatTime((long)hoverTime, (Utils.TimeFormat)Utils.TimeFormat.CALENDAR, (Utils.Resolution)Utils.Resolution.NANOSEC));
                            int cpuQuark = entry.getQuark();
                            int currentThreadQuark = ss.getQuarkRelative(cpuQuark, new String[]{"Current_thread"});
                            ITmfStateInterval interval = ss.querySingleState(hoverTime, currentThreadQuark);
                            if (!interval.getStateValue().isNull()) {
                                ITmfStateValue value = interval.getStateValue();
                                int currentThreadId = value.unboxInt();
                                retMap.put(Messages.ResourcesView_attributeTidName, Integer.toString(currentThreadId));
                                int execNameQuark = ss.getQuarkAbsolute(new String[]{"Threads", Integer.toString(currentThreadId), "Exec_name"});
                                interval = ss.querySingleState(hoverTime, execNameQuark);
                                if (!interval.getStateValue().isNull()) {
                                    value = interval.getStateValue();
                                    retMap.put(Messages.ResourcesView_attributeProcessName, value.unboxStr());
                                }
                                if (status == 4) {
                                    int syscallQuark = ss.optQuarkAbsolute(new String[]{"Threads", Integer.toString(currentThreadId), "System_call"});
                                    if (syscallQuark == -2) {
                                        return retMap;
                                    }
                                    interval = ss.querySingleState(hoverTime, syscallQuark);
                                    if (!interval.getStateValue().isNull()) {
                                        value = interval.getStateValue();
                                        retMap.put(Messages.ResourcesView_attributeSyscallName, value.unboxStr());
                                    }
                                }
                            }
                        }
                        catch (AttributeNotFoundException | StateValueTypeException | TimeRangeException e) {
                            Activator.getDefault().logError("Error in ResourcesPresentationProvider", e);
                        }
                        catch (StateSystemDisposedException stateSystemDisposedException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return retMap;
    }

    public void postDrawEvent(ITimeEvent event, Rectangle bounds, GC gc) {
        if (this.fColorGray == null) {
            this.fColorGray = gc.getDevice().getSystemColor(15);
        }
        if (this.fColorWhite == null) {
            this.fColorWhite = gc.getDevice().getSystemColor(1);
        }
        if (this.fAverageCharWidth == null) {
            this.fAverageCharWidth = gc.getFontMetrics().getAverageCharWidth();
        }
        ITmfTimeGraphDrawingHelper drawingHelper = this.getDrawingHelper();
        if (bounds.width <= this.fAverageCharWidth) {
            return;
        }
        if (!(event instanceof TimeEvent)) {
            return;
        }
        TimeEvent tcEvent = (TimeEvent)event;
        if (!tcEvent.hasValue()) {
            return;
        }
        ResourcesEntry entry = (ResourcesEntry)event.getEntry();
        if (!entry.getType().equals((Object)ResourcesEntry.Type.CPU)) {
            return;
        }
        int status = tcEvent.getValue();
        if (status != 2 && status != 4) {
            return;
        }
        ITmfStateSystem ss = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)entry.getTrace(), (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        if (ss == null) {
            return;
        }
        long time = event.getTime();
        try {
            while (time < event.getTime() + event.getDuration()) {
                int cpuQuark = entry.getQuark();
                int currentThreadQuark = ss.getQuarkRelative(cpuQuark, new String[]{"Current_thread"});
                ITmfStateInterval tidInterval = ss.querySingleState(time, currentThreadQuark);
                long startTime = Math.max(tidInterval.getStartTime(), event.getTime());
                int x = Math.max(drawingHelper.getXForTime(startTime), bounds.x);
                if (x < bounds.x + bounds.width) {
                    if (!tidInterval.getStateValue().isNull()) {
                        int width;
                        ITmfStateValue value = tidInterval.getStateValue();
                        int currentThreadId = value.unboxInt();
                        long endTime = Math.min(tidInterval.getEndTime() + 1L, event.getTime() + event.getDuration());
                        int xForEndTime = drawingHelper.getXForTime(endTime);
                        if (xForEndTime > bounds.x && (width = Math.min(xForEndTime, bounds.x + bounds.width) - x - 1) > 0) {
                            String attribute = null;
                            int beginIndex = 0;
                            if (status == 2 && (long)currentThreadId != this.fLastThreadId) {
                                attribute = "Exec_name";
                            } else if (status == 4) {
                                attribute = "System_call";
                                ITmfTrace trace = entry.getTrace();
                                if (trace instanceof IKernelTrace) {
                                    IKernelAnalysisEventLayout layout = ((IKernelTrace)trace).getKernelEventLayout();
                                    beginIndex = layout.eventSyscallEntryPrefix().length();
                                }
                            }
                            if (attribute != null) {
                                int quark = ss.optQuarkAbsolute(new String[]{"Threads", Integer.toString(currentThreadId), attribute});
                                if (quark == -2) {
                                    return;
                                }
                                ITmfStateInterval interval = ss.querySingleState(time, quark);
                                if (!interval.getStateValue().isNull()) {
                                    value = interval.getStateValue();
                                    gc.setForeground(this.fColorWhite);
                                    int drawn = Utils.drawText((GC)gc, (String)value.unboxStr().substring(beginIndex), (int)(x + 1), (int)bounds.y, (int)width, (int)bounds.height, (boolean)true, (boolean)true);
                                    if (drawn > 0 && status == 2) {
                                        this.fLastThreadId = currentThreadId;
                                    }
                                }
                            }
                            if (xForEndTime < bounds.x + bounds.width) {
                                gc.setForeground(this.fColorGray);
                                gc.drawLine(xForEndTime, bounds.y + 1, xForEndTime, bounds.y + bounds.height - 2);
                            }
                        }
                    }
                    time = Math.max(tidInterval.getEndTime() + 1L, drawingHelper.getTimeAtX(x + 1));
                    continue;
                }
                break;
            }
        }
        catch (AttributeNotFoundException | StateValueTypeException | TimeRangeException e) {
            Activator.getDefault().logError("Error in ResourcesPresentationProvider", e);
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
    }

    public void postDrawEntry(ITimeGraphEntry entry, Rectangle bounds, GC gc) {
        this.fLastThreadId = -1L;
    }

    private static enum State {
        IDLE(new RGB(200, 200, 200)),
        USERMODE(new RGB(0, 200, 0)),
        SYSCALL(new RGB(0, 0, 200)),
        IRQ(new RGB(200, 0, 100)),
        SOFT_IRQ(new RGB(200, 150, 100)),
        IRQ_ACTIVE(new RGB(200, 0, 100)),
        SOFT_IRQ_RAISED(new RGB(200, 200, 0)),
        SOFT_IRQ_ACTIVE(new RGB(200, 150, 100));

        public final RGB rgb;

        private State(RGB rgb) {
            this.rgb = rgb;
        }
    }
}

