/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.segmentstore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.IAnalysisProgressListener;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.segmentstore.core.SegmentStoreFactory;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.segment.ISegmentAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;

public abstract class AbstractSegmentStoreAnalysisModule
extends TmfAbstractAnalysisModule
implements ISegmentStoreProvider {
    private final ListenerList fListeners = new ListenerList(1);
    private @Nullable ISegmentStore<ISegment> fSegmentStore;

    @Override
    public void addListener(IAnalysisProgressListener listener) {
        this.fListeners.add((Object)listener);
    }

    @Override
    public void removeListener(IAnalysisProgressListener listener) {
        this.fListeners.remove((Object)listener);
    }

    protected Iterable<IAnalysisProgressListener> getListeners() {
        ArrayList<IAnalysisProgressListener> listeners = new ArrayList<IAnalysisProgressListener>();
        Object[] objectArray = this.fListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            if (listener != null) {
                listeners.add((IAnalysisProgressListener)listener);
            }
            ++n2;
        }
        return listeners;
    }

    @Override
    public Iterable<ISegmentAspect> getSegmentAspects() {
        return Collections.emptyList();
    }

    protected @Nullable String getDataFileName() {
        return null;
    }

    protected abstract Object[] readObject(ObjectInputStream var1) throws ClassNotFoundException, IOException;

    protected abstract boolean buildAnalysisSegments(ISegmentStore<ISegment> var1, IProgressMonitor var2) throws TmfAnalysisException;

    @Override
    public @Nullable ISegmentStore<ISegment> getSegmentStore() {
        return this.fSegmentStore;
    }

    public void dispose() {
        super.dispose();
        ISegmentStore<ISegment> store = this.fSegmentStore;
        if (store != null) {
            store.dispose();
        }
    }

    protected boolean executeAnalysis(IProgressMonitor monitor) throws TmfAnalysisException {
        ISegmentStore segmentStore;
        boolean completed;
        ITmfTrace trace = (ITmfTrace)NonNullUtils.checkNotNull((Object)this.getTrace());
        @Nullable String dataFileName = this.getDataFileName();
        if (dataFileName != null) {
            String dir = TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace);
            Path file = Paths.get(dir, dataFileName);
            if (Files.exists(file, new LinkOption[0])) {
                ObjectInputStream ois;
                Throwable throwable;
                block31: {
                    ISegmentStore store;
                    throwable = null;
                    Object var7_11 = null;
                    ois = new ObjectInputStream(Files.newInputStream(file, new OpenOption[0]));
                    Object[] segmentArray = this.readObject(ois);
                    this.fSegmentStore = store = SegmentStoreFactory.createSegmentStore((Object[])NonNullUtils.checkNotNullContents((Object[])segmentArray), (SegmentStoreFactory.SegmentStoreType[])new SegmentStoreFactory.SegmentStoreType[0]);
                    this.sendUpdate((ISegmentStore<ISegment>)store);
                    if (ois == null) break block31;
                    ois.close();
                }
                try {
                    return true;
                }
                catch (Throwable throwable2) {
                    try {
                        if (ois != null) {
                            ois.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        try {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                        catch (IOException | ClassCastException | ClassNotFoundException e) {
                            try {
                                Files.delete(file);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }
        if (!(completed = this.buildAnalysisSegments((ISegmentStore<ISegment>)(segmentStore = SegmentStoreFactory.createSegmentStore((SegmentStoreFactory.SegmentStoreType[])new SegmentStoreFactory.SegmentStoreType[0])), monitor))) {
            return false;
        }
        this.fSegmentStore = segmentStore;
        if (dataFileName != null) {
            String dir = TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace);
            Path file = Paths.get(dir, dataFileName);
            try {
                Throwable throwable = null;
                Object var9_17 = null;
                try (ObjectOutputStream oos = new ObjectOutputStream(Files.newOutputStream(file, new OpenOption[0]));){
                    oos.writeObject(segmentStore.toArray());
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.sendUpdate((ISegmentStore<ISegment>)segmentStore);
        return true;
    }

    protected void sendUpdate(ISegmentStore<ISegment> store) {
        for (IAnalysisProgressListener listener : this.getListeners()) {
            listener.onComplete(this, store);
        }
    }
}

