/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.core.callgraph;

import org.eclipse.tracecompass.analysis.timing.core.segmentstore.statistics.SegmentStoreStatistics;
import org.eclipse.tracecompass.segmentstore.core.ISegment;

public class AggregatedCalledFunctionStatistics
extends SegmentStoreStatistics {
    private long fMaxSelfTime;
    private long fMinSelfTime;
    private double fSelfTimeAverage;
    private double fVariance;
    private ISegment fMaxSegment;
    private ISegment fMinSegment;

    public AggregatedCalledFunctionStatistics(ISegment duration, ISegment selfTime) {
        this.fMaxSelfTime = selfTime.getLength();
        this.fMinSelfTime = selfTime.getLength();
        this.fSelfTimeAverage = selfTime.getLength();
        this.fVariance = 0.0;
        this.fMinSegment = duration;
        this.fMaxSegment = duration;
        this.update(duration);
    }

    public void update(SegmentStoreStatistics statisticsNode, long duration, long selfTime) {
        this.merge(statisticsNode);
        if (this.fMaxSelfTime < selfTime) {
            this.fMaxSelfTime = selfTime;
        }
        if (this.fMinSelfTime > selfTime) {
            this.fMinSelfTime = selfTime;
        }
        double delta = (double)selfTime - this.fSelfTimeAverage;
        this.fSelfTimeAverage += delta / (double)this.getNbSegments();
        this.fVariance += delta * ((double)selfTime - this.fSelfTimeAverage);
    }

    public long getMaxSelfTime() {
        return this.fMaxSelfTime;
    }

    public long getMinSelfTime() {
        return this.fMinSelfTime;
    }

    public double getAverageSelfTime() {
        return this.fSelfTimeAverage;
    }

    public double getStdDevSelfTime() {
        long nbSegments = this.getNbSegments();
        return nbSegments > 2L ? Math.sqrt(this.fVariance / (double)(nbSegments - 1L)) : Double.NaN;
    }

    public void initializeMaxMinSelfTime(long selfTime) {
        this.fMaxSelfTime = selfTime;
        this.fMinSelfTime = selfTime;
        this.fSelfTimeAverage = selfTime;
    }

    @Override
    public ISegment getMaxSegment() {
        return this.fMaxSegment;
    }

    @Override
    public ISegment getMinSegment() {
        return this.fMinSegment;
    }
}

