/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.density;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.density.AbstractSegmentStoreDensityViewer;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.density.ISegmentStoreDensityViewerDataListener;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.density.ZoomOutAction;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.table.AbstractSegmentStoreTableViewer;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;

public abstract class AbstractSegmentStoreDensityView
extends TmfView {
    private static final int[] DEFAULT_WEIGHTS = new int[]{4, 6};
    private @Nullable AbstractSegmentStoreDensityViewer fDensityViewer;
    private @Nullable AbstractSegmentStoreTableViewer fTableViewer;

    public AbstractSegmentStoreDensityView(String viewName) {
        super(viewName);
    }

    public void createPartControl(@Nullable Composite parent) {
        super.createPartControl(parent);
        SashForm sashForm = new SashForm(parent, 0);
        this.fTableViewer = this.createSegmentStoreTableViewer((Composite)sashForm);
        this.fDensityViewer = this.createSegmentStoreDensityViewer((Composite)sashForm);
        this.fDensityViewer.addDataListener(new DataChangedListener());
        sashForm.setWeights(DEFAULT_WEIGHTS);
        ZoomOutAction zoomOut = new ZoomOutAction(this);
        IToolBarManager toolBar = this.getViewSite().getActionBars().getToolBarManager();
        toolBar.add((IAction)zoomOut);
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        if (trace != null) {
            TmfTraceSelectedSignal signal = new TmfTraceSelectedSignal((Object)this, trace);
            if (this.fDensityViewer != null) {
                this.fDensityViewer.traceSelected(signal);
            }
            if (this.fTableViewer != null) {
                this.fTableViewer.traceSelected(signal);
            }
        }
    }

    protected abstract AbstractSegmentStoreTableViewer createSegmentStoreTableViewer(Composite var1);

    protected abstract AbstractSegmentStoreDensityViewer createSegmentStoreDensityViewer(Composite var1);

    public void setFocus() {
        AbstractSegmentStoreDensityViewer viewer = this.fDensityViewer;
        if (viewer != null) {
            viewer.getControl().setFocus();
        }
    }

    public void dispose() {
        AbstractSegmentStoreTableViewer tableViewer;
        AbstractSegmentStoreDensityViewer densityViewer = this.fDensityViewer;
        if (densityViewer != null) {
            densityViewer.dispose();
        }
        if ((tableViewer = this.fTableViewer) != null) {
            tableViewer.dispose();
        }
        super.dispose();
    }

    @VisibleForTesting
    public @Nullable AbstractSegmentStoreDensityViewer getDensityViewer() {
        return this.fDensityViewer;
    }

    @VisibleForTesting
    public @Nullable AbstractSegmentStoreTableViewer getTableViewer() {
        return this.fTableViewer;
    }

    private final class DataChangedListener
    implements ISegmentStoreDensityViewerDataListener {
        private DataChangedListener() {
        }

        @Override
        public void dataChanged(List<ISegment> data) {
            this.updateTableModel(data);
        }

        private void updateTableModel(@Nullable List<ISegment> data) {
            AbstractSegmentStoreTableViewer viewer = AbstractSegmentStoreDensityView.this.fTableViewer;
            if (viewer != null && data != null) {
                viewer.updateModel(data.toArray(new ISegment[0]));
            }
        }

        @Override
        public void dataSelectionChanged(@Nullable List<ISegment> data) {
            this.updateTableModel(data);
        }
    }
}

