/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.scatter;

import com.google.common.primitives.Doubles;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.IAnalysisProgressListener;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.SubSecondTimeWithUnitFormat;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.scatter.Messages;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.scatter.SegmentStoreScatterGraphTooltipProvider;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.segmentstore.core.SegmentComparators;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.ITmfChartTimeProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfBaseProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXLineChartViewer;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;
import org.swtchart.ISeriesSet;
import org.swtchart.LineStyle;

public abstract class AbstractSegmentStoreScatterGraphViewer
extends TmfCommonXLineChartViewer {
    private static final Format FORMAT = new SubSecondTimeWithUnitFormat();
    private final AtomicInteger fDirty = new AtomicInteger();
    private long fPixelSize = -1L;
    private long fPixelStart = 0L;
    private Collection<ISegment> fDisplayData = Collections.EMPTY_LIST;
    private SegmentStoreProviderProgressListener fListener;
    private @Nullable ISegmentStoreProvider fSegmentProvider;
    private @Nullable Job fCompactingJob;

    public AbstractSegmentStoreScatterGraphViewer(Composite parent, String title, String xLabel, String yLabel) {
        super(parent, title, xLabel, yLabel);
        this.setTooltipProvider((TmfBaseProvider)new SegmentStoreScatterGraphTooltipProvider((ITmfChartTimeProvider)this));
        this.fListener = new SegmentStoreProviderProgressListener();
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        this.initializeProvider(trace);
        this.getSwtChart().getLegend().setVisible(false);
        this.getSwtChart().getAxisSet().getYAxis(0).getTick().setFormat(FORMAT);
    }

    private final void initializeProvider(@Nullable ITmfTrace trace) {
        ISegmentStoreProvider segmentStoreProvider;
        if (trace != null && (segmentStoreProvider = this.getSegmentStoreProvider(trace)) != null) {
            segmentStoreProvider.addListener((IAnalysisProgressListener)this.fListener);
            this.setData(segmentStoreProvider);
        }
    }

    public void updateModel(@Nullable ISegmentStore<ISegment> dataInput) {
        TmfTimeRange currentRange = TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange();
        long currentStart = currentRange.getStartTime().toNanos();
        long currentEnd = currentRange.getEndTime().toNanos();
        if (dataInput == null) {
            if (!AbstractSegmentStoreScatterGraphViewer.getDisplay().isDisposed()) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        AbstractSegmentStoreScatterGraphViewer.this.clearContent();
                    }
                });
            }
            this.fDisplayData = Collections.EMPTY_LIST;
        } else {
            Collection elements = (Collection)dataInput.getIntersectingElements(currentStart, currentEnd);
            ArrayList<ISegment> list = new ArrayList<ISegment>(elements);
            Collections.sort(list, SegmentComparators.INTERVAL_START_COMPARATOR);
            this.fDisplayData = list;
        }
        this.setWindowRange(currentStart, currentEnd);
        this.updateContent();
    }

    protected void initializeDataSource() {
        ITmfTrace trace = this.getTrace();
        this.initializeProvider(trace);
        if (trace != null) {
            this.setData(this.getSegmentStoreProvider(trace));
        }
    }

    protected void updateData(long start, long end, int nb, @Nullable IProgressMonitor monitor) {
        int dataSize;
        Collection<ISegment> data = this.fDisplayData;
        int n = dataSize = nb == 0 ? data.size() : nb;
        if (end == start) {
            return;
        }
        ArrayList<Double> xSeries = new ArrayList<Double>(dataSize);
        ArrayList<Double> ySeries = new ArrayList<Double>(dataSize);
        for (ISegment segment : data) {
            xSeries.add(Double.valueOf(segment.getStart() - start));
            ySeries.add(Double.valueOf(segment.getLength()));
        }
        this.setXAxis(Doubles.toArray(xSeries));
        this.setSeries(Messages.SegmentStoreScatterGraphViewer_legend, Doubles.toArray(ySeries));
        this.updateDisplay();
    }

    protected void setWindowRange(long windowStartTime, long windowEndTime) {
        super.setWindowRange(windowStartTime, windowEndTime);
    }

    protected ILineSeries addSeries(@Nullable String seriesName) {
        ISeriesSet seriesSet = this.getSwtChart().getSeriesSet();
        ILineSeries series = (ILineSeries)seriesSet.createSeries(ISeries.SeriesType.LINE, seriesName);
        series.setVisible(true);
        series.enableArea(false);
        series.setLineStyle(LineStyle.NONE);
        series.setSymbolType(ILineSeries.PlotSymbolType.DIAMOND);
        return series;
    }

    public void setData(@Nullable ISegmentStoreProvider provider) {
        if (provider == null) {
            this.updateModel(null);
            return;
        }
        ISegmentStore segStore = provider.getSegmentStore();
        if (segStore != null) {
            this.updateModel((ISegmentStore<ISegment>)segStore);
            this.setSegmentProvider(provider);
            return;
        }
        this.updateModel(null);
        provider.addListener((IAnalysisProgressListener)this.fListener);
        if (provider instanceof IAnalysisModule) {
            ((IAnalysisModule)provider).schedule();
        }
        this.setSegmentProvider(provider);
    }

    protected abstract @Nullable ISegmentStoreProvider getSegmentStoreProvider(ITmfTrace var1);

    @TmfSignalHandler
    public void traceSelected(@Nullable TmfTraceSelectedSignal signal) {
        super.traceSelected(signal);
        if (signal == null) {
            return;
        }
        ITmfTrace trace = signal.getTrace();
        this.setTrace(trace);
        if (trace != null) {
            TmfTimeRange timeRange = TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange();
            this.setWindowRange(timeRange.getStartTime().toNanos(), timeRange.getEndTime().toNanos());
            this.setData(this.getSegmentStoreProvider(trace));
            this.updateContent();
        }
    }

    @TmfSignalHandler
    public void traceOpened(@Nullable TmfTraceOpenedSignal signal) {
        super.traceOpened(signal);
        if (signal == null) {
            return;
        }
        ITmfTrace trace = signal.getTrace();
        this.setTrace(trace);
        if (trace != null) {
            ISegmentStoreProvider segmentStoreProvider = this.getSegmentStoreProvider(trace);
            TmfTimeRange timeRange = TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange();
            this.setWindowRange(timeRange.getStartTime().toNanos(), timeRange.getEndTime().toNanos());
            this.setData(segmentStoreProvider);
        }
    }

    protected void updateContent() {
        this.fDirty.incrementAndGet();
        Job compactingJob = this.fCompactingJob;
        if (compactingJob != null && compactingJob.getState() == 4) {
            compactingJob.cancel();
        }
        this.fCompactingJob = compactingJob = new CompactingSegmentStoreQuery(this.getWindowStartTime(), this.getWindowEndTime());
        compactingJob.schedule();
    }

    @TmfSignalHandler
    public void traceClosed(@Nullable TmfTraceClosedSignal signal) {
        super.traceClosed(signal);
        if (signal != null && TmfTraceManager.getInstance().getActiveTrace() == null) {
            ISegmentStoreProvider provider = this.getSegmentProvider();
            if (provider != null) {
                provider.removeListener((IAnalysisProgressListener)this.fListener);
            }
            this.clearContent();
        }
        this.refresh();
    }

    private @Nullable ISegmentStoreProvider getSegmentProvider() {
        return this.fSegmentProvider;
    }

    private void setSegmentProvider(ISegmentStoreProvider provider) {
        this.fSegmentProvider = provider;
    }

    public boolean isDirty() {
        return super.isDirty() || this.fDirty.get() != 0;
    }

    private final class CompactingSegmentStoreQuery
    extends Job {
        private static final long MAX_POINTS = 1000L;
        private final long fStart;
        private final long fEnd;

        private CompactingSegmentStoreQuery(long start, long end) {
            super(Messages.SegmentStoreScatterGraphViewer_compactTitle);
            this.fStart = start;
            this.fEnd = end;
        }

        protected IStatus run(@Nullable IProgressMonitor monitor) {
            IProgressMonitor statusMonitor = monitor;
            try {
                if (statusMonitor == null) {
                    Status status = new Status(4, "org.eclipse.tracecompass.analysis.timing.ui", "Monitor is null");
                    return status;
                }
                ISegmentStoreProvider segmentProvider = AbstractSegmentStoreScatterGraphViewer.this.getSegmentProvider();
                long startTime = this.fStart;
                long endTime = this.fEnd;
                if (segmentProvider == null) {
                    this.redraw(statusMonitor, startTime, startTime, Collections.EMPTY_LIST);
                    Status status = new Status(2, "org.eclipse.tracecompass.analysis.timing.ui", "segment provider not available");
                    return status;
                }
                ISegmentStore segStore = segmentProvider.getSegmentStore();
                if (segStore == null) {
                    this.redraw(statusMonitor, startTime, startTime, Collections.EMPTY_LIST);
                    Status status = new Status(1, "org.eclipse.tracecompass.analysis.timing.ui", "Segment provider does not have segments");
                    return status;
                }
                AbstractSegmentStoreScatterGraphViewer.this.fPixelStart = startTime;
                AbstractSegmentStoreScatterGraphViewer.this.fPixelSize = Math.max(1L, (endTime - startTime) / 1000L);
                Iterable intersectingElements = segStore.getIntersectingElements(startTime, endTime);
                List<ISegment> list = this.convertIterableToList(intersectingElements, statusMonitor);
                List<ISegment> displayData = !list.isEmpty() ? this.compactList(startTime, list, statusMonitor) : list;
                this.redraw(statusMonitor, startTime, endTime, displayData);
                if (statusMonitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                AbstractSegmentStoreScatterGraphViewer.this.fDirty.decrementAndGet();
            }
        }

        private void redraw(final IProgressMonitor statusMonitor, final long startTime, final long endTime, final List<ISegment> displayData) {
            AbstractSegmentStoreScatterGraphViewer.this.fDisplayData = displayData;
            AbstractSegmentStoreScatterGraphViewer.this.fDirty.incrementAndGet();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractSegmentStoreScatterGraphViewer.this.updateData(startTime, endTime, displayData.size(), statusMonitor);
                    }
                    finally {
                        AbstractSegmentStoreScatterGraphViewer.this.fDirty.decrementAndGet();
                    }
                }
            });
        }

        private List<ISegment> compactList(long startTime, List<ISegment> listToCompact, IProgressMonitor statusMonitor) {
            ArrayList<ISegment> displayData = new ArrayList<ISegment>();
            ISegment last = listToCompact.get(0);
            if (last.getStart() >= startTime) {
                displayData.add(last);
            }
            for (ISegment next : listToCompact) {
                if (next.getStart() < startTime) continue;
                if (statusMonitor.isCanceled()) {
                    return Collections.EMPTY_LIST;
                }
                if (this.overlaps(last, next)) continue;
                displayData.add(next);
                last = next;
            }
            return displayData;
        }

        private List<ISegment> convertIterableToList(Iterable<ISegment> iterable, IProgressMonitor statusMonitor) {
            ArrayList<ISegment> list = new ArrayList<ISegment>();
            for (ISegment seg : iterable) {
                if (statusMonitor.isCanceled()) {
                    return Collections.EMPTY_LIST;
                }
                list.add(seg);
            }
            Collections.sort(list, SegmentComparators.INTERVAL_START_COMPARATOR);
            return list;
        }

        private boolean overlaps(ISegment last, ISegment next) {
            long timePerPix = AbstractSegmentStoreScatterGraphViewer.this.fPixelSize;
            long start = last.getStart();
            long pixelStart = AbstractSegmentStoreScatterGraphViewer.this.fPixelStart;
            long pixelDuration = start - pixelStart;
            long startPixBoundL = pixelDuration / timePerPix * timePerPix + pixelStart;
            long startPixBoundR = startPixBoundL + timePerPix;
            long currentStart = next.getStart();
            if (currentStart >= startPixBoundL && currentStart <= startPixBoundR) {
                long length = last.getLength();
                long lengthNext = next.getLength();
                long lengthLow = length / timePerPix * timePerPix;
                long lengthHigh = lengthLow + timePerPix;
                return lengthNext >= lengthLow && lengthNext <= lengthHigh;
            }
            return false;
        }
    }

    private final class SegmentStoreProviderProgressListener
    implements IAnalysisProgressListener {
        private SegmentStoreProviderProgressListener() {
        }

        public void onComplete(ISegmentStoreProvider segmentProvider, ISegmentStore<ISegment> segmentStore) {
            if (segmentProvider.equals(AbstractSegmentStoreScatterGraphViewer.this.getSegmentProvider())) {
                AbstractSegmentStoreScatterGraphViewer.this.updateModel(segmentStore);
            }
        }
    }
}

