/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.segmentstore.core;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.segmentstore.core.ISegment;

public interface ISegmentStore<E extends ISegment>
extends Collection<E> {
    default public Iterable<E> iterator(Comparator<ISegment> order) {
        return this.getIntersectingElements(Long.MIN_VALUE, Long.MAX_VALUE, order);
    }

    default public Iterable<E> getIntersectingElements(long position) {
        return this.getIntersectingElements(position, position);
    }

    default public Iterable<E> getIntersectingElements(long position, Comparator<ISegment> order) {
        return this.getIntersectingElements(position, position, order);
    }

    public Iterable<E> getIntersectingElements(long var1, long var3);

    default public Iterable<E> getIntersectingElements(long start, long end, final Comparator<ISegment> order) {
        final ArrayList list = Lists.newArrayList(this.getIntersectingElements(start, end));
        return new Iterable<E>(){

            @Override
            public Iterator<@NonNull E> iterator() {
                Collections.sort(list, order);
                return list.iterator();
            }
        };
    }

    public void dispose();

    default public void close(boolean deleteFiles) {
    }

    @Override
    default public boolean remove(@Nullable Object o) {
        throw new UnsupportedOperationException("Segment stores does not support \"remove\"");
    }

    @Override
    default public boolean removeAll(@Nullable Collection<?> c) {
        throw new UnsupportedOperationException("Segment stores does not support \"removeAll\"");
    }

    @Override
    default public boolean retainAll(@Nullable Collection<?> c) {
        throw new UnsupportedOperationException("Segment stores does not support \"retainAll\"");
    }
}

