/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.chart.ui.data;

import java.math.BigDecimal;
import org.eclipse.tracecompass.common.core.NonNullUtils;

public class ChartRange {
    private BigDecimal fMinimum;
    private BigDecimal fMaximum;
    private BigDecimal fRange;

    public ChartRange() {
        this.fMinimum = (BigDecimal)NonNullUtils.checkNotNull((Object)BigDecimal.ZERO);
        this.fMaximum = (BigDecimal)NonNullUtils.checkNotNull((Object)BigDecimal.ONE);
        this.fRange = (BigDecimal)NonNullUtils.checkNotNull((Object)this.getMaximum().subtract(this.getMinimum()));
    }

    public ChartRange(BigDecimal minimum, BigDecimal maximum) {
        this.fMinimum = minimum;
        this.fMaximum = maximum;
        this.fRange = (BigDecimal)NonNullUtils.checkNotNull((Object)maximum.subtract(minimum));
    }

    public BigDecimal getMinimum() {
        return this.fMinimum;
    }

    public BigDecimal getMaximum() {
        return this.fMaximum;
    }

    public BigDecimal getDelta() {
        return this.fRange;
    }

    public boolean isDeltaNull() {
        return this.getDelta().compareTo(BigDecimal.ZERO) == 0;
    }

    public void setMinimum(BigDecimal minimum) {
        this.fMinimum = minimum;
        this.fRange = (BigDecimal)NonNullUtils.checkNotNull((Object)this.getMaximum().subtract(this.getMinimum()));
    }

    public void setMaximum(BigDecimal maximum) {
        this.fMaximum = maximum;
        this.fRange = (BigDecimal)NonNullUtils.checkNotNull((Object)this.getMaximum().subtract(this.getMinimum()));
    }

    public ChartRange clamp() {
        this.fMinimum = this.fMinimum.min(BigDecimal.ZERO);
        return this;
    }
}

