/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.analysis;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisOutput;
import org.eclipse.tracecompass.tmf.core.analysis.ITmfNewAnalysisModuleListener;
import org.eclipse.tracecompass.tmf.core.analysis.TmfNewAnalysisOutputListener;

public class TmfAnalysisModuleOutputs {
    public static final String TMF_ANALYSIS_TYPE_ID = "org.eclipse.linuxtools.tmf.core.analysis";
    public static final String OUTPUT_ELEM = "output";
    public static final String CLASS_ATTR = "class";
    public static final String ID_ATTR = "id";
    public static final String ANALYSIS_ID_ELEM = "analysisId";
    public static final String MODULE_CLASS_ELEM = "analysisModuleClass";
    private static final String LISTENER_ELEM = "listener";

    private TmfAnalysisModuleOutputs() {
    }

    public static Iterable<@NonNull ITmfNewAnalysisModuleListener> getOutputListeners() {
        IConfigurationElement[] config;
        ArrayList<@NonNull ITmfNewAnalysisModuleListener> newModuleListeners = new ArrayList<ITmfNewAnalysisModuleListener>();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(TMF_ANALYSIS_TYPE_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            String elementName = ce.getName();
            ITmfNewAnalysisModuleListener listener = null;
            if (elementName.equals(OUTPUT_ELEM)) {
                listener = TmfAnalysisModuleOutputs.getListenerFromOutputElement(ce);
            } else if (elementName.equals(LISTENER_ELEM)) {
                listener = TmfAnalysisModuleOutputs.getListenerFromListenerElement(ce);
            }
            if (listener != null) {
                newModuleListeners.add(listener);
            }
            ++n2;
        }
        return newModuleListeners;
    }

    private static ITmfNewAnalysisModuleListener getListenerFromOutputElement(IConfigurationElement ce) {
        TmfNewAnalysisOutputListener listener = null;
        try {
            IAnalysisOutput output = (IAnalysisOutput)ce.createExecutableExtension(CLASS_ATTR);
            if (output == null) {
                Activator.logWarning("An output could not be created");
                return listener;
            }
            IConfigurationElement[] iConfigurationElementArray = ce.getChildren();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement childCe = iConfigurationElementArray[n2];
                if (childCe.getName().equals(ANALYSIS_ID_ELEM)) {
                    listener = new TmfNewAnalysisOutputListener(output, childCe.getAttribute(ID_ATTR), null);
                } else if (childCe.getName().equals(MODULE_CLASS_ELEM)) {
                    listener = new TmfNewAnalysisOutputListener(output, null, childCe.createExecutableExtension(CLASS_ATTR).getClass().asSubclass(IAnalysisModule.class));
                }
                ++n2;
            }
        }
        catch (CoreException | InvalidRegistryObjectException e) {
            Activator.logError("Error creating module output listener", e);
        }
        return listener;
    }

    private static ITmfNewAnalysisModuleListener getListenerFromListenerElement(IConfigurationElement ce) {
        ITmfNewAnalysisModuleListener listener = null;
        try {
            listener = (ITmfNewAnalysisModuleListener)ce.createExecutableExtension(CLASS_ATTR);
        }
        catch (CoreException e) {
            Activator.logError("Error creating new module listener", e);
        }
        return listener;
    }
}

