/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.parsers.custom;

import java.io.ByteArrayInputStream;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfBaseAspects;
import org.eclipse.tracecompass.tmf.core.parsers.custom.Messages;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class CustomTraceDefinition {
    public static final int ACTION_SET = 0;
    public static final int ACTION_APPEND = 1;
    public static final int ACTION_APPEND_WITH_SEPARATOR = 2;
    public static final @NonNull String SEPARATOR = " | ";
    @Deprecated
    public static final String TAG_TIMESTAMP = Messages.CustomTraceDefinition_timestampTag;
    @Deprecated
    public static final String TAG_MESSAGE = Messages.CustomTraceDefinition_messageTag;
    @Deprecated
    public static final String TAG_OTHER = Messages.CustomTraceDefinition_otherTag;
    public String categoryName;
    public String definitionName;
    public List<OutputColumn> outputs;
    public String timeStampOutputFormat;

    public String formatTimeStamp(TmfTimestamp timestamp) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.timeStampOutputFormat);
        return simpleDateFormat.format(timestamp.getValue());
    }

    public abstract void save();

    public abstract void save(String var1);

    protected static EntityResolver createEmptyEntityResolver() {
        return new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                String empty = "";
                ByteArrayInputStream bais = new ByteArrayInputStream(empty.getBytes());
                return new InputSource(bais);
            }
        };
    }

    protected static ErrorHandler createErrorHandler() {
        return new ErrorHandler(){

            @Override
            public void error(SAXParseException saxparseexception) throws SAXException {
            }

            @Override
            public void warning(SAXParseException saxparseexception) throws SAXException {
            }

            @Override
            public void fatalError(SAXParseException saxparseexception) throws SAXException {
                throw saxparseexception;
            }
        };
    }

    protected static Map.Entry<@NonNull Tag, @NonNull String> extractTagAndName(Element element, String tagAttribute, String nameAttribute) {
        Tag tag = Tag.fromName(element.getAttribute(tagAttribute));
        String name = element.getAttribute(nameAttribute);
        if (tag == null) {
            if (name.equals(Messages.CustomTraceDefinition_timestampTag)) {
                tag = Tag.TIMESTAMP;
                name = (String)NonNullUtils.checkNotNull((Object)Tag.TIMESTAMP.toString());
            } else if (name.equals(Messages.CustomTraceDefinition_messageTag)) {
                tag = Tag.MESSAGE;
                name = (String)NonNullUtils.checkNotNull((Object)Tag.MESSAGE.toString());
            } else if (name.equals(Messages.CustomXmlTraceDefinition_ignoreTag)) {
                tag = Tag.IGNORE;
                name = (String)NonNullUtils.checkNotNull((Object)Tag.IGNORE.toString());
            } else {
                tag = Tag.OTHER;
            }
        } else if (name.isEmpty()) {
            name = (String)NonNullUtils.checkNotNull((Object)tag.toString());
        }
        return new AbstractMap.SimpleEntry<Tag, String>(tag, name);
    }

    public static class OutputColumn {
        public @NonNull Tag tag;
        public @NonNull String name;

        @Deprecated
        public OutputColumn() {
            this(Tag.IGNORE, "");
        }

        @Deprecated
        public OutputColumn(@NonNull String name) {
            this.tag = Tag.OTHER;
            this.name = name;
        }

        public OutputColumn(@NonNull Tag tag, @NonNull String name) {
            this.tag = tag;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Tag {
        IGNORE(Messages.CustomXmlTraceDefinition_ignoreTag),
        TIMESTAMP(TmfBaseAspects.getTimestampAspect().getName()),
        EVENT_TYPE(TmfBaseAspects.getEventTypeAspect().getName()),
        MESSAGE(Messages.CustomTraceDefinition_messageTag),
        EXTRA_FIELD_NAME(Messages.CustomTraceDefinition_extraFieldNameTag),
        EXTRA_FIELD_VALUE(Messages.CustomTraceDefinition_extraFieldValueTag),
        EXTRA_FIELDS(Messages.CustomExtraFieldsAspect_extraFieldsAspectName),
        OTHER(Messages.CustomTraceDefinition_otherTag);

        private final String fLabel;

        private Tag(String label) {
            this.fLabel = label;
        }

        public String toString() {
            return this.fLabel;
        }

        public static Tag fromLabel(String label) {
            Tag[] tagArray = Tag.values();
            int n = tagArray.length;
            int n2 = 0;
            while (n2 < n) {
                Tag tag = tagArray[n2];
                if (tag.toString().equals(label)) {
                    return tag;
                }
                ++n2;
            }
            return null;
        }

        public static Tag fromName(String name) {
            Tag[] tagArray = Tag.values();
            int n = tagArray.length;
            int n2 = 0;
            while (n2 < n) {
                Tag tag = tagArray[n2];
                if (tag.name().equals(name)) {
                    return tag;
                }
                ++n2;
            }
            return null;
        }
    }
}

