/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.analysis.timing.ui.Activator;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.Messages;
import org.eclipse.tracecompass.tmf.ui.dialog.TmfFileDialogFactory;

public abstract class ExportToTsvAction
extends Action {
    private static final String[] EXTENSTIONS = new String[]{"*.tsv", "*.*"};

    protected String[] getExtension() {
        return EXTENSTIONS;
    }

    public String getText() {
        return String.valueOf(Messages.AbstractSegmentStoreTableView_exportToTsv);
    }

    public String getToolTipText() {
        return String.valueOf(Messages.ExportToTsvAction_exportToTsvToolTip);
    }

    public void run() {
        Shell shell = this.getShell();
        if (shell == null) {
            return;
        }
        FileDialog fd = TmfFileDialogFactory.create((Shell)shell);
        fd.setFilterExtensions(this.getExtension());
        String fileName = fd.open();
        if (fileName == null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileOutputStream fos = new FileOutputStream(fileName);){
                this.exportToTsv(fos);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.getDefault().logError("IO Error " + fileName, e);
        }
    }

    protected abstract @Nullable Shell getShell();

    protected abstract void exportToTsv(OutputStream var1);
}

