/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

public class TarFile {
    private File file;
    private TarArchiveInputStream entryEnumerationStream;
    private TarArchiveEntry curEntry;
    private TarArchiveInputStream entryStream;
    private InputStream internalEntryStream;
    private InputStream fInputStream;

    public TarFile(File file) throws IOException {
        this.file = file;
        this.fInputStream = new FileInputStream(file);
        try {
            this.fInputStream = new GzipCompressorInputStream(this.fInputStream);
        }
        catch (IOException e) {
            this.fInputStream.close();
            this.fInputStream = new FileInputStream(file);
        }
        this.entryEnumerationStream = new TarArchiveInputStream(this.fInputStream);
        try {
            this.curEntry = (TarArchiveEntry)this.entryEnumerationStream.getNextEntry();
            if (!this.curEntry.isCheckSumOK()) {
                throw new IOException("Error detected parsing initial entry header");
            }
        }
        catch (IOException e) {
            this.fInputStream.close();
            throw e;
        }
    }

    public void close() throws IOException {
        if (this.entryEnumerationStream != null) {
            this.entryEnumerationStream.close();
        }
        if (this.internalEntryStream != null) {
            this.internalEntryStream.close();
        }
    }

    public TarFile(String filename) throws IOException {
        this(new File(filename));
    }

    public Enumeration<TarArchiveEntry> entries() {
        return new Enumeration<TarArchiveEntry>(){

            @Override
            public boolean hasMoreElements() {
                return TarFile.this.curEntry != null;
            }

            @Override
            public TarArchiveEntry nextElement() {
                TarArchiveEntry oldEntry = TarFile.this.curEntry;
                try {
                    TarFile.this.curEntry = (TarArchiveEntry)TarFile.this.entryEnumerationStream.getNextEntry();
                }
                catch (IOException e) {
                    TarFile.this.curEntry = null;
                }
                return oldEntry;
            }
        };
    }

    public InputStream getInputStream(TarArchiveEntry entry) throws IOException {
        if (this.entryStream == null || !TarFile.skipToEntry(this.entryStream, entry)) {
            if (this.internalEntryStream != null) {
                this.internalEntryStream.close();
            }
            this.internalEntryStream = new FileInputStream(this.file);
            try {
                this.internalEntryStream = new GzipCompressorInputStream(this.internalEntryStream);
            }
            catch (IOException e) {
                this.internalEntryStream.close();
                this.internalEntryStream = new FileInputStream(this.file);
            }
            this.entryStream = new TarArchiveInputStream(this.internalEntryStream){

                public void close() {
                }
            };
            TarFile.skipToEntry(this.entryStream, entry);
        }
        return this.entryStream;
    }

    private static boolean skipToEntry(TarArchiveInputStream entryStream, TarArchiveEntry entry) throws IOException {
        TarArchiveEntry e = entryStream.getNextTarEntry();
        while (e != null) {
            if (e.equals(entry)) {
                return true;
            }
            e = entryStream.getNextTarEntry();
        }
        return false;
    }

    public String getName() {
        return this.file.getPath();
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

