/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.statesystem;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTimestampFormatUpdateSignal;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfAnalysisModuleWithStateSystems;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractTmfTreeViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeColumnDataProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeViewerEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeColumnData;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeViewerEntry;
import org.eclipse.tracecompass.tmf.ui.views.statesystem.Messages;

public class TmfStateSystemViewer
extends AbstractTmfTreeViewer {
    private static final String EMPTY_STRING = "";
    private static final int DEFAULT_AUTOEXPAND = 2;
    private boolean fFilterStatus = false;
    private long fSelection = 0L;
    private static final int ATTRIBUTE_NAME_COL = 0;
    private static final int QUARK_COL = 1;
    private static final int VALUE_COL = 2;
    private static final int TYPE_COL = 3;
    private static final int START_TIME_COL = 4;
    private static final int END_TIME_COL = 5;
    private static final int ATTRIBUTE_FULLPATH_COL = 6;

    public TmfStateSystemViewer(Composite parent) {
        super(parent, false);
        this.setLabelProvider((IBaseLabelProvider)new StateSystemTreeLabelProvider());
        this.getTreeViewer().setAutoExpandLevel(2);
    }

    @Override
    protected ITmfTreeColumnDataProvider getColumnDataProvider() {
        return new ITmfTreeColumnDataProvider(){

            @Override
            public List<TmfTreeColumnData> getColumnData() {
                ArrayList<TmfTreeColumnData> columns = new ArrayList<TmfTreeColumnData>();
                TmfTreeColumnData column = new TmfTreeColumnData(Messages.TreeNodeColumnLabel);
                columns.add(column);
                column.setComparator(new ViewerComparator(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        TmfTreeViewerEntry n1 = (TmfTreeViewerEntry)e1;
                        TmfTreeViewerEntry n2 = (TmfTreeViewerEntry)e2;
                        return n1.getName().compareTo(n2.getName());
                    }
                });
                columns.add(new TmfTreeColumnData(Messages.QuarkColumnLabel));
                columns.add(new TmfTreeColumnData(Messages.ValueColumnLabel));
                columns.add(new TmfTreeColumnData(Messages.TypeColumnLabel));
                columns.add(new TmfTreeColumnData(Messages.StartTimeColumLabel));
                columns.add(new TmfTreeColumnData(Messages.EndTimeColumLabel));
                columns.add(new TmfTreeColumnData(Messages.AttributePathColumnLabel));
                return columns;
            }
        };
    }

    @Override
    protected ITmfTreeViewerEntry updateElements(long start, long end, boolean selection) {
        if (selection) {
            this.fSelection = start;
        } else {
            TmfTraceContext ctx = TmfTraceManager.getInstance().getCurrentTraceContext();
            this.fSelection = ctx.getSelectionRange().getStartTime().toNanos();
        }
        if (this.getTrace() == null) {
            return null;
        }
        ITmfTreeViewerEntry root = this.getInput();
        if (root == null) {
            root = this.createRoot();
        } else if (this.fFilterStatus) {
            TmfStateSystemViewer.clearStateSystemEntries(root);
        }
        boolean changed = this.updateStateSystemEntries(root, this.fSelection);
        return selection || changed ? root : null;
    }

    private ITmfTreeViewerEntry createRoot() {
        TmfTreeViewerEntry rootEntry = new TmfTreeViewerEntry("root");
        for (ITmfTrace trace : TmfTraceManager.getTraceSetWithExperiment((ITmfTrace)this.getTrace())) {
            rootEntry.addChild(TmfStateSystemViewer.createTraceEntry(trace));
        }
        return rootEntry;
    }

    private static TmfTreeViewerEntry createTraceEntry(ITmfTrace trace) {
        TmfTreeViewerEntry traceEntry = new TmfTreeViewerEntry(trace.getName());
        Iterable modules = trace.getAnalysisModules();
        for (IAnalysisModule module : modules) {
            if (!(module instanceof ITmfAnalysisModuleWithStateSystems)) continue;
            ITmfAnalysisModuleWithStateSystems moduleWithStateSystem = (ITmfAnalysisModuleWithStateSystems)module;
            moduleWithStateSystem.schedule();
            if (!moduleWithStateSystem.waitForInitialization()) continue;
            for (ITmfStateSystem ss : moduleWithStateSystem.getStateSystems()) {
                traceEntry.addChild(new StateSystemEntry(ss));
            }
        }
        return traceEntry;
    }

    private static void clearStateSystemEntries(ITmfTreeViewerEntry root) {
        for (ITmfTreeViewerEntry iTmfTreeViewerEntry : root.getChildren()) {
            for (ITmfTreeViewerEntry iTmfTreeViewerEntry2 : iTmfTreeViewerEntry.getChildren()) {
                iTmfTreeViewerEntry2.getChildren().clear();
            }
        }
    }

    private boolean updateStateSystemEntries(ITmfTreeViewerEntry root, long timestamp) {
        boolean changed = false;
        for (ITmfTreeViewerEntry iTmfTreeViewerEntry : root.getChildren()) {
            for (ITmfTreeViewerEntry iTmfTreeViewerEntry2 : iTmfTreeViewerEntry.getChildren()) {
                StateSystemEntry stateSystemEntry = (StateSystemEntry)iTmfTreeViewerEntry2;
                ITmfStateSystem ss = stateSystemEntry.getSS();
                try {
                    List fullState = ss.queryFullState(timestamp);
                    changed |= this.updateStateEntries(ss, fullState, stateSystemEntry, -1, timestamp);
                }
                catch (TimeRangeException e) {
                    TmfStateSystemViewer.markOutOfRange(stateSystemEntry);
                    changed = true;
                }
                catch (StateSystemDisposedException stateSystemDisposedException) {
                    // empty catch block
                }
            }
        }
        return changed;
    }

    private boolean updateStateEntries(ITmfStateSystem ss, List<ITmfStateInterval> fullState, TmfTreeViewerEntry parent, int parentQuark, long timestamp) {
        boolean changed = false;
        Iterator iterator = ss.getSubAttributes(parentQuark, false).iterator();
        while (iterator.hasNext()) {
            int quark = (Integer)iterator.next();
            if (quark >= fullState.size()) continue;
            ITmfStateInterval interval = fullState.get(quark);
            StateEntry stateEntry = TmfStateSystemViewer.findStateEntry(parent, quark);
            if (stateEntry == null) {
                boolean modified = this.fFilterStatus ? interval.getStartTime() == timestamp : !interval.getStateValue().isNull();
                stateEntry = new StateEntry(ss.getAttributeName(quark), quark, ss.getFullAttributePath(quark), interval.getStateValue(), TmfTimestamp.fromNanos((long)interval.getStartTime()), TmfTimestamp.fromNanos((long)interval.getEndTime()), modified);
                this.updateStateEntries(ss, fullState, stateEntry, quark, timestamp);
                if (this.fFilterStatus && !stateEntry.hasChildren() && interval.getStartTime() != timestamp) continue;
                parent.addChild(stateEntry);
                changed = true;
                continue;
            }
            stateEntry.update(interval.getStateValue(), TmfTimestamp.fromNanos((long)interval.getStartTime()), TmfTimestamp.fromNanos((long)interval.getEndTime()));
            this.updateStateEntries(ss, fullState, stateEntry, quark, timestamp);
        }
        return changed;
    }

    private static StateEntry findStateEntry(TmfTreeViewerEntry parent, int quark) {
        for (ITmfTreeViewerEntry child : parent.getChildren()) {
            StateEntry stateEntry = (StateEntry)child;
            if (stateEntry.getQuark() != quark) continue;
            return stateEntry;
        }
        return null;
    }

    private static void markOutOfRange(ITmfTreeViewerEntry parent) {
        for (ITmfTreeViewerEntry iTmfTreeViewerEntry : parent.getChildren()) {
            if (!(iTmfTreeViewerEntry instanceof StateEntry)) continue;
            ((StateEntry)iTmfTreeViewerEntry).setOutOfRange();
            TmfStateSystemViewer.markOutOfRange(iTmfTreeViewerEntry);
        }
    }

    public void changeFilterStatus() {
        boolean bl = this.fFilterStatus = !this.fFilterStatus;
        if (this.fFilterStatus) {
            this.getTreeViewer().setAutoExpandLevel(-1);
        } else {
            this.getTreeViewer().setAutoExpandLevel(2);
            this.clearContent();
        }
        this.updateContent(this.getSelectionBeginTime(), this.getSelectionEndTime(), true);
    }

    @TmfSignalHandler
    public void timestampFormatUpdated(TmfTimestampFormatUpdateSignal signal) {
        this.updateContent(this.getSelectionBeginTime(), this.getSelectionEndTime(), true);
    }

    private class StateEntry
    extends TmfTreeViewerEntry {
        private final int fQuark;
        private final String fFullPath;
        private @NonNull ITmfTimestamp fStart;
        private @NonNull ITmfTimestamp fEnd;
        private ITmfStateValue fValue;
        private boolean fModified;
        private boolean fOutOfRange;

        public StateEntry(String name, int quark, String fullPath, @NonNull ITmfStateValue value, @NonNull ITmfTimestamp start, ITmfTimestamp end, boolean modified) {
            super(name);
            this.fOutOfRange = false;
            this.fQuark = quark;
            this.fFullPath = fullPath;
            this.fStart = start;
            this.fEnd = end;
            this.fValue = value;
            this.fModified = modified;
        }

        public int getQuark() {
            return this.fQuark;
        }

        public String getFullPath() {
            return this.fFullPath;
        }

        public String getStartTime() {
            if (this.fOutOfRange) {
                return TmfStateSystemViewer.EMPTY_STRING;
            }
            return this.fStart.toString();
        }

        public String getEndTime() {
            if (this.fOutOfRange) {
                return TmfStateSystemViewer.EMPTY_STRING;
            }
            return this.fEnd.toString();
        }

        public String getValue() {
            if (this.fOutOfRange) {
                return Messages.OutOfRangeMsg;
            }
            switch (this.fValue.getType()) {
                case INTEGER: 
                case LONG: 
                case DOUBLE: 
                case STRING: 
                case CUSTOM: {
                    return this.fValue.toString();
                }
            }
            return TmfStateSystemViewer.EMPTY_STRING;
        }

        public String getType() {
            if (this.fOutOfRange) {
                return TmfStateSystemViewer.EMPTY_STRING;
            }
            switch (this.fValue.getType()) {
                case INTEGER: {
                    return Messages.TypeInteger;
                }
                case LONG: {
                    return Messages.TypeLong;
                }
                case DOUBLE: {
                    return Messages.TypeDouble;
                }
                case STRING: {
                    return Messages.TypeString;
                }
                case CUSTOM: {
                    return Messages.TypeCustom;
                }
            }
            return TmfStateSystemViewer.EMPTY_STRING;
        }

        public boolean isModified() {
            return this.fModified;
        }

        public void update(ITmfStateValue value, @NonNull ITmfTimestamp start, @NonNull ITmfTimestamp end) {
            this.fModified = false;
            this.fOutOfRange = false;
            if (!start.equals(this.fStart)) {
                this.fModified = true;
                this.fStart = start;
                this.fEnd = end;
                this.fValue = value;
            }
        }

        public void setOutOfRange() {
            this.fModified = false;
            this.fOutOfRange = true;
        }
    }

    private static class StateSystemEntry
    extends TmfTreeViewerEntry {
        private final @NonNull ITmfStateSystem fSS;

        public StateSystemEntry(@NonNull ITmfStateSystem ss) {
            super(ss.getSSID());
            this.fSS = ss;
        }

        public @NonNull ITmfStateSystem getSS() {
            return this.fSS;
        }
    }

    protected static class StateSystemTreeLabelProvider
    extends AbstractTmfTreeViewer.TreeLabelProvider {
        protected StateSystemTreeLabelProvider() {
        }

        @Override
        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof StateEntry) {
                StateEntry entry = (StateEntry)element;
                switch (columnIndex) {
                    case 0: {
                        return entry.getName();
                    }
                    case 1: {
                        return String.valueOf(entry.getQuark());
                    }
                    case 2: {
                        return entry.getValue();
                    }
                    case 3: {
                        return entry.getType();
                    }
                    case 4: {
                        return entry.getStartTime();
                    }
                    case 5: {
                        return entry.getEndTime();
                    }
                    case 6: {
                        return entry.getFullPath();
                    }
                }
                return TmfStateSystemViewer.EMPTY_STRING;
            }
            return super.getColumnText(element, columnIndex);
        }

        @Override
        public Color getBackground(Object element, int columnIndex) {
            if (element instanceof StateEntry && ((StateEntry)element).isModified()) {
                return Display.getCurrent().getSystemColor(7);
            }
            return super.getBackground(element, columnIndex);
        }
    }
}

