/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ConfigurableLineTracker;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentAdapter;
import org.eclipse.jface.text.IDocumentAdapterExtension;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRepairableDocument;
import org.eclipse.jface.text.ITextStore;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.projection.ProjectionDocument;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.provisional.events.IStructuredDocumentListener;
import org.eclipse.wst.sse.core.internal.provisional.events.NewDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.NoChangeEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentRegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegionList;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.util.Utilities;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.util.Assert;

public class StructuredDocumentToTextAdapter
implements IDocumentAdapter,
IDocumentAdapterExtension {
    private static final String EMPTY_STRING = "";
    private static final boolean redrawBackground = true;
    private ProjectionDocument fChildDocument;
    private IDocument fDocument;
    private IDocument fDocumentClone;
    private final boolean forceRedrawOnRegionChanged = Platform.getWS().equals("gtk");
    private String fOriginalContent;
    private String[] fOriginalLineDelimiters;
    private int fStopRelayingChangesRequests = 0;
    private StyledText fStyledTextWidget;
    TextChangeListener[] fTextChangeListeners;
    protected DocumentListener internalDocumentListener;
    private IStructuredDocumentListener internalStructuredDocumentListener = new StructuredDocumentListener();
    protected StructuredDocumentEvent lastEvent = null;
    List lastEventQueue;
    boolean pendingDocumentChangedEvent;
    private static final boolean DEBUG = false;

    public StructuredDocumentToTextAdapter() {
        this.internalDocumentListener = new DocumentListener();
    }

    public StructuredDocumentToTextAdapter(StyledText styledTextWidget) {
        this.internalDocumentListener = new DocumentListener();
        this.fStyledTextWidget = styledTextWidget;
    }

    private void _setDocument(IDocument newDoc) {
        if (this.fDocument instanceof IStructuredDocument) {
            ((IStructuredDocument)this.fDocument).removeDocumentChangedListener(this.internalStructuredDocumentListener);
        }
        this.fDocument = newDoc;
        if (!this.isStoppedForwardingChanges()) {
            this.fDocumentClone = null;
            this.fOriginalContent = this.getDocument() != null ? this.getDocument().get() : null;
            String[] stringArray = this.fOriginalLineDelimiters = this.getDocument() != null ? this.getDocument().getLegalLineDelimiters() : null;
        }
        if (this.fDocument instanceof IStructuredDocument) {
            ((IStructuredDocument)this.fDocument).addDocumentChangedListener(this.internalStructuredDocumentListener);
        }
    }

    public synchronized void addTextChangeListener(TextChangeListener listener) {
        if (!Utilities.contains((Object[])this.fTextChangeListeners, (Object)listener)) {
            int oldSize = 0;
            if (this.fTextChangeListeners != null) {
                oldSize = this.fTextChangeListeners.length;
            }
            int newSize = oldSize + 1;
            TextChangeListener[] newListeners = new TextChangeListener[newSize];
            if (this.fTextChangeListeners != null) {
                System.arraycopy(this.fTextChangeListeners, 0, newListeners, 0, oldSize);
            }
            newListeners[newSize - 1] = listener;
            this.fTextChangeListeners = newListeners;
        }
    }

    public int getCharCount() {
        int result = 0;
        IDocument doc = this.getDocument();
        if (doc != null) {
            result = this.getSafeDocument().getLength();
        }
        return result;
    }

    private IDocument getClonedDocument() {
        if (this.fDocumentClone == null) {
            String content = this.fOriginalContent == null ? EMPTY_STRING : this.fOriginalContent;
            String[] delims = this.fOriginalLineDelimiters == null ? DefaultLineTracker.DELIMITERS : this.fOriginalLineDelimiters;
            this.fDocumentClone = new DocumentClone(content, delims);
        }
        return this.fDocumentClone;
    }

    Display getDisplay() {
        if (PlatformUI.isWorkbenchRunning()) {
            return PlatformUI.getWorkbench().getDisplay();
        }
        return null;
    }

    protected IDocument getDocument() {
        if (this.fChildDocument == null) {
            return this.fDocument;
        }
        return this.fChildDocument;
    }

    private IRegion getProjectionToMasterRegion(IRegion region) {
        IRegion originalRegion = region;
        if (this.fChildDocument != null) {
            try {
                originalRegion = this.fChildDocument.getProjectionMapping().toOriginRegion(region);
            }
            catch (BadLocationException e) {
                Logger.logException(e);
            }
        }
        return originalRegion;
    }

    private int getMasterToProjectionOffset(int offset) {
        int originalOffset = offset;
        if (this.fChildDocument != null) {
            try {
                originalOffset = this.fChildDocument.getProjectionMapping().toImageOffset(offset);
            }
            catch (BadLocationException e) {
                Logger.logException(e);
            }
        }
        return originalOffset;
    }

    public String getLine(int lineNumber) {
        String result = null;
        if (lineNumber >= this.getLineCount()) {
            result = EMPTY_STRING;
        } else {
            IDocument doc = this.getSafeDocument();
            if (doc == null) {
                result = EMPTY_STRING;
            } else {
                try {
                    IRegion r = doc.getLineInformation(lineNumber);
                    result = r.getLength() > 0 ? doc.get(r.getOffset(), r.getLength()) : EMPTY_STRING;
                }
                catch (BadLocationException badLocationException) {
                    result = EMPTY_STRING;
                }
            }
        }
        return result;
    }

    private void repairLineInformation(IDocument document) {
        if (document instanceof IRepairableDocument) {
            IRepairableDocument repairable = (IRepairableDocument)document;
            repairable.repairLineInformation();
        }
    }

    public int getLineAtOffset(int offset) {
        int result = 0;
        IDocument doc = this.getSafeDocument();
        if (doc != null) {
            try {
                result = doc.getLineOfOffset(offset);
            }
            catch (BadLocationException badLocationException) {
                this.repairLineInformation(doc);
                try {
                    result = doc.getLineOfOffset(offset);
                }
                catch (BadLocationException badLocationException2) {
                    result = 0;
                }
            }
        }
        return result;
    }

    public int getLineCount() {
        int result = 0;
        IDocument doc = this.getSafeDocument();
        if (doc != null) {
            result = doc.getNumberOfLines();
        }
        return result;
    }

    public String getLineDelimiter() {
        String result = null;
        if (this.getParentDocument() instanceof IStructuredDocument) {
            result = ((IStructuredDocument)this.getParentDocument()).getLineDelimiter();
        } else {
            IDocument doc = this.getSafeDocument();
            result = TextUtilities.getDefaultLineDelimiter((IDocument)doc);
        }
        return result;
    }

    public int getOffsetAtLine(int lineIndex) {
        int result = 0;
        IDocument doc = this.getSafeDocument();
        if (doc != null) {
            try {
                result = doc.getLineOffset(lineIndex);
            }
            catch (BadLocationException badLocationException) {
                result = 0;
            }
        }
        return result;
    }

    private IDocument getParentDocument() {
        return this.fDocument;
    }

    private IDocument getSafeDocument() {
        IDocument result = null;
        result = this.isStoppedForwardingChanges() ? this.getClonedDocument() : this.getDocument();
        return result;
    }

    StyledText getStyledTextWidget() {
        return this.fStyledTextWidget;
    }

    public String getTextRange(int start, int length) {
        String result = null;
        try {
            IDocument doc = this.getSafeDocument();
            result = doc.get(start, length);
        }
        catch (BadLocationException badLocationException) {
            result = EMPTY_STRING;
        }
        return result;
    }

    protected void handlePendingEvents() {
        if (this.lastEventQueue == null) {
            return;
        }
        Iterator iterator = this.lastEventQueue.iterator();
        while (iterator.hasNext()) {
            NoChangeEvent noChangeEvent = (NoChangeEvent)iterator.next();
            this.redrawNoChange(noChangeEvent);
        }
        this.lastEventQueue = null;
        this.lastEvent = null;
    }

    boolean isStoppedForwardingChanges() {
        return this.fStopRelayingChangesRequests > 0;
    }

    protected void redrawNoChange(NoChangeEvent structuredDocumentEvent) {
        if (this.isStoppedForwardingChanges()) {
            return;
        }
        int startOffset = structuredDocumentEvent.getOffset();
        int length = structuredDocumentEvent.getLength();
        this.redrawRangeWithLength(startOffset, length);
    }

    protected void redrawNodesReplaced(StructuredDocumentRegionsReplacedEvent structuredDocumentEvent) {
        if (this.isStoppedForwardingChanges()) {
            return;
        }
        IStructuredDocumentRegionList newStructuredDocumentRegions = structuredDocumentEvent.getNewStructuredDocumentRegions();
        int nNewNodes = newStructuredDocumentRegions.getLength();
        if (nNewNodes > 0) {
            IStructuredDocumentRegion firstNode = newStructuredDocumentRegions.item(0);
            IStructuredDocumentRegion lastNode = newStructuredDocumentRegions.item(nNewNodes - 1);
            this.redrawRange(firstNode.getStartOffset(), lastNode.getEndOffset());
        }
    }

    private void redrawRange(final int startModelOffset, final int endModelOffset) {
        if (this.getDocument() == null) {
            return;
        }
        if (this.fChildDocument == null) {
            Runnable runnable = new Runnable(){

                public void run() {
                    StructuredDocumentToTextAdapter.this.getStyledTextWidget().redrawRange(startModelOffset, endModelOffset - startModelOffset, true);
                }
            };
            this.runOnDisplayThreadIfNeedede(runnable);
        } else {
            int high = this.getDocument().getLength();
            int startOffset = this.getMasterToProjectionOffset(startModelOffset);
            int endOffset = this.getMasterToProjectionOffset(endModelOffset);
            if (startOffset < 0) {
                startOffset = 0;
            }
            if (endOffset < 0) {
                endOffset = high;
            }
            int length = endOffset - startOffset;
            final int finalStartOffset = startOffset;
            final int finallength = length;
            Runnable runnable = new Runnable(){

                public void run() {
                    StructuredDocumentToTextAdapter.this.getStyledTextWidget().redrawRange(finalStartOffset, finallength, true);
                }
            };
            this.runOnDisplayThreadIfNeedede(runnable);
        }
    }

    private void redrawRangeWithLength(final int startModelOffset, final int length) {
        if (this.getDocument() == null) {
            return;
        }
        if (this.fChildDocument == null) {
            Runnable runnable = new Runnable(){

                public void run() {
                    StructuredDocumentToTextAdapter.this.getStyledTextWidget().redrawRange(startModelOffset, length, true);
                }
            };
            this.runOnDisplayThreadIfNeedede(runnable);
        } else {
            int endOffset;
            int high = this.getDocument().getLength();
            int startOffset = this.getMasterToProjectionOffset(startModelOffset);
            if (startOffset > high || length < 1) {
                return;
            }
            if (startOffset < 0) {
                startOffset = 0;
            }
            if ((endOffset = startOffset + length - 1) > high) {
                endOffset = high;
            }
            int newLength = endOffset - startOffset;
            final int finalStartOffset = startOffset;
            final int finalNewLength = newLength;
            Runnable runnable = new Runnable(){

                public void run() {
                    StructuredDocumentToTextAdapter.this.getStyledTextWidget().redrawRange(finalStartOffset, finalNewLength, true);
                }
            };
            this.runOnDisplayThreadIfNeedede(runnable);
        }
    }

    protected void redrawRegionChanged(RegionChangedEvent structuredDocumentEvent) {
        if (this.isStoppedForwardingChanges()) {
            return;
        }
        if (this.forceRedrawOnRegionChanged) {
            int startOffset = structuredDocumentEvent.getOffset();
            int endOffset = structuredDocumentEvent.getOffset() + structuredDocumentEvent.getLength();
            try {
                IRegion startLine = structuredDocumentEvent.fDocument.getLineInformationOfOffset(startOffset);
                IRegion endLine = structuredDocumentEvent.fDocument.getLineInformationOfOffset(endOffset);
                if (startLine != null && endLine != null) {
                    this.redrawRange(startLine.getOffset(), endLine.getOffset() + endLine.getLength());
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    protected void redrawRegionsReplaced(RegionsReplacedEvent structuredDocumentEvent) {
        if (this.isStoppedForwardingChanges()) {
            return;
        }
        ITextRegionList newRegions = structuredDocumentEvent.getNewRegions();
        int nRegions = newRegions.size();
        if (nRegions > 0) {
            ITextRegion firstRegion = newRegions.get(0);
            ITextRegion lastRegion = newRegions.get(nRegions - 1);
            IStructuredDocumentRegion flatNode = structuredDocumentEvent.getStructuredDocumentRegion();
            this.redrawRange(flatNode.getStartOffset(firstRegion), flatNode.getEndOffset(lastRegion));
        }
    }

    protected void redrawTextChanged() {
        if (this.lastEvent != null) {
            if (this.lastEvent instanceof StructuredDocumentRegionsReplacedEvent) {
                this.redrawNodesReplaced((StructuredDocumentRegionsReplacedEvent)this.lastEvent);
            }
            if (this.lastEvent instanceof RegionsReplacedEvent) {
                this.redrawRegionsReplaced((RegionsReplacedEvent)this.lastEvent);
            }
            if (this.lastEvent instanceof RegionChangedEvent) {
                this.redrawRegionChanged((RegionChangedEvent)this.lastEvent);
            }
        }
    }

    protected void relayTextChanged() {
        if (this.isStoppedForwardingChanges()) {
            return;
        }
        final TextChangedEvent textChangedEvent = new TextChangedEvent((StyledTextContent)this);
        Runnable runnable = new Runnable(){

            public void run() {
                if (StructuredDocumentToTextAdapter.this.fTextChangeListeners != null) {
                    TextChangeListener[] holdListeners = StructuredDocumentToTextAdapter.this.fTextChangeListeners;
                    int i = 0;
                    while (i < holdListeners.length) {
                        holdListeners[i].textChanged(textChangedEvent);
                        ++i;
                    }
                }
            }
        };
        this.runOnDisplayThreadIfNeedede(runnable);
        this.redrawTextChanged();
    }

    protected void relayTextChanging(int requestedStart, int requestedLength, String requestedChange) {
        if (this.getDocument() == null) {
            return;
        }
        if (this.isStoppedForwardingChanges()) {
            return;
        }
        this.lastEvent = null;
        try {
            final TextChangingEvent textChangingEvent = new TextChangingEvent((StyledTextContent)this);
            textChangingEvent.start = requestedStart;
            textChangingEvent.replaceCharCount = requestedLength;
            textChangingEvent.newCharCount = requestedChange == null ? 0 : requestedChange.length();
            textChangingEvent.replaceLineCount = this.getDocument().getNumberOfLines(requestedStart, requestedLength) - 1;
            textChangingEvent.newText = requestedChange;
            textChangingEvent.newLineCount = requestedChange == null ? 0 : this.getDocument().computeNumberOfLines(requestedChange);
            Runnable runnable = new Runnable(){

                public void run() {
                    if (StructuredDocumentToTextAdapter.this.fTextChangeListeners != null) {
                        TextChangeListener[] holdListeners = StructuredDocumentToTextAdapter.this.fTextChangeListeners;
                        int i = 0;
                        while (i < holdListeners.length) {
                            holdListeners[i].textChanging(textChangingEvent);
                            ++i;
                        }
                    }
                }
            };
            this.runOnDisplayThreadIfNeedede(runnable);
        }
        catch (BadLocationException e) {
            Logger.log(1, e.getMessage());
        }
    }

    protected void relayTextSet() {
        if (this.isStoppedForwardingChanges()) {
            return;
        }
        this.lastEvent = null;
        final TextChangedEvent textChangedEvent = new TextChangedEvent((StyledTextContent)this);
        Runnable runnable = new Runnable(){

            public void run() {
                if (StructuredDocumentToTextAdapter.this.fTextChangeListeners != null) {
                    TextChangeListener[] holdListeners = StructuredDocumentToTextAdapter.this.fTextChangeListeners;
                    int i = 0;
                    while (i < holdListeners.length) {
                        holdListeners[i].textSet(textChangedEvent);
                        ++i;
                    }
                }
            }
        };
        this.runOnDisplayThreadIfNeedede(runnable);
    }

    public synchronized void removeTextChangeListener(final TextChangeListener listener) {
        if (this.fTextChangeListeners != null && listener != null && Utilities.contains((Object[])this.fTextChangeListeners, (Object)listener)) {
            final int oldSize = this.fTextChangeListeners.length;
            int newSize = oldSize - 1;
            final TextChangeListener[] newListeners = new TextChangeListener[newSize];
            Runnable runnable = new Runnable(){

                public void run() {
                    int index = 0;
                    int i = 0;
                    while (i < oldSize) {
                        if (StructuredDocumentToTextAdapter.this.fTextChangeListeners[i] != listener) {
                            newListeners[index++] = StructuredDocumentToTextAdapter.this.fTextChangeListeners[i];
                        }
                        ++i;
                    }
                }
            };
            this.runOnDisplayThreadIfNeedede(runnable);
            this.fTextChangeListeners = newListeners;
        }
    }

    public void replaceTextRange(int start, int replaceLength, String text) {
        IRegion region;
        if (this.getParentDocument() instanceof IStructuredDocument && (region = this.getProjectionToMasterRegion((IRegion)new Region(start, replaceLength))) != null) {
            ((IStructuredDocument)this.getParentDocument()).replaceText((Object)this, region.getOffset(), region.getLength(), text);
            return;
        }
        try {
            this.getDocument().replace(start, replaceLength, text);
        }
        catch (BadLocationException e) {
            Logger.log(1, e.getMessage());
        }
    }

    public void resumeForwardingDocumentChanges() {
        --this.fStopRelayingChangesRequests;
        if (this.fStopRelayingChangesRequests == 0) {
            this.fDocumentClone = null;
            this.fOriginalContent = null;
            this.fOriginalLineDelimiters = null;
            this.relayTextSet();
        }
    }

    /*
     * Exception decompiling
     */
    private void runOnDisplayThreadIfNeedede(Runnable r) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 92->98)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setDocument(IDocument document) {
        if (this.getDocument() != null) {
            this.getDocument().removePrenotifiedDocumentListener((IDocumentListener)this.internalDocumentListener);
        }
        this.lastEvent = null;
        if (document instanceof ProjectionDocument) {
            this.fChildDocument = (ProjectionDocument)document;
            this._setDocument(this.fChildDocument.getMasterDocument());
        } else {
            this.fChildDocument = null;
            this._setDocument(document);
        }
        if (this.getDocument() != null) {
            this.getDocument().addPrenotifiedDocumentListener((IDocumentListener)this.internalDocumentListener);
        }
    }

    public void setText(String string) {
        if (this.isStoppedForwardingChanges()) {
            this.fDocumentClone = null;
            this.fOriginalContent = this.getDocument().get();
            this.fOriginalLineDelimiters = this.getDocument().getLegalLineDelimiters();
        } else if (this.getParentDocument() instanceof IStructuredDocument) {
            ((IStructuredDocument)this.getDocument()).setText((Object)this, string);
        } else {
            this.getDocument().set(string);
        }
        this.relayTextSet();
    }

    public void setWidget(StyledText widget) {
        this.fStyledTextWidget = widget;
    }

    public void stopForwardingDocumentChanges() {
        ++this.fStopRelayingChangesRequests;
        if (this.fStopRelayingChangesRequests == 1) {
            this.fDocumentClone = null;
            this.fOriginalContent = this.getDocument().get();
            this.fOriginalLineDelimiters = this.getDocument().getLegalLineDelimiters();
        }
    }

    private class DocumentClone
    extends AbstractDocument {
        public DocumentClone(String content, String[] lineDelimiters) {
            this.setTextStore(new StringTextStore(content));
            ConfigurableLineTracker tracker = new ConfigurableLineTracker(lineDelimiters);
            this.setLineTracker((ILineTracker)tracker);
            this.getTracker().set(content);
            this.completeInitialization();
        }
    }

    class DocumentListener
    implements IDocumentListener {
        protected boolean allTextChanged = false;
        protected DocumentEvent currentEvent;

        DocumentListener() {
        }

        public synchronized void documentAboutToBeChanged(DocumentEvent event) {
            if (StructuredDocumentToTextAdapter.this.isStoppedForwardingChanges()) {
                return;
            }
            StructuredDocumentToTextAdapter.this.pendingDocumentChangedEvent = true;
            this.allTextChanged = event.getOffset() <= 0 && event.getLength() >= StructuredDocumentToTextAdapter.this.getDocument().getLength();
            this.currentEvent = event;
            StructuredDocumentToTextAdapter.this.relayTextChanging(event.getOffset(), event.getLength(), event.getText());
        }

        public synchronized void documentChanged(DocumentEvent event) {
            if (StructuredDocumentToTextAdapter.this.isStoppedForwardingChanges()) {
                return;
            }
            if (this.currentEvent != null && event == this.currentEvent) {
                if (this.allTextChanged) {
                    StructuredDocumentToTextAdapter.this.relayTextSet();
                } else {
                    StructuredDocumentToTextAdapter.this.relayTextChanged();
                }
            }
            this.currentEvent = null;
            StructuredDocumentToTextAdapter.this.pendingDocumentChangedEvent = false;
            StructuredDocumentToTextAdapter.this.handlePendingEvents();
            StructuredDocumentToTextAdapter.this.lastEvent = null;
        }
    }

    private static class StringTextStore
    implements ITextStore {
        private String fContent;

        public StringTextStore(String content) {
            Assert.isNotNull(content, "content can not be null when setting text store");
            this.fContent = content;
        }

        public char get(int offset) {
            return this.fContent.charAt(offset);
        }

        public String get(int offset, int length) {
            return this.fContent.substring(offset, offset + length);
        }

        public int getLength() {
            return this.fContent.length();
        }

        public void replace(int offset, int length, String text) {
        }

        public void set(String text) {
        }
    }

    class StructuredDocumentListener
    implements IStructuredDocumentListener {
        StructuredDocumentListener() {
        }

        public void newModel(NewDocumentEvent structuredDocumentEvent) {
            if (StructuredDocumentToTextAdapter.this.isStoppedForwardingChanges()) {
                return;
            }
            StructuredDocumentToTextAdapter.this.lastEvent = structuredDocumentEvent;
        }

        public void noChange(NoChangeEvent structuredDocumentEvent) {
            if (structuredDocumentEvent.reason == 4) {
                if (StructuredDocumentToTextAdapter.this.pendingDocumentChangedEvent) {
                    if (StructuredDocumentToTextAdapter.this.lastEventQueue == null) {
                        StructuredDocumentToTextAdapter.this.lastEventQueue = new ArrayList();
                    }
                    StructuredDocumentToTextAdapter.this.lastEventQueue.add(structuredDocumentEvent);
                } else {
                    StructuredDocumentToTextAdapter.this.lastEvent = structuredDocumentEvent;
                }
            }
        }

        public void nodesReplaced(StructuredDocumentRegionsReplacedEvent structuredDocumentEvent) {
            if (StructuredDocumentToTextAdapter.this.isStoppedForwardingChanges()) {
                return;
            }
            StructuredDocumentToTextAdapter.this.lastEvent = structuredDocumentEvent;
        }

        public void regionChanged(RegionChangedEvent structuredDocumentEvent) {
            if (StructuredDocumentToTextAdapter.this.isStoppedForwardingChanges()) {
                return;
            }
            StructuredDocumentToTextAdapter.this.lastEvent = structuredDocumentEvent;
        }

        public void regionsReplaced(RegionsReplacedEvent structuredDocumentEvent) {
            if (StructuredDocumentToTextAdapter.this.isStoppedForwardingChanges()) {
                return;
            }
            StructuredDocumentToTextAdapter.this.lastEvent = structuredDocumentEvent;
        }
    }
}

