/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.format;

import java.math.BigDecimal;
import java.text.FieldPosition;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.format.DecimalUnitFormat;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.viewers.LamiGraphRange;

public class LamiDecimalUnitFormat
extends DecimalUnitFormat {
    private static final int BIG_DECIMAL_DIVISION_SCALE = 22;
    private static final long serialVersionUID = 977671266270661188L;
    private @Nullable LamiGraphRange fInternalRange = null;
    private @Nullable LamiGraphRange fExternalRange = null;

    public LamiDecimalUnitFormat() {
    }

    public LamiDecimalUnitFormat(LamiGraphRange internalRange, LamiGraphRange externalRange) {
        this.fInternalRange = internalRange;
        this.fExternalRange = externalRange;
    }

    public LamiDecimalUnitFormat(double factor) {
        super(factor);
    }

    public LamiDecimalUnitFormat(double factor, LamiGraphRange internalRange, LamiGraphRange externalRange) {
        super(factor);
        this.fInternalRange = internalRange;
        this.fExternalRange = externalRange;
    }

    public @Nullable LamiGraphRange getInternalRange() {
        return this.fInternalRange;
    }

    public void setInternalRange(@Nullable LamiGraphRange internalRange) {
        this.fInternalRange = internalRange;
    }

    public @Nullable LamiGraphRange getExternalRange() {
        return this.fExternalRange;
    }

    public void setExternalRange(@Nullable LamiGraphRange externalRange) {
        this.fExternalRange = externalRange;
    }

    public StringBuffer format(@Nullable Object obj, @Nullable StringBuffer toAppendTo, @Nullable FieldPosition pos) {
        if (!(obj instanceof Number) || toAppendTo == null) {
            throw new IllegalArgumentException("Cannot format given Object as a Number: " + obj);
        }
        @Nullable LamiGraphRange internalRange = this.fInternalRange;
        @Nullable LamiGraphRange externalRange = this.fExternalRange;
        if (internalRange == null || externalRange == null) {
            StringBuffer buffer = super.format(obj, toAppendTo, pos);
            return buffer == null ? new StringBuffer() : buffer;
        }
        if (internalRange.getDelta().compareTo(BigDecimal.ZERO) == 0) {
            StringBuffer buffer = super.format((Object)externalRange.getMinimum().doubleValue(), toAppendTo, pos);
            return buffer == null ? new StringBuffer() : buffer;
        }
        if (externalRange.getDelta().compareTo(BigDecimal.ZERO) == 0) {
            StringBuffer buffer = super.format((Object)externalRange.getMinimum().doubleValue(), toAppendTo, pos);
            return buffer == null ? new StringBuffer() : buffer;
        }
        BigDecimal externalValue = new BigDecimal(obj.toString()).subtract(internalRange.getMinimum()).multiply(externalRange.getDelta()).divide(internalRange.getDelta(), 22, 1).add(externalRange.getMinimum());
        Double value = externalValue.doubleValue();
        StringBuffer buffer = super.format((Object)value, toAppendTo, pos);
        return buffer == null ? new StringBuffer() : buffer;
    }
}

