/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.progress.AbstractProgressViewer;
import org.eclipse.ui.internal.progress.FinishedJobs;
import org.eclipse.ui.internal.progress.GroupInfo;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressContentProvider;
import org.eclipse.ui.progress.WorkbenchJob;

public class ProgressViewerContentProvider
extends ProgressContentProvider {
    protected AbstractProgressViewer progressViewer;
    private FinishedJobs.KeptJobsListener keptJobListener;
    private boolean showFinished;

    public ProgressViewerContentProvider(AbstractProgressViewer structured, boolean debug, boolean showFinished) {
        super(debug);
        this.progressViewer = structured;
        this.showFinished = showFinished;
        if (showFinished) {
            FinishedJobs.getInstance().addListener(this.getKeptJobListener());
        }
    }

    private FinishedJobs.KeptJobsListener getKeptJobListener() {
        this.keptJobListener = new FinishedJobs.KeptJobsListener(){

            @Override
            public void finished(JobTreeElement jte) {
                final JobTreeElement element = jte;
                WorkbenchJob updateJob = new WorkbenchJob("Refresh finished"){

                    @Override
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        ProgressViewerContentProvider.this.refresh(new Object[]{element});
                        return Status.OK_STATUS;
                    }

                    @Override
                    public boolean shouldSchedule() {
                        return !(this).ProgressViewerContentProvider.this.progressViewer.getControl().isDisposed();
                    }

                    @Override
                    public boolean shouldRun() {
                        return !(this).ProgressViewerContentProvider.this.progressViewer.getControl().isDisposed();
                    }
                };
                updateJob.setSystem(true);
                updateJob.schedule();
            }

            @Override
            public void removed(JobTreeElement jte) {
                final JobTreeElement element = jte;
                WorkbenchJob updateJob = new WorkbenchJob("Remove finished"){

                    @Override
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (element == null) {
                            ProgressViewerContentProvider.this.refresh();
                        } else {
                            ProgressViewerContentProvider.this.remove(new Object[]{element});
                        }
                        return Status.OK_STATUS;
                    }
                };
                updateJob.setSystem(true);
                updateJob.schedule();
            }
        };
        return this.keptJobListener;
    }

    @Override
    public void refresh() {
        this.progressViewer.refresh(true);
    }

    @Override
    public void refresh(Object[] elements) {
        Object[] refreshes = this.getRoots(elements, true);
        int i = 0;
        while (i < refreshes.length) {
            this.progressViewer.refresh(refreshes[i], true);
            ++i;
        }
    }

    @Override
    public Object[] getElements(Object inputElement) {
        Object[] elements = super.getElements(inputElement);
        if (!this.showFinished) {
            return elements;
        }
        Set kept = FinishedJobs.getInstance().getKeptAsSet();
        if (kept.size() == 0) {
            return elements;
        }
        HashSet<Object> all = new HashSet<Object>();
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            all.add(element);
            ++i;
        }
        for (JobTreeElement next : kept) {
            if (next.getParent() != null && all.contains(next.getParent())) continue;
            all.add(next);
        }
        return all.toArray();
    }

    private Object[] getRoots(Object[] elements, boolean subWithParent) {
        if (elements.length == 0) {
            return elements;
        }
        HashSet<JobTreeElement> roots = new HashSet<JobTreeElement>();
        int i = 0;
        while (i < elements.length) {
            JobTreeElement element = (JobTreeElement)elements[i];
            if (element.isJobInfo()) {
                GroupInfo group = ((JobInfo)element).getGroupInfo();
                if (group == null) {
                    roots.add(element);
                } else if (subWithParent) {
                    roots.add(group);
                }
            } else {
                roots.add(element);
            }
            ++i;
        }
        return roots.toArray();
    }

    @Override
    public void add(Object[] elements) {
        this.progressViewer.add(elements);
    }

    @Override
    public void remove(Object[] elements) {
        this.progressViewer.remove(elements);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.keptJobListener != null) {
            FinishedJobs.getInstance().removeListener(this.keptJobListener);
        }
    }
}

