/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.TabFolderDrawData;
import org.eclipse.swt.internal.theme.Theme;

public class TabItemDrawData
extends DrawData {
    public TabFolderDrawData parent;
    public int position;
    static final int TAB_CURVATURE = 1;

    public TabItemDrawData() {
        this.state = new int[1];
    }

    @Override
    Rectangle computeTrim(Theme theme, GC gc) {
        long notebookHandle = theme.notebookHandle;
        long gtkStyle = this.gtk_widget_get_style(notebookHandle);
        int hborder = theme.getWidgetProperty(notebookHandle, "tab-hborder");
        int vborder = theme.getWidgetProperty(notebookHandle, "tab-vborder");
        int focus_width = theme.getWidgetProperty(notebookHandle, "focus-line-width");
        int xthickness = OS.gtk_style_get_xthickness(gtkStyle);
        int ythickness = OS.gtk_style_get_ythickness(gtkStyle);
        int borderX = xthickness + 1 + focus_width + hborder;
        int borderY = ythickness + 1 + focus_width + vborder;
        int x = this.clientArea.x - borderX;
        int y = this.clientArea.y - borderY;
        int width = this.clientArea.width + 2 * borderX;
        int height = this.clientArea.height + 2 * borderY;
        return new Rectangle(x, y, width, height);
    }

    @Override
    void draw(Theme theme, GC gc, Rectangle bounds) {
        long notebookHandle = theme.notebookHandle;
        long gtkStyle = this.gtk_widget_get_style(notebookHandle);
        long drawable = OS.GTK3 ? gc.getGCData().cairo : gc.getGCData().drawable;
        theme.transferClipping(gc, gtkStyle);
        int x = bounds.x;
        int y = bounds.y;
        int width = bounds.width;
        int height = bounds.height;
        if ((this.state[0] & 2) == 0) {
            if ((this.parent.style & 0x400) == 0) {
                ++y;
            }
            --height;
        }
        int gap_side = 3;
        if ((this.parent.style & 0x400) != 0) {
            gap_side = 2;
        }
        int state_type = this.getStateType(0);
        byte[] detail = Converter.wcsToMbcs(null, "tab", true);
        this.gtk_render_extension(gtkStyle, drawable, state_type, 2, null, notebookHandle, detail, x, y, width, height, gap_side);
        if (this.clientArea != null) {
            int hborder = theme.getWidgetProperty(notebookHandle, "tab-hborder");
            int vborder = theme.getWidgetProperty(notebookHandle, "tab-vborder");
            int focus_line_width = theme.getWidgetProperty(notebookHandle, "focus-line-width");
            int xthickness = OS.gtk_style_get_xthickness(gtkStyle);
            int ythickness = OS.gtk_style_get_ythickness(gtkStyle);
            int borderX = xthickness + 1 + focus_line_width + hborder;
            int borderY = ythickness + 1 + focus_line_width + vborder;
            this.clientArea.x = bounds.x + borderX;
            this.clientArea.y = bounds.y + borderY;
            this.clientArea.width = bounds.width - 2 * borderX;
            this.clientArea.height = bounds.height - 2 * borderY;
        }
    }

    @Override
    int getStateType(int part) {
        int state = this.state[part];
        int state_type = 1;
        if ((state & 2) != 0) {
            state_type = 0;
        }
        return state_type;
    }

    @Override
    int hit(Theme theme, Point position, Rectangle bounds) {
        return bounds.contains(position) ? 0 : -1;
    }

    void gtk_render_extension(long style, long window, int state_type, int shadow_type, GdkRectangle area, long widget, byte[] detail, int x, int y, int width, int height, int gap_side) {
        if (OS.GTK3) {
            OS.gtk_render_extension(style, window, x, y, width, height, gap_side);
        } else {
            OS.gtk_paint_extension(style, window, state_type, shadow_type, area, widget, detail, x, y, width, height, gap_side);
        }
    }
}

