/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelTidAspect;
import org.eclipse.tracecompass.common.core.StreamUtils;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.Attributes;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.Activator;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.Messages;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.actions.FollowThreadAction;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.ControlFlowCheckActiveProvider;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.ControlFlowColumnComparators;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.ControlFlowEntry;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.ControlFlowPresentationProvider;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.NaiveOptimizationAlgorithm;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.PackageMessages;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.util.Pair;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractStateSystemTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.ITimeGraphEntryActiveProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ILinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeLinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;

public class ControlFlowView
extends AbstractStateSystemTimeGraphView {
    public static final @NonNull String ID = "org.eclipse.tracecompass.analysis.os.linux.views.controlflow";
    private static final String ICONS_PATH = "icons/";
    private static final String OPTIMIZE_ICON = "icons/elcl16/Optimization.png";
    private static final String PROCESS_COLUMN = Messages.ControlFlowView_processColumn;
    private static final String TID_COLUMN = Messages.ControlFlowView_tidColumn;
    private static final String PTID_COLUMN = Messages.ControlFlowView_ptidColumn;
    private static final String BIRTH_TIME_COLUMN = Messages.ControlFlowView_birthTimeColumn;
    private static final String INVISIBLE_COLUMN = Messages.ControlFlowView_invisibleColumn;
    private Action fOptimizationAction;
    private static final String NEXT_EVENT_ICON_PATH = "icons/elcl16/shift_r_edit.gif";
    private static final String PREV_EVENT_ICON_PATH = "icons/elcl16/shift_l_edit.gif";
    private static final String[] COLUMN_NAMES = new String[]{PROCESS_COLUMN, TID_COLUMN, PTID_COLUMN, BIRTH_TIME_COLUMN};
    private static final String[] FILTER_COLUMN_NAMES = new String[]{PROCESS_COLUMN, TID_COLUMN};
    private static final long BUILD_UPDATE_TIMEOUT = 500L;
    private static final Comparator<ITimeGraphEntry>[] COLUMN_COMPARATORS;
    private final Function<Collection<ILinkEvent>, Map<Integer, Long>> UPDATE_SCHEDULING_COLUMN_ALGO = new NaiveOptimizationAlgorithm();
    private static final int INITIAL_SORT_COLUMN_INDEX = 3;
    private final ISchedulingRule fSearchActionMutexRule = new ISchedulingRule(){

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }
    };
    private final Set<ITmfTrace> fFlatTraces = new HashSet<ITmfTrace>();
    private IAction fFlatAction;
    private IAction fHierarchicalAction;

    static {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)ControlFlowColumnComparators.PROCESS_NAME_COLUMN_COMPARATOR).add((Object)ControlFlowColumnComparators.TID_COLUMN_COMPARATOR).add((Object)ControlFlowColumnComparators.PTID_COLUMN_COMPARATOR).add((Object)ControlFlowColumnComparators.BIRTH_TIME_COLUMN_COMPARATOR);
        ImmutableList l = builder.build();
        COLUMN_COMPARATORS = l.toArray(new Comparator[l.size()]);
    }

    public ControlFlowView() {
        super(ID, (TimeGraphPresentationProvider)new ControlFlowPresentationProvider());
        this.setTreeColumns(COLUMN_NAMES, COLUMN_COMPARATORS, 3);
        this.setTreeLabelProvider(new ControlFlowTreeLabelProvider());
        this.setFilterColumns(FILTER_COLUMN_NAMES);
        this.setFilterLabelProvider(new ControlFlowFilterLabelProvider());
        this.setEntryComparator((Comparator)ControlFlowColumnComparators.BIRTH_TIME_COLUMN_COMPARATOR);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        super.getTimeGraphCombo().addTimeGraphFilterCheckActiveButton((ITimeGraphEntryActiveProvider)new ControlFlowCheckActiveProvider(Messages.ControlFlowView_checkActiveLabel, Messages.ControlFlowView_checkActiveToolTip));
        super.getTimeGraphCombo().addTimeGraphFilterUncheckInactiveButton((ITimeGraphEntryActiveProvider)new ControlFlowCheckActiveProvider(Messages.ControlFlowView_uncheckInactiveLabel, Messages.ControlFlowView_uncheckInactiveToolTip));
    }

    protected void fillTimeGraphEntryContextMenu(@NonNull IMenuManager menuManager) {
        StructuredSelection sSel;
        ISelection selection = this.getSite().getSelectionProvider().getSelection();
        if (selection instanceof StructuredSelection && (sSel = (StructuredSelection)selection).getFirstElement() instanceof ControlFlowEntry) {
            ControlFlowEntry entry = (ControlFlowEntry)((Object)sSel.getFirstElement());
            menuManager.add((IAction)new FollowThreadAction((TmfView)this, entry.getName(), entry.getThreadId(), entry.getTrace()));
        }
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        IAction optimizationAction = this.getOptimizationAction();
        manager.add(optimizationAction);
        manager.add((IContributionItem)new Separator());
        super.fillLocalToolBar(manager);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (section == null) {
            section = settings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        Action hideArrowsAction = this.getTimeGraphCombo().getTimeGraphViewer().getHideArrowsAction(section);
        manager.add((IAction)hideArrowsAction);
        Action followArrowBwdAction = this.getTimeGraphCombo().getTimeGraphViewer().getFollowArrowBwdAction();
        followArrowBwdAction.setText(Messages.ControlFlowView_followCPUBwdText);
        followArrowBwdAction.setToolTipText(Messages.ControlFlowView_followCPUBwdText);
        manager.add((IAction)followArrowBwdAction);
        Action followArrowFwdAction = this.getTimeGraphCombo().getTimeGraphViewer().getFollowArrowFwdAction();
        followArrowFwdAction.setText(Messages.ControlFlowView_followCPUFwdText);
        followArrowFwdAction.setToolTipText(Messages.ControlFlowView_followCPUFwdText);
        manager.add((IAction)followArrowFwdAction);
        SearchEventAction previousEventAction = new SearchEventAction(false, PackageMessages.ControlFlowView_PreviousEventJobName);
        previousEventAction.setText(PackageMessages.ControlFlowView_PreviousEventActionName);
        previousEventAction.setToolTipText(PackageMessages.ControlFlowView_PreviousEventActionTooltip);
        previousEventAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath(PREV_EVENT_ICON_PATH));
        manager.add((IAction)previousEventAction);
        SearchEventAction nextEventAction = new SearchEventAction(true, PackageMessages.ControlFlowView_NextEventJobName);
        nextEventAction.setText(PackageMessages.ControlFlowView_NextEventActionName);
        nextEventAction.setToolTipText(PackageMessages.ControlFlowView_NextEventActionTooltip);
        nextEventAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath(NEXT_EVENT_ICON_PATH));
        manager.add((IAction)nextEventAction);
    }

    private IAction getOptimizationAction() {
        if (this.fOptimizationAction == null) {
            this.fOptimizationAction = new OptimizationAction();
            this.fOptimizationAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath(OPTIMIZE_ICON));
            this.fOptimizationAction.setText(Messages.ControlFlowView_optimizeLabel);
            this.fOptimizationAction.setToolTipText(Messages.ControlFlowView_optimizeToolTip);
        }
        return this.fOptimizationAction;
    }

    protected void fillLocalMenu(IMenuManager manager) {
        super.fillLocalMenu(manager);
        MenuManager item = new MenuManager(Messages.ControlFlowView_threadPresentation);
        this.fFlatAction = this.createFlatAction();
        item.add(this.fFlatAction);
        this.fHierarchicalAction = this.createHierarchicalAction();
        item.add(this.fHierarchicalAction);
        manager.add((IContributionItem)item);
    }

    private IAction createHierarchicalAction() {
        Action action = new Action(Messages.ControlFlowView_hierarchicalViewLabel, 8){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ITmfTrace parentTrace = ControlFlowView.this.getTrace();
                Set set = ControlFlowView.this.fFlatTraces;
                synchronized (set) {
                    ControlFlowView.this.fFlatTraces.remove(parentTrace);
                    for (ITmfTrace trace : TmfTraceManager.getTraceSet((ITmfTrace)parentTrace)) {
                        ITmfStateSystem ss = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)trace, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
                        for (TimeGraphEntry traceEntry : ControlFlowView.this.getEntryList(ss)) {
                            List currentRootList = traceEntry.getChildren().stream().filter(e -> e instanceof ControlFlowEntry).map(e -> (ControlFlowEntry)((Object)e)).collect(Collectors.toList());
                            ControlFlowView.addEntriesToHierarchicalTree(currentRootList, traceEntry);
                        }
                    }
                }
                ControlFlowView.this.refresh();
            }
        };
        action.setChecked(true);
        action.setToolTipText(Messages.ControlFlowView_hierarchicalViewToolTip);
        return action;
    }

    private IAction createFlatAction() {
        Action action = new Action(Messages.ControlFlowView_flatViewLabel, 8){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Issues handling annotations - annotations may be inaccurate
             */
            public void run() {
                ITmfTrace parentTrace = ControlFlowView.this.getTrace();
                Set set = ControlFlowView.this.fFlatTraces;
                synchronized (set) {
                    ControlFlowView.this.fFlatTraces.add(parentTrace);
                    for (ITmfTrace trace : TmfTraceManager.getTraceSet((ITmfTrace)parentTrace)) {
                        ITmfStateSystem ss = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)trace, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
                        @NonNull List entryList = ControlFlowView.this.getEntryList(ss);
                        if (entryList == null) continue;
                        for (TimeGraphEntry traceEntry : entryList) {
                            ControlFlowView.hierarchicalToFlatTree(traceEntry);
                        }
                    }
                }
                ControlFlowView.this.refresh();
            }
        };
        action.setToolTipText(Messages.ControlFlowView_flatViewToolTip);
        return action;
    }

    protected String getNextText() {
        return Messages.ControlFlowView_nextProcessActionNameText;
    }

    protected String getNextTooltip() {
        return Messages.ControlFlowView_nextProcessActionToolTipText;
    }

    protected String getPrevText() {
        return Messages.ControlFlowView_previousProcessActionNameText;
    }

    protected String getPrevTooltip() {
        return Messages.ControlFlowView_previousProcessActionToolTipText;
    }

    public Function<Collection<ILinkEvent>, Map<Integer, Long>> getUpdatedSchedulingColumn() {
        return this.UPDATE_SCHEDULING_COLUMN_ALGO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        super.traceClosed(signal);
        Set<ITmfTrace> set = this.fFlatTraces;
        synchronized (set) {
            this.fFlatTraces.remove(signal.getTrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        super.traceSelected(signal);
        Set<ITmfTrace> set = this.fFlatTraces;
        synchronized (set) {
            if (this.fFlatTraces.contains(signal.getTrace())) {
                this.fHierarchicalAction.setChecked(false);
                this.fFlatAction.setChecked(true);
            } else {
                this.fFlatAction.setChecked(false);
                this.fHierarchicalAction.setChecked(true);
            }
        }
    }

    protected void buildEntryList(final ITmfTrace trace, final ITmfTrace parentTrace, final IProgressMonitor monitor) {
        final ITmfStateSystem ssq = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)trace, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        if (ssq == null) {
            return;
        }
        final ArrayList entryList = new ArrayList();
        HashMap<ITmfTrace, TraceEntry> traceEntryMap = new HashMap<ITmfTrace, TraceEntry>();
        final HashMap entryMap = new HashMap();
        long start = ssq.getStartTime();
        this.setStartTime(Math.min(this.getStartTime(), start));
        boolean complete = false;
        while (!complete) {
            if (monitor.isCanceled()) {
                return;
            }
            complete = ssq.waitUntilBuilt(500L);
            if (ssq.isCancelled()) {
                return;
            }
            final long end = ssq.getCurrentEndTime();
            if (start == end && !complete) continue;
            TraceEntry aTraceEntry = (TraceEntry)((Object)traceEntryMap.get(trace));
            if (aTraceEntry == null) {
                aTraceEntry = new TraceEntry(trace.getName(), start, end + 1L);
                traceEntryMap.put(trace, aTraceEntry);
                this.addToEntryList(parentTrace, ssq, Collections.singletonList(aTraceEntry));
            } else {
                aTraceEntry.updateEndTime(end + 1L);
            }
            final TraceEntry traceEntry = aTraceEntry;
            long resolution = Math.max(1L, (end - ssq.getStartTime()) / (long)this.getDisplayWidth());
            this.setEndTime(Math.max(this.getEndTime(), end + 1L));
            final List threadQuarks = ssq.getQuarks(new String[]{"Threads", "*"});
            this.queryFullStates(ssq, start, end, resolution, monitor, new AbstractStateSystemTimeGraphView.IQueryHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handle(List<List<ITmfStateInterval>> fullStates, List<ITmfStateInterval> prevFullState) {
                    Iterator iterator = threadQuarks.iterator();
                    while (iterator.hasNext()) {
                        int threadQuark = (Integer)iterator.next();
                        String threadAttributeName = ssq.getAttributeName(threadQuark);
                        Pair entryKey = Attributes.parseThreadAttributeName((String)threadAttributeName);
                        int threadId = (Integer)entryKey.getFirst();
                        if (threadId < 0) continue;
                        int execNameQuark = ssq.optQuarkRelative(threadQuark, new String[]{"Exec_name"});
                        int ppidQuark = ssq.optQuarkRelative(threadQuark, new String[]{"PPID"});
                        if (execNameQuark == -2) continue;
                        ITmfStateInterval lastExecNameInterval = prevFullState == null || execNameQuark >= prevFullState.size() ? null : prevFullState.get(execNameQuark);
                        long lastExecNameStartTime = lastExecNameInterval == null ? -1L : lastExecNameInterval.getStartTime();
                        long lastExecNameEndTime = lastExecNameInterval == null ? -1L : lastExecNameInterval.getEndTime() + 1L;
                        long lastPpidStartTime = prevFullState == null || ppidQuark >= prevFullState.size() || ppidQuark == -2 ? -1L : prevFullState.get(ppidQuark).getStartTime();
                        for (List<ITmfStateInterval> fullState : fullStates) {
                            if (monitor.isCanceled()) {
                                return;
                            }
                            if (execNameQuark >= fullState.size() || ppidQuark >= fullState.size()) continue;
                            ITmfStateInterval execNameInterval = fullState.get(execNameQuark);
                            ITmfStateInterval ppidInterval = ppidQuark == -2 ? null : fullState.get(ppidQuark);
                            long startTime = execNameInterval.getStartTime();
                            long endTime = execNameInterval.getEndTime() + 1L;
                            if (startTime == lastExecNameStartTime && ppidInterval != null && ppidInterval.getStartTime() == lastPpidStartTime) continue;
                            boolean isNull = execNameInterval.getStateValue().isNull();
                            if (isNull && lastExecNameEndTime < startTime && lastExecNameEndTime != -1L) {
                                try {
                                    execNameInterval = ssq.querySingleState(startTime - 1L, execNameQuark);
                                    ppidInterval = ppidQuark == -2 ? null : ssq.querySingleState(startTime - 1L, ppidQuark);
                                    startTime = execNameInterval.getStartTime();
                                    endTime = execNameInterval.getEndTime() + 1L;
                                }
                                catch (StateSystemDisposedException stateSystemDisposedException) {
                                    // empty catch block
                                }
                            }
                            if (!execNameInterval.getStateValue().isNull() && execNameInterval.getStateValue().getType() == ITmfStateValue.Type.STRING) {
                                String execName = execNameInterval.getStateValue().unboxStr();
                                int ppid = ppidInterval == null ? -1 : ppidInterval.getStateValue().unboxInt();
                                ControlFlowEntry entry = (ControlFlowEntry)((Object)entryMap.get(entryKey));
                                if (entry == null) {
                                    entry = new ControlFlowEntry(threadQuark, trace, execName, threadId, ppid, startTime, endTime);
                                    entryList.add(entry);
                                    entryMap.put(entryKey, entry);
                                } else {
                                    entry.setName(execName);
                                    entry.setParentThreadId(ppid);
                                    entry.updateEndTime(endTime);
                                }
                            }
                            if (isNull) {
                                entryMap.remove(entryKey);
                            }
                            lastExecNameStartTime = startTime;
                            lastExecNameEndTime = endTime;
                            long l = lastPpidStartTime = ppidInterval == null ? -1L : ppidInterval.getStartTime();
                        }
                    }
                    Set set = ControlFlowView.this.fFlatTraces;
                    synchronized (set) {
                        if (ControlFlowView.this.fFlatTraces.contains(parentTrace)) {
                            ControlFlowView.addEntriesToFlatTree(entryList, traceEntry);
                        } else {
                            ControlFlowView.addEntriesToHierarchicalTree(entryList, traceEntry);
                        }
                    }
                }
            });
            this.queryFullStates(ssq, ssq.getStartTime(), end, resolution, monitor, new AbstractStateSystemTimeGraphView.IQueryHandler(){

                public void handle(@NonNull List<List<ITmfStateInterval>> fullStates, @Nullable List<ITmfStateInterval> prevFullState) {
                    for (TimeGraphEntry entry : traceEntry.getChildren()) {
                        if (monitor.isCanceled()) {
                            return;
                        }
                        ControlFlowView.this.buildStatusEvents(trace, parentTrace, ssq, fullStates, prevFullState, (ControlFlowEntry)entry, monitor, ssq.getStartTime(), end);
                    }
                }
            });
            if (parentTrace.equals(this.getTrace())) {
                this.refresh();
            }
            start = end;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void hierarchicalToFlatTree(TimeGraphEntry traceEntry) {
        @NonNull List rootList = traceEntry.getChildren();
        StreamUtils.StreamFlattener sf = new StreamUtils.StreamFlattener(entry -> entry.getChildren().stream());
        Stream allEntries = rootList.stream().flatMap(entry -> sf.flatten(entry));
        List<@NonNull TimeGraphEntry> rootListToAdd = allEntries.filter(entry -> !rootList.contains(entry)).collect(Collectors.toList());
        rootList.forEach(entry -> entry.clearChildren());
        rootListToAdd.forEach(entry -> {
            traceEntry.addChild(entry);
            entry.clearChildren();
        });
    }

    private static void addEntriesToFlatTree(List<@NonNull ControlFlowEntry> entryList, TimeGraphEntry traceEntry) {
        List rootList = traceEntry.getChildren();
        for (ControlFlowEntry entry : entryList) {
            if (rootList.contains((Object)entry)) continue;
            traceEntry.addChild((TimeGraphEntry)entry);
        }
    }

    private static void addEntriesToHierarchicalTree(List<ControlFlowEntry> entryList, TimeGraphEntry traceEntry) {
        List rootList = traceEntry.getChildren();
        for (ControlFlowEntry entry : entryList) {
            boolean root;
            boolean bl = root = entry.getParent() == null || entry.getParent() == traceEntry;
            if (root && entry.getParentThreadId() > 0) {
                for (ControlFlowEntry parent : entryList) {
                    if (parent.getThreadId() != entry.getParentThreadId() || entry.getStartTime() > parent.getEndTime() || entry.getEndTime() < parent.getStartTime()) continue;
                    root = false;
                    if (rootList.contains((Object)entry)) {
                        traceEntry.removeChild((TimeGraphEntry)entry);
                    }
                    parent.addChild(entry);
                    break;
                }
            }
            if (!root || rootList.contains((Object)entry)) continue;
            traceEntry.addChild((TimeGraphEntry)entry);
        }
    }

    private void buildStatusEvents(ITmfTrace trace, ITmfTrace parentTrace, ITmfStateSystem ss, @NonNull List<List<ITmfStateInterval>> fullStates, @Nullable List<ITmfStateInterval> prevFullState, ControlFlowEntry entry, @NonNull IProgressMonitor monitor, long start, long end) {
        if (start < entry.getEndTime() && end > entry.getStartTime()) {
            List<ITimeEvent> eventList = this.getEventList(entry, ss, fullStates, prevFullState, monitor);
            if (eventList == null) {
                return;
            }
            if (prevFullState == null) {
                entry.setEventList(eventList);
            } else {
                for (ITimeEvent event : eventList) {
                    entry.addEvent(event);
                }
            }
            if (parentTrace.equals(this.getTrace())) {
                this.redraw();
            }
        }
        for (ITimeGraphEntry child : entry.getChildren()) {
            if (monitor.isCanceled()) {
                return;
            }
            this.buildStatusEvents(trace, parentTrace, ss, fullStates, prevFullState, (ControlFlowEntry)child, monitor, start, end);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected @Nullable List<ITimeEvent> getEventList(@NonNull TimeGraphEntry tgentry, ITmfStateSystem ss, @NonNull List<List<ITmfStateInterval>> fullStates, @Nullable List<ITmfStateInterval> prevFullState, @NonNull IProgressMonitor monitor) {
        ArrayList<Object> eventList = null;
        if (!(tgentry instanceof ControlFlowEntry)) {
            return eventList;
        }
        ControlFlowEntry entry = (ControlFlowEntry)tgentry;
        try {
            int statusQuark = entry.getThreadQuark();
            eventList = new ArrayList<Object>(fullStates.size());
            ITmfStateInterval lastInterval = prevFullState == null || statusQuark >= prevFullState.size() ? null : prevFullState.get(statusQuark);
            long lastStartTime = lastInterval == null ? -1L : lastInterval.getStartTime();
            long lastEndTime = lastInterval == null ? -1L : lastInterval.getEndTime() + 1L;
            Iterator<List<ITmfStateInterval>> iterator = fullStates.iterator();
            while (true) {
                ITmfStateInterval statusInterval;
                long time;
                if (!iterator.hasNext()) {
                    return eventList;
                }
                List<ITmfStateInterval> fullState = iterator.next();
                if (monitor.isCanceled()) {
                    return null;
                }
                if (statusQuark >= fullState.size() || (time = (statusInterval = fullState.get(statusQuark)).getStartTime()) == lastStartTime) continue;
                long duration = statusInterval.getEndTime() - time + 1L;
                int status = -1;
                try {
                    status = statusInterval.getStateValue().unboxInt();
                }
                catch (StateValueTypeException e) {
                    Activator.getDefault().logError(e.getMessage());
                }
                if (lastEndTime != time && lastEndTime != -1L) {
                    eventList.add(new TimeEvent((ITimeGraphEntry)entry, lastEndTime, time - lastEndTime));
                }
                if (!statusInterval.getStateValue().isNull()) {
                    eventList.add(new TimeEvent((ITimeGraphEntry)entry, time, duration, status));
                } else {
                    eventList.add(new NullTimeEvent((ITimeGraphEntry)entry, time, duration));
                }
                lastStartTime = time;
                lastEndTime = time + duration;
            }
        }
        catch (TimeRangeException e) {
            Activator.getDefault().logError(e.getMessage());
        }
        return eventList;
    }

    private int getSelectionValue(long time) {
        int thread = -1;
        block3: for (ITmfTrace trace : TmfTraceManager.getTraceSet((ITmfTrace)this.getTrace())) {
            if (thread > 0) break;
            ITmfStateSystem ssq = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)trace, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
            if (ssq == null || time < ssq.getStartTime() || time > ssq.getCurrentEndTime()) continue;
            List currentThreadQuarks = ssq.getQuarks(new String[]{"CPUs", "*", "Current_thread"});
            Iterator iterator = currentThreadQuarks.iterator();
            while (iterator.hasNext()) {
                int currentThreadQuark = (Integer)iterator.next();
                try {
                    int statusQuark;
                    ITmfStateInterval statusInterval;
                    ITmfStateInterval currentThreadInterval = ssq.querySingleState(time, currentThreadQuark);
                    int currentThread = currentThreadInterval.getStateValue().unboxInt();
                    if (currentThread <= 0 || (statusInterval = ssq.querySingleState(time, statusQuark = ssq.getQuarkAbsolute(new String[]{"Threads", Integer.toString(currentThread)}))).getStartTime() != time) continue;
                    thread = currentThread;
                    continue block3;
                }
                catch (AttributeNotFoundException | StateValueTypeException | TimeRangeException e) {
                    Activator.getDefault().logError(e.getMessage());
                }
                catch (StateSystemDisposedException stateSystemDisposedException) {
                    // empty catch block
                }
            }
        }
        return thread;
    }

    protected void synchingToTime(long time) {
        int selected = this.getSelectionValue(time);
        if (selected > 0) {
            ITimeGraphEntry[] iTimeGraphEntryArray = this.getTimeGraphViewer().getExpandedElements();
            int n = iTimeGraphEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                ControlFlowEntry entry;
                ITimeGraphEntry element = iTimeGraphEntryArray[n2];
                if (element instanceof ControlFlowEntry && (entry = (ControlFlowEntry)element).getThreadId() == selected) {
                    this.getTimeGraphCombo().setSelection((ITimeGraphEntry)entry);
                    break;
                }
                ++n2;
            }
        }
    }

    protected @NonNull List<ILinkEvent> getLinkList(ITmfStateSystem ss, @NonNull List<List<ITmfStateInterval>> fullStates, @Nullable List<ITmfStateInterval> prevFullState, @NonNull IProgressMonitor monitor) {
        ArrayList<ILinkEvent> list = new ArrayList<ILinkEvent>();
        List entryList = this.getEntryList(ss);
        if (entryList == null) {
            return list;
        }
        for (ITmfTrace trace : TmfTraceManager.getTraceSet((ITmfTrace)this.getTrace())) {
            List currentThreadQuarks = ss.getQuarks(new String[]{"CPUs", "*", "Current_thread"});
            Iterator iterator = currentThreadQuarks.iterator();
            while (iterator.hasNext()) {
                int currentThreadQuark = (Integer)iterator.next();
                if (currentThreadQuark >= fullStates.get(0).size()) continue;
                ArrayList<ITmfStateInterval> currentThreadIntervals = new ArrayList<ITmfStateInterval>(fullStates.size() + 2);
                try {
                    ITmfStateInterval currentThreadInterval;
                    if (prevFullState == null && (currentThreadInterval = fullStates.get(0).get(currentThreadQuark)).getStateValue().unboxInt() == 0) {
                        long start = Math.max(currentThreadInterval.getStartTime() - 1L, ss.getStartTime());
                        currentThreadIntervals.add(ss.querySingleState(start, currentThreadQuark));
                    }
                    for (List<ITmfStateInterval> fullState : fullStates) {
                        currentThreadIntervals.add(fullState.get(currentThreadQuark));
                    }
                    currentThreadInterval = fullStates.get(fullStates.size() - 1).get(currentThreadQuark);
                    if (currentThreadInterval.getStateValue().unboxInt() == 0) {
                        long end = Math.min(currentThreadInterval.getEndTime() + 1L, ss.getCurrentEndTime());
                        currentThreadIntervals.add(ss.querySingleState(end, currentThreadQuark));
                    }
                }
                catch (StateSystemDisposedException e) {
                    return list;
                }
                int prevThread = 0;
                long prevEnd = 0L;
                long lastEnd = 0L;
                for (ITmfStateInterval currentThreadInterval : currentThreadIntervals) {
                    int thread;
                    if (monitor.isCanceled()) {
                        return list;
                    }
                    if (currentThreadInterval.getEndTime() + 1L == lastEnd) continue;
                    long time = currentThreadInterval.getStartTime();
                    if (time != lastEnd) {
                        prevThread = 0;
                        prevEnd = 0L;
                    }
                    if ((thread = currentThreadInterval.getStateValue().unboxInt()) > 0 && prevThread > 0) {
                        ControlFlowEntry prevEntry = this.findEntry(entryList, trace, prevThread);
                        ControlFlowEntry nextEntry = this.findEntry(entryList, trace, thread);
                        list.add((ILinkEvent)new TimeLinkEvent((ITimeGraphEntry)prevEntry, (ITimeGraphEntry)nextEntry, prevEnd, time - prevEnd, 0));
                    }
                    lastEnd = currentThreadInterval.getEndTime() + 1L;
                    if (thread == 0) continue;
                    prevThread = thread;
                    prevEnd = lastEnd;
                }
            }
        }
        return list;
    }

    private ControlFlowEntry findEntry(List<TimeGraphEntry> entryList, ITmfTrace trace, int threadId) {
        for (TimeGraphEntry entry : entryList) {
            ControlFlowEntry controlFlowEntry;
            if (entry instanceof ControlFlowEntry && (controlFlowEntry = (ControlFlowEntry)entry).getThreadId() == threadId && controlFlowEntry.getTrace() == trace) {
                return controlFlowEntry;
            }
            if (!entry.hasChildren() || (controlFlowEntry = this.findEntry(entry.getChildren(), trace, threadId)) == null) continue;
            return controlFlowEntry;
        }
        return null;
    }

    private static class ControlFlowFilterLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        private ControlFlowFilterLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof TraceEntry) {
                if (columnIndex == 0) {
                    return ((TraceEntry)((Object)element)).getName();
                }
                return "";
            }
            ControlFlowEntry entry = (ControlFlowEntry)((Object)element);
            if (columnIndex == 0) {
                return entry.getName();
            }
            if (columnIndex == 1) {
                return Integer.toString(entry.getThreadId());
            }
            return "";
        }
    }

    protected static class ControlFlowTreeLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        protected ControlFlowTreeLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof TraceEntry) {
                if (columnIndex == 0) {
                    return ((TraceEntry)((Object)element)).getName();
                }
                return "";
            }
            ControlFlowEntry entry = (ControlFlowEntry)((Object)element);
            if (COLUMN_NAMES[columnIndex].equals(Messages.ControlFlowView_processColumn)) {
                return entry.getName();
            }
            if (COLUMN_NAMES[columnIndex].equals(Messages.ControlFlowView_tidColumn)) {
                return Integer.toString(entry.getThreadId());
            }
            if (COLUMN_NAMES[columnIndex].equals(Messages.ControlFlowView_ptidColumn)) {
                if (entry.getParentThreadId() > 0) {
                    return Integer.toString(entry.getParentThreadId());
                }
            } else {
                if (COLUMN_NAMES[columnIndex].equals(Messages.ControlFlowView_birthTimeColumn)) {
                    return Utils.formatTime((long)entry.getStartTime(), (Utils.TimeFormat)Utils.TimeFormat.CALENDAR, (Utils.Resolution)Utils.Resolution.NANOSEC);
                }
                if (COLUMN_NAMES[columnIndex].equals(Messages.ControlFlowView_traceColumn)) {
                    return entry.getTrace().getName();
                }
                if (COLUMN_NAMES[columnIndex].equals(INVISIBLE_COLUMN)) {
                    return Long.toString(entry.getSchedulingPosition());
                }
            }
            return "";
        }
    }

    private final class OptimizationAction
    extends Action {
        private OptimizationAction() {
        }

        public void runWithEvent(Event event) {
            ITmfTrace trace = ControlFlowView.this.getTrace();
            if (trace == null) {
                return;
            }
            ControlFlowView.this.createFlatAction().run();
            List arrows = ControlFlowView.this.getTimeGraphViewer().getTimeGraphControl().getArrows();
            ITmfStateSystem ss = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)trace, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
            List currentList = ControlFlowView.this.getEntryList(ss);
            Map<Integer, Long> orderedTidMap = ControlFlowView.this.getUpdatedSchedulingColumn().apply(arrows);
            for (TimeGraphEntry entry : currentList) {
                if (!(entry instanceof TraceEntry)) continue;
                for (TimeGraphEntry child : ((TraceEntry)entry).getChildren()) {
                    if (!(child instanceof ControlFlowEntry)) continue;
                    ControlFlowEntry cEntry = (ControlFlowEntry)child;
                    cEntry.setSchedulingPosition(orderedTidMap.getOrDefault(cEntry.getThreadId(), Long.MAX_VALUE));
                }
            }
            ControlFlowView.this.setEntryComparator((Comparator)ControlFlowColumnComparators.SCHEDULING_COLUMN_COMPARATOR);
            ControlFlowView.this.refresh();
        }
    }

    private class SearchEventAction
    extends Action {
        private final boolean ifDirection;
        private final String ifJobName;

        public SearchEventAction(boolean direction, String jobName) {
            this.ifDirection = direction;
            this.ifJobName = jobName;
        }

        public void run() {
            Job job = new Job(this.ifJobName){

                protected IStatus run(IProgressMonitor monitor) {
                    ITmfEvent event2;
                    long ts;
                    TimeGraphControl ctrl = ControlFlowView.this.getTimeGraphViewer().getTimeGraphControl();
                    ITimeGraphEntry traceEntry = ctrl.getSelectedTrace();
                    ITimeEvent selectedState = Utils.findEvent((ITimeGraphEntry)traceEntry, (long)(ts = ControlFlowView.this.getTimeGraphViewer().getSelectionBegin()), (int)0);
                    if (selectedState == null) {
                        return Status.OK_STATUS;
                    }
                    ITimeGraphEntry entry = selectedState.getEntry();
                    if (!(entry instanceof ControlFlowEntry)) {
                        return Status.OK_STATUS;
                    }
                    ControlFlowEntry cfEntry = (ControlFlowEntry)entry;
                    int tid = cfEntry.getThreadId();
                    ITmfTrace trace = cfEntry.getTrace();
                    ITmfContext ctx = trace.seekEvent(TmfTimestamp.fromNanos((long)ts));
                    long rank = ctx.getRank();
                    ctx.dispose();
                    Predicate<@NonNull ITmfEvent> predicate = event -> {
                        Integer eventTid = KernelTidAspect.INSTANCE.resolve(event);
                        return eventTid != null && eventTid == tid;
                    };
                    ITmfEvent iTmfEvent = event2 = SearchEventAction.this.ifDirection ? TmfTraceUtils.getNextEventMatching((ITmfTrace)cfEntry.getTrace(), (long)rank, predicate, (IProgressMonitor)monitor) : TmfTraceUtils.getPreviousEventMatching((ITmfTrace)cfEntry.getTrace(), (long)rank, predicate, (IProgressMonitor)monitor);
                    if (event2 != null) {
                        TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, event2.getTimestamp()));
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setRule(ControlFlowView.this.fSearchActionMutexRule);
            job.schedule();
        }
    }

    private static class TraceEntry
    extends TimeGraphEntry {
        public TraceEntry(String name, long startTime, long endTime) {
            super(name, startTime, endTime);
        }

        public boolean hasTimeEvents() {
            return false;
        }
    }
}

