/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.BinaryCallsite;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.Messages;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.UstDebugInfoAnalysisModule;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.UstDebugInfoLoadedBinaryFile;
import org.eclipse.tracecompass.lttng2.ust.core.trace.LttngUstTrace;
import org.eclipse.tracecompass.lttng2.ust.core.trace.layout.ILttngUstEventLayout;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class UstDebugInfoBinaryAspect
implements ITmfEventAspect<BinaryCallsite> {
    public static final UstDebugInfoBinaryAspect INSTANCE = new UstDebugInfoBinaryAspect();

    private UstDebugInfoBinaryAspect() {
    }

    public String getName() {
        return NonNullUtils.nullToEmptyString((Object)Messages.UstDebugInfoAnalysis_BinaryAspectName);
    }

    public String getHelpText() {
        return NonNullUtils.nullToEmptyString((Object)Messages.UstDebugInfoAnalysis_BinaryAspectHelpText);
    }

    public @Nullable BinaryCallsite resolve(ITmfEvent event) {
        if (!(event.getTrace() instanceof LttngUstTrace)) {
            return null;
        }
        LttngUstTrace trace = (LttngUstTrace)event.getTrace();
        ILttngUstEventLayout layout = trace.getEventLayout();
        ITmfEventField vpidField = event.getContent().getField(new String[]{layout.contextVpid()});
        ITmfEventField ipField = event.getContent().getField(new String[]{layout.contextIp()});
        if (vpidField == null || ipField == null) {
            return null;
        }
        Long vpid = (Long)vpidField.getValue();
        Long ip = (Long)ipField.getValue();
        long ts = event.getTimestamp().toNanos();
        return UstDebugInfoBinaryAspect.getBinaryCallsite(trace, vpid.intValue(), ts, ip);
    }

    public static @Nullable BinaryCallsite getBinaryCallsite(LttngUstTrace trace, int pid, long ts, long ip) {
        UstDebugInfoAnalysisModule module = (UstDebugInfoAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, UstDebugInfoAnalysisModule.class, (String)"org.eclipse.linuxtools.lttng2.ust.analysis.debuginfo");
        if (module == null) {
            return null;
        }
        UstDebugInfoLoadedBinaryFile file = module.getMatchingFile(ts, pid, ip);
        if (file == null) {
            return null;
        }
        String fullPath = String.valueOf(trace.getSymbolProviderConfig().getActualRootDirPath()) + file.getFilePath();
        long offset = file.isPic() ? ip - file.getBaseAddress() : ip;
        return new BinaryCallsite(fullPath, file.getBuildId(), offset, file.isPic());
    }
}

