/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.equinox.internal.p2.ui.dialogs.IPreFilterJobProvider;
import org.eclipse.equinox.internal.p2.ui.viewers.DeferredQueryContentProvider;
import org.eclipse.equinox.internal.p2.ui.viewers.IInputChangeListener;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;

public class DelayedFilterCheckboxTree
extends FilteredTree {
    private static final long FILTER_DELAY = 800L;
    public static final Object ALL_ITEMS_HACK = new Object();
    ToolBar toolBar;
    Display display;
    PatternFilter patternFilter;
    IPreFilterJobProvider jobProvider;
    DeferredQueryContentProvider contentProvider;
    String savedFilterText;
    Job preFilterJob;
    WorkbenchJob filterJob;
    boolean ignoreFiltering = true;
    Object viewerInput;
    HashSet<Object> checkState = new HashSet();
    Set<Object> expanded = new HashSet<Object>();
    ContainerCheckedTreeViewer checkboxViewer;

    public DelayedFilterCheckboxTree(Composite parent, int treeStyle, PatternFilter filter, IPreFilterJobProvider jobProvider) {
        super(parent, true);
        this.display = parent.getDisplay();
        this.patternFilter = filter;
        this.init(treeStyle, filter);
    }

    protected TreeViewer doCreateTreeViewer(Composite composite, int style) {
        this.checkboxViewer = new ContainerCheckedTreeViewer(composite, style);
        this.checkboxViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (!event.getChecked() && DelayedFilterCheckboxTree.this.checkState != null) {
                    if (event.getElement() == ALL_ITEMS_HACK) {
                        DelayedFilterCheckboxTree.this.clearCheckStateCache();
                    } else {
                        ArrayList<Object> toRemove = new ArrayList<Object>(1);
                        if (DelayedFilterCheckboxTree.this.contentProvider.hasChildren(event.getElement())) {
                            Object[] children;
                            HashSet<Object> unchecked = new HashSet<Object>();
                            Object[] objectArray = children = DelayedFilterCheckboxTree.this.contentProvider.getChildren(event.getElement());
                            int n = children.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object element = objectArray[n2];
                                unchecked.add(element);
                                ++n2;
                            }
                            for (Object current : DelayedFilterCheckboxTree.this.checkState) {
                                if (current == null || !unchecked.contains(current)) continue;
                                toRemove.add(current);
                            }
                        } else {
                            for (Object element : DelayedFilterCheckboxTree.this.checkState) {
                                if (!DelayedFilterCheckboxTree.this.checkboxViewer.getComparer().equals(element, event.getElement())) continue;
                                toRemove.add(element);
                            }
                        }
                        DelayedFilterCheckboxTree.this.checkState.removeAll(toRemove);
                    }
                } else if (event.getChecked()) {
                    DelayedFilterCheckboxTree.this.rememberLeafCheckState();
                }
            }
        });
        return this.checkboxViewer;
    }

    protected Composite createFilterControls(Composite filterParent) {
        super.createFilterControls(filterParent);
        filterParent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DelayedFilterCheckboxTree.this.cancelPreFilterJob();
            }
        });
        return filterParent;
    }

    public void contentProviderSet(DeferredQueryContentProvider deferredProvider) {
        this.contentProvider = deferredProvider;
        deferredProvider.addListener(new IInputChangeListener(){

            @Override
            public void inputChanged(Viewer v, Object oldInput, Object newInput) {
                if (newInput == null) {
                    return;
                }
                DelayedFilterCheckboxTree.this.viewerInput = newInput;
                DelayedFilterCheckboxTree.this.cancelPreFilterJob();
                DelayedFilterCheckboxTree.this.cancelAndResetFilterJob();
                DelayedFilterCheckboxTree.this.contentProvider.setSynchronous(false);
                DelayedFilterCheckboxTree.this.rememberExpansions();
                DelayedFilterCheckboxTree.this.checkboxViewer.getTree().setRedraw(false);
                DelayedFilterCheckboxTree.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).DelayedFilterCheckboxTree.this.checkboxViewer.getTree().isDisposed()) {
                            return;
                        }
                        DelayedFilterCheckboxTree.this.rememberExpansions();
                        DelayedFilterCheckboxTree.this.restoreLeafCheckState();
                        DelayedFilterCheckboxTree.this.rememberExpansions();
                        DelayedFilterCheckboxTree.this.restoreExpansions();
                        (this).DelayedFilterCheckboxTree.this.checkboxViewer.getTree().setRedraw(true);
                    }
                });
            }
        });
    }

    public void clearCheckStateCache() {
        this.checkState = null;
    }

    protected WorkbenchJob doCreateRefreshJob() {
        this.filterJob = super.doCreateRefreshJob();
        this.filterJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void aboutToRun(IJobChangeEvent event) {
                if (!DelayedFilterCheckboxTree.this.ignoreFiltering) {
                    return;
                }
                final boolean[] shouldPreFilter = new boolean[]{false};
                DelayedFilterCheckboxTree.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (DelayedFilterCheckboxTree.this.filterText != null && !DelayedFilterCheckboxTree.this.filterText.isDisposed()) {
                            String text = DelayedFilterCheckboxTree.this.getFilterString();
                            if (text == null || DelayedFilterCheckboxTree.this.initialText != null && DelayedFilterCheckboxTree.this.initialText.equals(text)) {
                                return;
                            }
                            if (!(this).DelayedFilterCheckboxTree.this.contentProvider.getSynchronous() && (this).DelayedFilterCheckboxTree.this.preFilterJob == null && DelayedFilterCheckboxTree.this.filterText != null && !DelayedFilterCheckboxTree.this.filterText.isDisposed()) {
                                shouldPreFilter[0] = true;
                            }
                        }
                    }
                });
                if (shouldPreFilter[0]) {
                    event.getJob().sleep();
                    DelayedFilterCheckboxTree.this.schedulePreFilterJob();
                } else if (DelayedFilterCheckboxTree.this.ignoreFiltering) {
                    event.getJob().sleep();
                } else {
                    DelayedFilterCheckboxTree.this.rememberLeafCheckState();
                }
            }

            public void running(IJobChangeEvent event) {
                DelayedFilterCheckboxTree.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        DelayedFilterCheckboxTree.this.rememberLeafCheckState();
                    }
                });
            }

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    DelayedFilterCheckboxTree.this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).DelayedFilterCheckboxTree.this.checkboxViewer.getTree().isDisposed()) {
                                return;
                            }
                            (this).DelayedFilterCheckboxTree.this.checkboxViewer.getTree().setRedraw(false);
                            DelayedFilterCheckboxTree.this.rememberExpansions();
                            DelayedFilterCheckboxTree.this.restoreLeafCheckState();
                            DelayedFilterCheckboxTree.this.restoreExpansions();
                            (this).DelayedFilterCheckboxTree.this.checkboxViewer.getTree().setRedraw(true);
                        }
                    });
                }
            }
        });
        return this.filterJob;
    }

    void schedulePreFilterJob() {
        this.cancelPreFilterJob();
        this.ignoreFiltering = false;
        Job job = this.preFilterJob = this.jobProvider == null ? null : this.jobProvider.getPreFilterJob();
        if (this.preFilterJob == null) {
            if (this.filterJob != null) {
                this.filterJob.wakeUp();
            }
            return;
        }
        this.ignoreFiltering = true;
        this.preFilterJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                DelayedFilterCheckboxTree.this.ignoreFiltering = false;
                DelayedFilterCheckboxTree.this.contentProvider.setSynchronous(true);
                if (DelayedFilterCheckboxTree.this.filterJob != null) {
                    DelayedFilterCheckboxTree.this.filterJob.wakeUp();
                }
                DelayedFilterCheckboxTree.this.preFilterJob = null;
            }
        });
        this.preFilterJob.setSystem(true);
        this.preFilterJob.setUser(false);
        this.preFilterJob.schedule();
    }

    void cancelPreFilterJob() {
        if (this.preFilterJob != null) {
            this.preFilterJob.cancel();
            this.preFilterJob = null;
        }
    }

    void cancelAndResetFilterJob() {
        if (this.filterJob != null) {
            this.filterJob.cancel();
        }
    }

    void rememberLeafCheckState() {
        ContainerCheckedTreeViewer v = (ContainerCheckedTreeViewer)this.getViewer();
        Object[] checked = v.getCheckedElements();
        if (this.checkState == null) {
            this.checkState = new HashSet(checked.length);
        }
        int i = 0;
        while (i < checked.length) {
            if (!v.getGrayed(checked[i]) && this.contentProvider.getChildren(checked[i]).length == 0 && !this.checkState.contains(checked[i])) {
                this.checkState.add(checked[i]);
            }
            ++i;
        }
    }

    void restoreLeafCheckState() {
        if (this.checkboxViewer == null || this.checkboxViewer.getTree().isDisposed()) {
            return;
        }
        if (this.checkState == null) {
            return;
        }
        this.checkboxViewer.setCheckedElements(new Object[0]);
        this.checkboxViewer.setGrayedElements(new Object[0]);
        Iterator<Object> iter = this.checkState.iterator();
        Object element = null;
        if (iter.hasNext()) {
            this.checkboxViewer.expandAll();
        }
        while (iter.hasNext()) {
            element = iter.next();
            this.checkboxViewer.setChecked(element, true);
        }
        if (element != null) {
            this.checkboxViewer.fireCheckStateChanged(element, true);
        }
    }

    void rememberExpansions() {
        this.expanded.addAll(Arrays.asList(this.getViewer().getExpandedElements()));
    }

    void restoreExpansions() {
        this.getViewer().setExpandedElements(this.expanded.toArray());
    }

    public ContainerCheckedTreeViewer getCheckboxTreeViewer() {
        return this.checkboxViewer;
    }

    protected long getRefreshJobDelay() {
        return 800L;
    }

    public Object[] getCheckedElements() {
        if (this.checkState != null) {
            return this.checkState.toArray();
        }
        return new Object[0];
    }
}

