/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.filetransfer.ssl;

import java.net.URLConnection;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.ecf.internal.provider.filetransfer.IURLConnectionModifier;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class ECFURLConnectionModifier
implements IURLConnectionModifier {
    private BundleContext context;
    private ServiceTracker sslSocketFactoryTracker;

    public void init(BundleContext ctxt) {
        this.context = ctxt;
    }

    private SSLSocketFactory getSSLSocketFactory() {
        if (this.context == null) {
            return null;
        }
        if (this.sslSocketFactoryTracker == null) {
            this.sslSocketFactoryTracker = new ServiceTracker(this.context, SSLSocketFactory.class.getName(), null);
            this.sslSocketFactoryTracker.open();
        }
        return (SSLSocketFactory)this.sslSocketFactoryTracker.getService();
    }

    public void dispose() {
        this.context = null;
        if (this.sslSocketFactoryTracker != null) {
            this.sslSocketFactoryTracker.close();
            this.sslSocketFactoryTracker = null;
        }
    }

    public void setSocketFactoryForConnection(URLConnection urlConnection) {
        if (urlConnection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)urlConnection;
            SSLSocketFactory sslSocketFactory = this.getSSLSocketFactory();
            if (sslSocketFactory != null) {
                httpsURLConnection.setSSLSocketFactory(sslSocketFactory);
            }
        }
    }
}

