/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.AbstractTreeViewerAdvisor;
import org.eclipse.team.internal.ui.synchronize.ChangeSetCapability;
import org.eclipse.team.internal.ui.synchronize.ChangeSetModelManager;
import org.eclipse.team.internal.ui.synchronize.DecoratingColorLabelProvider;
import org.eclipse.team.internal.ui.synchronize.HierarchicalModelManager;
import org.eclipse.team.internal.ui.synchronize.IChangeSetProvider;
import org.eclipse.team.internal.ui.synchronize.ISynchronizeModelProvider;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelElementLabelProvider;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelManager;
import org.eclipse.team.internal.ui.synchronize.SynchronizePageConfiguration;
import org.eclipse.team.internal.ui.synchronize.actions.StatusLineContributionGroup;
import org.eclipse.team.internal.ui.synchronize.actions.SyncInfoSetStatusLineContributionGroup;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.part.ResourceTransfer;

public class TreeViewerAdvisor
extends AbstractTreeViewerAdvisor {
    private StatusLineContributionGroup statusLine;
    public static final int CHECKBOX = 1;
    private SynchronizeModelManager modelManager;

    public static StructuredViewer createViewer(Composite parent, ISynchronizePageConfiguration configuration) {
        int style = ((SynchronizePageConfiguration)configuration).getViewerStyle();
        if ((style & 1) > 0) {
            NavigableCheckboxTreeViewer v = new NavigableCheckboxTreeViewer(parent, 770);
            configuration.getSite().setSelectionProvider((ISelectionProvider)v);
            return v;
        }
        NavigableTreeViewer v = new NavigableTreeViewer(parent, 770);
        configuration.getSite().setSelectionProvider((ISelectionProvider)v);
        return v;
    }

    public TreeViewerAdvisor(Composite parent, ISynchronizePageConfiguration configuration) {
        super(configuration);
        this.modelManager = (SynchronizeModelManager)((Object)configuration.getProperty("org.eclipse.team.ui.P_MODEL_MANAGER"));
        if (this.modelManager == null) {
            this.modelManager = this.createModelManager(configuration);
            configuration.setProperty("org.eclipse.team.ui.P_MODEL_MANAGER", (Object)this.modelManager);
        }
        Assert.isNotNull((Object)((Object)this.modelManager), (String)"model manager must be set");
        this.modelManager.setViewerAdvisor(this);
        StructuredViewer viewer = TreeViewerAdvisor.createViewer(parent, configuration);
        GridData data = new GridData(1808);
        viewer.getControl().setLayoutData((Object)data);
        this.initializeViewer(viewer);
    }

    @Override
    public void setInitialInput() {
    }

    protected SynchronizeModelManager createModelManager(ISynchronizePageConfiguration configuration) {
        IChangeSetProvider provider;
        ChangeSetCapability changeSetCapability;
        ISynchronizeParticipant participant = configuration.getParticipant();
        if (participant instanceof IChangeSetProvider && (changeSetCapability = (provider = (IChangeSetProvider)((Object)participant)).getChangeSetCapability()) != null && (changeSetCapability.supportsActiveChangeSets() || changeSetCapability.supportsCheckedInChangeSets())) {
            return new ChangeSetModelManager(configuration);
        }
        return new HierarchicalModelManager(configuration);
    }

    public SynchronizeModelManager getModelManager() {
        return this.modelManager;
    }

    @Override
    public boolean validateViewer(StructuredViewer viewer) {
        return viewer instanceof AbstractTreeViewer;
    }

    @Override
    protected void initializeListeners(StructuredViewer viewer) {
        super.initializeListeners(viewer);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeViewerAdvisor.this.updateStatusLine((IStructuredSelection)event.getSelection());
            }
        });
    }

    void updateStatusLine(IStructuredSelection selection) {
        IWorkbenchSite ws = this.getConfiguration().getSite().getWorkbenchSite();
        if (ws != null && ws instanceof IViewSite) {
            String msg = this.getStatusLineMessage(selection);
            ((IViewSite)ws).getActionBars().getStatusLineManager().setMessage(msg);
        }
    }

    private String getStatusLineMessage(IStructuredSelection selection) {
        Object first;
        if (selection.size() == 1 && (first = selection.getFirstElement()) instanceof SyncInfoModelElement) {
            SyncInfoModelElement node = (SyncInfoModelElement)first;
            IResource resource = node.getResource();
            if (resource == null) {
                return node.getName();
            }
            return resource.getFullPath().makeRelative().toString();
        }
        if (selection.size() > 1) {
            return String.valueOf(selection.size()) + TeamUIMessages.SynchronizeView_13;
        }
        return "";
    }

    public final void setInput(final ISynchronizeModelProvider modelProvider) {
        final ISynchronizeModelElement modelRoot = modelProvider.getModelRoot();
        this.getActionGroup().modelChanged(modelRoot);
        modelRoot.addCompareInputChangeListener(new ICompareInputChangeListener(){

            public void compareInputChanged(ICompareInput source) {
                TreeViewerAdvisor.this.getActionGroup().modelChanged(modelRoot);
            }
        });
        final StructuredViewer viewer = this.getViewer();
        if (viewer != null) {
            viewer.setSorter(modelProvider.getViewerSorter());
            viewer.setInput((Object)modelRoot);
            modelProvider.addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getProperty() == "org.eclipse.team.ui.P_VIEWER_SORTER" && viewer != null && !viewer.getControl().isDisposed()) {
                        viewer.getControl().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (viewer != null && !viewer.getControl().isDisposed()) {
                                    ViewerSorter oldSorter;
                                    ViewerSorter newSorter = modelProvider.getViewerSorter();
                                    if (newSorter == (oldSorter = viewer.getSorter())) {
                                        viewer.refresh();
                                    } else {
                                        viewer.setSorter(newSorter);
                                    }
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    @Override
    public final void initializeViewer(final StructuredViewer viewer) {
        super.initializeViewer(viewer);
        DragSourceListener listener = new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                Object[] array = selection.toArray();
                event.doit = Utils.getResources(array).length > 0;
            }

            public void dragSetData(DragSourceEvent event) {
                if (ResourceTransfer.getInstance().isSupportedType(event.dataType)) {
                    IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                    Object[] array = selection.toArray();
                    event.data = Utils.getResources(array);
                }
            }

            public void dragFinished(DragSourceEvent event) {
            }
        };
        viewer.addDragSupport(5, new Transfer[]{ResourceTransfer.getInstance()}, listener);
        viewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        viewer.setContentProvider((IContentProvider)this.getContentProvider());
    }

    protected IStructuredContentProvider getContentProvider() {
        return new BaseWorkbenchContentProvider();
    }

    protected ILabelProvider getLabelProvider() {
        SynchronizeModelElementLabelProvider provider = new SynchronizeModelElementLabelProvider();
        ILabelDecorator[] decorators = (ILabelDecorator[])this.getConfiguration().getProperty("org.eclipse.team.ui.P_LABEL_DECORATORS");
        if (decorators == null) {
            return provider;
        }
        return new DecoratingColorLabelProvider((ILabelProvider)provider, decorators);
    }

    @Override
    public void dispose() {
        if (this.statusLine != null) {
            this.statusLine.dispose();
        }
        super.dispose();
    }

    @Override
    protected void initializeStatusLine(IActionBars actionBars) {
        this.statusLine = new SyncInfoSetStatusLineContributionGroup(this.getConfiguration().getSite().getShell(), this.getConfiguration());
        IStatusLineManager statusLineMgr = actionBars.getStatusLineManager();
        if (statusLineMgr != null && this.statusLine != null) {
            this.statusLine.fillActionBars(actionBars);
        }
    }

    public static class NavigableCheckboxTreeViewer
    extends ContainerCheckedTreeViewer
    implements AbstractTreeViewerAdvisor.ITreeViewerAccessor {
        public NavigableCheckboxTreeViewer(Composite parent, int style) {
            super(parent, style);
            this.setUseHashlookup(true);
        }

        @Override
        public void createChildren(TreeItem item) {
            super.createChildren((Widget)item);
        }

        @Override
        public void openSelection() {
            this.fireOpen(new OpenEvent((Viewer)this, this.getSelection()));
        }
    }

    public static class NavigableTreeViewer
    extends TreeViewer
    implements AbstractTreeViewerAdvisor.ITreeViewerAccessor {
        public NavigableTreeViewer(Composite parent, int style) {
            super(parent, style);
            this.setUseHashlookup(true);
        }

        @Override
        public void createChildren(TreeItem item) {
            super.createChildren((Widget)item);
        }

        @Override
        public void openSelection() {
            this.fireOpen(new OpenEvent((Viewer)this, this.getSelection()));
        }
    }
}

