/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.util.LinkedHashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.ui.navigator.CommonDragAdapterAssistant;
import org.eclipse.ui.part.ResourceTransfer;

public class ResourceDragAdapterAssistant
extends CommonDragAdapterAssistant {
    private static final Transfer[] SUPPORTED_TRANSFERS = new Transfer[]{ResourceTransfer.getInstance(), FileTransfer.getInstance()};
    private static final Class IRESOURCE_TYPE = IResource.class;

    public Transfer[] getSupportedTransferTypes() {
        return SUPPORTED_TRANSFERS;
    }

    public boolean setDragData(DragSourceEvent anEvent, IStructuredSelection aSelection) {
        IResource[] resources = this.getSelectedResources(aSelection);
        if (resources.length > 0) {
            if (ResourceTransfer.getInstance().isSupportedType(anEvent.dataType)) {
                anEvent.data = resources;
                if (Policy.DEBUG_DND) {
                    System.out.println("ResourceDragAdapterAssistant.dragSetData set ResourceTransfer");
                }
                return true;
            }
            if (FileTransfer.getInstance().isSupportedType(anEvent.dataType)) {
                int length = resources.length;
                int actualLength = 0;
                String[] fileNames = new String[length];
                int i = 0;
                while (i < length) {
                    IPath location = resources[i].getLocation();
                    if (location != null) {
                        fileNames[actualLength++] = location.toOSString();
                    }
                    ++i;
                }
                if (actualLength > 0) {
                    if (actualLength < length) {
                        String[] tempFileNames = fileNames;
                        fileNames = new String[actualLength];
                        int i2 = 0;
                        while (i2 < actualLength) {
                            fileNames[i2] = tempFileNames[i2];
                            ++i2;
                        }
                    }
                    anEvent.data = fileNames;
                    if (Policy.DEBUG_DND) {
                        System.out.println("ResourceDragAdapterAssistant.dragSetData set FileTransfer");
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private IResource[] getSelectedResources(IStructuredSelection aSelection) {
        LinkedHashSet<IResource> resources = new LinkedHashSet<IResource>();
        IResource resource = null;
        for (Object selected : aSelection) {
            resource = this.adaptToResource(selected);
            if (resource == null) continue;
            resources.add(resource);
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    private IResource adaptToResource(Object selected) {
        IResource resource = selected instanceof IResource ? (IResource)selected : (selected instanceof IAdaptable ? (IResource)((IAdaptable)selected).getAdapter(IRESOURCE_TYPE) : (IResource)Platform.getAdapterManager().getAdapter(selected, IRESOURCE_TYPE));
        return resource;
    }
}

