/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.chart.ui.consumer;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.resolver.INumericalResolver;
import org.eclipse.tracecompass.internal.tmf.chart.ui.consumer.IDataConsumer;

public class NumericalConsumer
implements IDataConsumer {
    private final INumericalResolver<Object, Number> fResolver;
    private final Predicate<@Nullable Number> fPredicate;
    private final List<Number> fData = new ArrayList<Number>();
    private Number fMin;
    private Number fMax;

    public NumericalConsumer(INumericalResolver<Object, Number> resolver) {
        this.fResolver = resolver;
        this.fPredicate = Objects::nonNull;
        this.fMin = this.fResolver.getMaxValue();
        this.fMax = this.fResolver.getMinValue();
    }

    public NumericalConsumer(INumericalResolver<Object, Number> resolver, Predicate<@Nullable Number> predicate) {
        this.fResolver = resolver;
        this.fPredicate = predicate;
        this.fMin = this.fResolver.getMaxValue();
        this.fMax = this.fResolver.getMinValue();
    }

    @Override
    public boolean test(Object obj) {
        Number number = (Number)this.fResolver.getMapper().apply(obj);
        return this.fPredicate.test(number);
    }

    @Override
    public void accept(Object obj) {
        Number number = (Number)NonNullUtils.checkNotNull((Object)((Number)this.fResolver.getMapper().apply(obj)));
        if (this.fResolver.getComparator().compare(number, this.fMin) < 0) {
            this.fMin = number;
        }
        if (this.fResolver.getComparator().compare(number, this.fMax) > 0) {
            this.fMax = number;
        }
        this.fData.add(number);
    }

    public List<Number> getData() {
        return ImmutableList.copyOf(this.fData);
    }

    public Number getMin() {
        return this.fMin;
    }

    public Number getMax() {
        return this.fMax;
    }
}

