/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.dialog;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public final class TmfFileDialogFactory {
    private static @Nullable String[] fOverridePaths = null;

    public static FileDialog create(Shell parent) {
        return TmfFileDialogFactory.create(parent, 65536);
    }

    public static FileDialog create(Shell parent, int style) {
        String[] overridePath = fOverridePaths;
        if (overridePath != null) {
            fOverridePaths = null;
            return TmfFileDialogFactory.createNewFileDialog(parent, style, Arrays.asList(overridePath));
        }
        return new FileDialog(parent, style);
    }

    @VisibleForTesting
    public static void setOverrideFiles(String ... paths) {
        fOverridePaths = paths;
    }

    private static FileDialog createNewFileDialog(Shell parent, int style, final List<String> overridePaths) {
        return new FileDialog(parent, style){

            public String open() {
                return !overridePaths.isEmpty() ? (String)overridePaths.get(0) : null;
            }

            protected void checkSubclass() {
            }

            public String getFileName() {
                return !overridePaths.isEmpty() ? this.getFileName((String)overridePaths.get(0)) : "";
            }

            public String[] getFileNames() {
                ArrayList<String> outStrings = new ArrayList<String>();
                for (String entry : overridePaths) {
                    outStrings.add(this.getFileName(entry));
                }
                return outStrings.toArray(new String[outStrings.size()]);
            }

            public String getFilterPath() {
                return !overridePaths.isEmpty() ? new Path((String)overridePaths.get(0)).removeLastSegments(1).toString() : "";
            }

            private String getFileName(String path) {
                return new Path(path).lastSegment();
            }
        };
    }
}

