/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.openon;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.sse.ui.internal.extension.RegistryReader;
import org.eclipse.wst.sse.ui.internal.openon.OpenOnDefinition;

public class OpenOnBuilder
extends RegistryReader {
    public static final String ATT_CLASS = "class";
    public static final String ATT_ID = "id";
    private static OpenOnBuilder fInstance;
    public static final String PL_OPENON = "openon";
    public static final String PLUGIN_ID = "org.eclipse.wst.sse.ui";
    public static final String TAG_CONTENT_TYPE_IDENTIFIER = "contenttypeidentifier";
    public static final String TAG_OPENON = "openon";
    public static final String TAG_PARTITION_TYPE = "partitiontype";
    private String fCurrentContentType;
    private OpenOnDefinition fCurrentOpenOnDefinition = null;
    private List fOpenOnDefs = null;
    protected String targetContributionTag;

    public static synchronized OpenOnBuilder getInstance() {
        if (fInstance == null) {
            fInstance = new OpenOnBuilder();
        }
        return fInstance;
    }

    protected String getId(IConfigurationElement element) {
        String value = element.getAttribute(ATT_ID);
        return value;
    }

    protected String getOpenOnClass(IConfigurationElement element) {
        String value = element.getAttribute(ATT_CLASS);
        return value;
    }

    public OpenOnDefinition[] getOpenOnDefinitions() {
        this.initCache();
        return this.fOpenOnDefs.toArray(new OpenOnDefinition[this.fOpenOnDefs.size()]);
    }

    public OpenOnDefinition[] getOpenOnDefinitions(String contentType, String partitionType) {
        if (contentType == null || partitionType == null) {
            return null;
        }
        OpenOnDefinition[] allDefs = this.getOpenOnDefinitions();
        ArrayList<OpenOnDefinition> defs = new ArrayList<OpenOnDefinition>();
        ArrayList<OpenOnDefinition> lastDefs = new ArrayList<OpenOnDefinition>();
        int i = 0;
        while (i < allDefs.length) {
            List partitions = (List)allDefs[i].getContentTypes().get(contentType);
            if (partitions != null) {
                if (partitions.isEmpty()) {
                    lastDefs.add(allDefs[i]);
                } else {
                    int j = 0;
                    boolean added = false;
                    while (j < partitions.size() && !added) {
                        if (partitionType.equals(partitions.get(j))) {
                            defs.add(allDefs[i]);
                            added = true;
                            continue;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        defs.addAll(lastDefs);
        return defs.toArray(new OpenOnDefinition[defs.size()]);
    }

    private void initCache() {
        if (this.fOpenOnDefs == null) {
            this.fOpenOnDefs = new ArrayList(0);
            this.readContributions("openon", "openon");
        }
    }

    private void processContentTypeTag(IConfigurationElement element) {
        String theId = this.getId(element);
        if (theId != null) {
            this.fCurrentContentType = theId;
            this.fCurrentOpenOnDefinition.addContentTypeId(this.fCurrentContentType);
        } else {
            this.fCurrentContentType = null;
        }
    }

    private void processOpenOnTag(IConfigurationElement element) {
        String theId = this.getId(element);
        String theClass = this.getOpenOnClass(element);
        if (theId != null && theClass != null) {
            this.fCurrentOpenOnDefinition = new OpenOnDefinition(theId, theClass, element);
            this.fOpenOnDefs.add(this.fCurrentOpenOnDefinition);
        } else {
            this.fCurrentOpenOnDefinition = null;
        }
    }

    private void processPartitionTypeTag(IConfigurationElement element) {
        String theId = this.getId(element);
        if (theId != null) {
            this.fCurrentOpenOnDefinition.addPartitionType(this.fCurrentContentType, theId);
        }
    }

    protected void readContributions(String tag, String extensionPoint) {
        this.targetContributionTag = tag;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        this.readRegistry(registry, PLUGIN_ID, extensionPoint);
    }

    protected boolean readElement(IConfigurationElement element) {
        String tag = element.getName();
        if (tag.equals(this.targetContributionTag)) {
            this.processOpenOnTag(element);
            if (this.fCurrentOpenOnDefinition != null) {
                this.readElementChildren(element);
            }
            return true;
        }
        if (tag.equals(TAG_CONTENT_TYPE_IDENTIFIER)) {
            this.processContentTypeTag(element);
            if (this.fCurrentContentType != null) {
                this.readElementChildren(element);
            }
            return true;
        }
        if (tag.equals(TAG_PARTITION_TYPE)) {
            this.processPartitionTypeTag(element);
            return true;
        }
        return false;
    }
}

