/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.xychart;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.XmlViewInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.xychart.Messages;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.xychart.XmlXYViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.views.TmfChartView;
import org.w3c.dom.Element;

public class XmlXYView
extends TmfChartView {
    public static final String ID = "org.eclipse.linuxtools.internal.tmf.analysis.xml.ui.views.xyview";
    private final XmlViewInfo fViewInfo = new XmlViewInfo("org.eclipse.linuxtools.internal.tmf.analysis.xml.ui.views.xyview");

    public XmlXYView() {
        super(Messages.XmlXYView_DefaultTitle);
        this.addPartPropertyListener(new IPropertyChangeListener(){

            public void propertyChange(@Nullable PropertyChangeEvent event) {
                Object newValue;
                if (event == null) {
                    return;
                }
                if (event.getProperty().equals("xmlOutputData") && (newValue = event.getNewValue()) instanceof String) {
                    XmlXYView.this.fViewInfo.setViewData((String)newValue);
                    XmlXYView.this.setViewTitle();
                    TmfXYChartViewer viewer = XmlXYView.this.getChartViewer();
                    if (viewer instanceof XmlXYViewer) {
                        ((XmlXYViewer)viewer).viewInfoUpdated();
                    }
                }
            }
        });
    }

    private void setViewTitle() {
        Element viewElement = this.fViewInfo.getViewElement("xyView");
        if (viewElement == null) {
            return;
        }
        String title = this.fViewInfo.getViewTitle(viewElement);
        if (title == null) {
            title = Messages.XmlXYView_DefaultTitle;
        }
        final String viewTitle = title;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                XmlXYView.this.setPartName(viewTitle);
            }
        });
    }

    public void createPartControl(@Nullable Composite parent) {
        super.createPartControl(parent);
        this.fViewInfo.setName((String)NonNullUtils.checkNotNull((Object)this.getViewSite().getSecondaryId()));
        this.setViewTitle();
    }

    protected TmfXYChartViewer createChartViewer(@Nullable Composite parent) {
        return new XmlXYViewer(parent, this.fViewInfo);
    }
}

