/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.ctf.core.event.IEventDeclaration;
import org.eclipse.tracecompass.ctf.core.event.IEventDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.ICompositeDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IDefinition;
import org.eclipse.tracecompass.ctf.core.trace.ICTFStream;
import org.eclipse.tracecompass.tmf.core.event.ITmfCustomAttributes;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfModelLookup;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEventField;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEventType;
import org.eclipse.tracecompass.tmf.ctf.core.event.NullEventDefinition;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;

@NonNullByDefault
public class CtfTmfEvent
extends TmfEvent
implements ITmfModelLookup,
ITmfCustomAttributes {
    private static final String EMPTY_CTF_EVENT_NAME = "Empty CTF event";
    private final @Nullable IEventDeclaration fEventDeclaration;
    private final IEventDefinition fEvent;
    private final int fSourceCpu;
    private final String fChannel;
    private final String fEventName;
    private transient @Nullable ITmfEventField fContent;
    private transient @Nullable CtfTmfEventType fEventType;
    private final @Nullable ICTFStream fStream;
    private final Map<String, Object> fPacketAttributes;

    protected CtfTmfEvent(CtfTmfTrace trace, long rank, ITmfTimestamp timestamp, String channel, int cpu, IEventDeclaration declaration, IEventDefinition eventDefinition) {
        super((ITmfTrace)trace, rank, timestamp, null, null);
        this.fEventDeclaration = declaration;
        this.fSourceCpu = cpu;
        this.fEventName = (String)NonNullUtils.checkNotNull((Object)declaration.getName());
        this.fEvent = eventDefinition;
        this.fChannel = channel;
        this.fStream = this.fEvent.getDeclaration().getStream();
        this.fPacketAttributes = eventDefinition.getPacketAttributes();
    }

    CtfTmfEvent(CtfTmfTrace trace) {
        super((ITmfTrace)trace, -1L, TmfTimestamp.fromNanos((long)-1L), null, (ITmfEventField)new TmfEventField("", null, (ITmfEventField[])new CtfTmfEventField[0]));
        this.fSourceCpu = -1;
        this.fEventName = EMPTY_CTF_EVENT_NAME;
        this.fEventDeclaration = null;
        this.fEvent = NullEventDefinition.INSTANCE;
        this.fChannel = "";
        this.fStream = null;
        this.fPacketAttributes = Collections.EMPTY_MAP;
    }

    @Deprecated
    public CtfTmfEvent() {
        this.fSourceCpu = -1;
        this.fEventName = EMPTY_CTF_EVENT_NAME;
        this.fEventDeclaration = null;
        this.fEvent = NullEventDefinition.INSTANCE;
        this.fChannel = "";
        this.fStream = null;
        this.fPacketAttributes = Collections.EMPTY_MAP;
    }

    public int getCPU() {
        return this.fSourceCpu;
    }

    public String getChannel() {
        return this.fChannel;
    }

    @Deprecated
    public String getReference() {
        return this.getChannel();
    }

    public long getStreamId() {
        ICTFStream stream = this.fStream;
        if (stream == null) {
            return -1L;
        }
        return stream.getId();
    }

    public CtfTmfTrace getTrace() {
        return (CtfTmfTrace)super.getTrace();
    }

    public synchronized ITmfEventType getType() {
        CtfTmfEventType type = this.fEventType;
        if (type == null) {
            type = new CtfTmfEventType(this.fEventName, this.getContent());
            this.getTrace().registerEventType(type);
            this.fEventType = type;
        }
        return type;
    }

    public String getName() {
        return this.fEventName;
    }

    public synchronized ITmfEventField getContent() {
        ITmfEventField content = this.fContent;
        if (content == null) {
            this.fContent = content = new TmfEventField(":root:", null, (ITmfEventField[])CtfTmfEvent.parseFields(this.fEvent));
        }
        return content;
    }

    private static CtfTmfEventField[] parseFields(IEventDefinition eventDef) {
        ICompositeDefinition structContext;
        ArrayList<CtfTmfEventField> fields = new ArrayList<CtfTmfEventField>();
        ICompositeDefinition structFields = eventDef.getFields();
        if (structFields != null && structFields.getFieldNames() != null) {
            for (String fn : structFields.getFieldNames()) {
                fields.add(CtfTmfEventField.parseField((IDefinition)structFields.getDefinition(fn), fn));
            }
        }
        if ((structContext = eventDef.getContext()) != null) {
            for (String contextName : structContext.getFieldNames()) {
                String curContextName = "context." + contextName;
                fields.add(CtfTmfEventField.parseField((IDefinition)structContext.getDefinition(contextName), curContextName));
            }
        }
        return fields.toArray(new CtfTmfEventField[fields.size()]);
    }

    public Set<String> listCustomAttributes() {
        IEventDeclaration declaration = this.fEventDeclaration;
        if (declaration == null) {
            return new HashSet<String>();
        }
        return declaration.getCustomAttributes();
    }

    public @Nullable String getCustomAttribute(@Nullable String name) {
        IEventDeclaration declaration = this.fEventDeclaration;
        if (declaration == null) {
            return null;
        }
        return declaration.getCustomAttribute(name);
    }

    public @Nullable String getModelUri() {
        return this.getCustomAttribute("model.emf.uri");
    }

    public Map<String, Object> getPacketAttributes() {
        return this.fPacketAttributes;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.getCPU();
        result = 31 * result + this.getChannel().hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        CtfTmfEvent other = (CtfTmfEvent)((Object)NonNullUtils.checkNotNull((Object)((Object)((CtfTmfEvent)((Object)obj)))));
        if (this.getCPU() != other.getCPU()) {
            return false;
        }
        return this.getChannel().equals(other.getChannel());
    }
}

