/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.segmentstore.statistics;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.statistics.SegmentStoreStatistics;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public abstract class AbstractSegmentStatisticsAnalysis
extends TmfAbstractAnalysisModule {
    private @Nullable ISegmentStoreProvider fSegmentStoreProviderModule;
    private @Nullable SegmentStoreStatistics fTotalStats;
    private Map<String, SegmentStoreStatistics> fPerSegmentTypeStats = new HashMap<String, SegmentStoreStatistics>();

    protected Iterable<IAnalysisModule> getDependentAnalyses() {
        ITmfTrace trace = this.getTrace();
        if (trace != null) {
            ISegmentStoreProvider provider;
            this.fSegmentStoreProviderModule = provider = this.getSegmentProviderAnalysis(trace);
            if (provider instanceof IAnalysisModule) {
                return ImmutableList.of((Object)((IAnalysisModule)provider));
            }
        }
        return super.getDependentAnalyses();
    }

    protected boolean executeAnalysis(IProgressMonitor monitor) throws TmfAnalysisException {
        if (monitor.isCanceled()) {
            return false;
        }
        SegmentStoreStatistics totalStats = this.getTotalStats(TmfTimeRange.ETERNITY.getStartTime().toNanos(), TmfTimeRange.ETERNITY.getEndTime().toNanos(), monitor);
        if (totalStats == null) {
            return false;
        }
        Map<@NonNull String, @NonNull SegmentStoreStatistics> perTypeStats = this.getPerTypeStats(TmfTimeRange.ETERNITY.getStartTime().toNanos(), TmfTimeRange.ETERNITY.getEndTime().toNanos(), monitor);
        if (perTypeStats == null) {
            return false;
        }
        this.fTotalStats = totalStats;
        this.fPerSegmentTypeStats = perTypeStats;
        return true;
    }

    private @Nullable SegmentStoreStatistics getTotalStats(long start, long end, IProgressMonitor monitor) {
        Iterable<@NonNull ISegment> store = this.getSegmentStore(start, end);
        if (store == null) {
            return null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        return AbstractSegmentStatisticsAnalysis.calculateTotalManual(store, monitor);
    }

    public @Nullable SegmentStoreStatistics getTotalStatsForRange(long start, long end, IProgressMonitor monitor) {
        ITmfTrace trace = this.getTrace();
        if (trace != null && start == TmfTimeRange.ETERNITY.getStartTime().toNanos() && end == TmfTimeRange.ETERNITY.getEndTime().toNanos()) {
            this.waitForCompletion();
            return this.getTotalStats();
        }
        return this.getTotalStats(start, end, monitor);
    }

    private @Nullable Map<@NonNull String, @NonNull SegmentStoreStatistics> getPerTypeStats(long start, long end, IProgressMonitor monitor) {
        Iterable<@NonNull ISegment> store = this.getSegmentStore(start, end);
        if (monitor.isCanceled()) {
            return Collections.EMPTY_MAP;
        }
        return this.calculateTotalPerType(store, monitor);
    }

    public @Nullable Map<@NonNull String, @NonNull SegmentStoreStatistics> getPerSegmentTypeStatsForRange(long start, long end, IProgressMonitor monitor) {
        ITmfTrace trace = this.getTrace();
        if (trace != null && start == TmfTimeRange.ETERNITY.getStartTime().toNanos() && end == TmfTimeRange.ETERNITY.getEndTime().toNanos()) {
            this.waitForCompletion();
            return this.getPerSegmentTypeStats();
        }
        return this.getPerTypeStats(start, end, monitor);
    }

    private @Nullable Iterable<@NonNull ISegment> getSegmentStore(long start, long end) {
        ISegmentStore<ISegment> segmentStore;
        ISegmentStoreProvider segmentStoreProviderModule = this.fSegmentStoreProviderModule;
        if (segmentStoreProviderModule == null) {
            return null;
        }
        if (segmentStoreProviderModule instanceof IAnalysisModule) {
            ((IAnalysisModule)segmentStoreProviderModule).waitForCompletion();
        }
        return (segmentStore = segmentStoreProviderModule.getSegmentStore()) != null ? (start != TmfTimeRange.ETERNITY.getStartTime().toNanos() || end != TmfTimeRange.ETERNITY.getEndTime().toNanos() ? segmentStore.getIntersectingElements(start, end) : segmentStore) : Collections.EMPTY_LIST;
    }

    private static @Nullable SegmentStoreStatistics calculateTotalManual(Iterable<@NonNull ISegment> segments, IProgressMonitor monitor) {
        SegmentStoreStatistics total = new SegmentStoreStatistics();
        Iterator<@NonNull ISegment> iter = segments.iterator();
        while (iter.hasNext()) {
            if (monitor.isCanceled()) {
                return null;
            }
            ISegment segment = iter.next();
            total.update(segment);
        }
        return total;
    }

    private Map<@NonNull String, @NonNull SegmentStoreStatistics> calculateTotalPerType(Iterable<ISegment> segments, IProgressMonitor monitor) {
        HashMap<String, SegmentStoreStatistics> perSegmentTypeStats = new HashMap<String, SegmentStoreStatistics>();
        Iterator<ISegment> iter = segments.iterator();
        while (iter.hasNext()) {
            if (monitor.isCanceled()) {
                return Collections.EMPTY_MAP;
            }
            ISegment segment = iter.next();
            String segmentType = this.getSegmentType(segment);
            if (segmentType == null) continue;
            SegmentStoreStatistics values = (SegmentStoreStatistics)perSegmentTypeStats.get(segmentType);
            if (values == null) {
                values = new SegmentStoreStatistics();
            }
            values.update(segment);
            perSegmentTypeStats.put(segmentType, values);
        }
        return perSegmentTypeStats;
    }

    protected abstract @Nullable String getSegmentType(ISegment var1);

    protected abstract @Nullable ISegmentStoreProvider getSegmentProviderAnalysis(ITmfTrace var1);

    protected void canceling() {
    }

    public @Nullable SegmentStoreStatistics getTotalStats() {
        return this.fTotalStats;
    }

    public @Nullable Map<String, SegmentStoreStatistics> getPerSegmentTypeStats() {
        return this.fPerSegmentTypeStats;
    }
}

