/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.model;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;
import org.eclipse.ui.externaltools.internal.model.ImageDescriptorRegistry;

public class ExternalToolsImages {
    private static ImageRegistry imageRegistry;
    private static ImageDescriptorRegistry imageDescriptorRegistry;
    private static URL ICON_BASE_URL;
    private static final String OBJECT = "obj16/";

    static {
        ICON_BASE_URL = null;
        String pathSuffix = "icons/full/";
        ICON_BASE_URL = ExternalToolsPlugin.getDefault().getBundle().getEntry(pathSuffix);
    }

    private static void declareImages() {
        ExternalToolsImages.declareRegistryImage("org.eclipse.ui.externaltools.IMG_TAB_MAIN", "obj16/main_tab.png");
        ExternalToolsImages.declareRegistryImage("org.eclipse.ui.externaltools.IMG_TAB_BUILD", "obj16/build_tab.png");
    }

    private static final void declareRegistryImage(String key, String path) {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        try {
            desc = ImageDescriptor.createFromURL((URL)ExternalToolsImages.makeIconFileURL(path));
        }
        catch (MalformedURLException malformedURLException) {}
        imageRegistry.put(key, desc);
    }

    public static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            ExternalToolsImages.initializeImageRegistry();
        }
        return imageRegistry;
    }

    public static ImageRegistry initializeImageRegistry() {
        imageRegistry = new ImageRegistry(ExternalToolsPlugin.getStandardDisplay());
        ExternalToolsImages.declareImages();
        return imageRegistry;
    }

    public static Image getImage(String key) {
        return ExternalToolsImages.getImageRegistry().get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return ExternalToolsImages.getImageRegistry().getDescriptor(key);
    }

    private static URL makeIconFileURL(String iconPath) throws MalformedURLException {
        if (ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        return new URL(ICON_BASE_URL, iconPath);
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        ExternalToolsImages.setImageDescriptors(action, "lcl16", iconName);
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        ImageDescriptor id;
        try {
            id = ImageDescriptor.createFromURL((URL)ExternalToolsImages.makeIconFileURL("d" + type, relPath));
            if (id != null) {
                action.setDisabledImageDescriptor(id);
            }
        }
        catch (MalformedURLException e) {
            ExternalToolsPlugin.getDefault().log(e);
        }
        try {
            id = ImageDescriptor.createFromURL((URL)ExternalToolsImages.makeIconFileURL("c" + type, relPath));
            if (id != null) {
                action.setHoverImageDescriptor(id);
            }
        }
        catch (MalformedURLException e) {
            ExternalToolsPlugin.getDefault().log(e);
        }
        action.setImageDescriptor(ExternalToolsImages.create("e" + type, relPath));
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(ICON_BASE_URL, buffer.toString());
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)ExternalToolsImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException e) {
            ExternalToolsPlugin.getDefault().log(e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public static Image getImage(CompositeImageDescriptor imageDescriptor) {
        if (imageDescriptorRegistry == null) {
            imageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return imageDescriptorRegistry.get((ImageDescriptor)imageDescriptor);
    }

    public static void disposeImageDescriptorRegistry() {
        if (imageDescriptorRegistry != null) {
            imageDescriptorRegistry.dispose();
        }
    }
}

