/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlStateAttribute;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlLocation;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.w3c.dom.Element;

public abstract class TmfXmlStateAttribute
implements ITmfXmlStateAttribute {
    private final String CURRENT_STATE = "#currentState";
    private final String CURRENT_SCENARIO = "#CurrentScenario";
    private final StateAttributeType fType;
    private final @Nullable String fName;
    private final List<ITmfXmlStateAttribute> fQueryList = new LinkedList<ITmfXmlStateAttribute>();
    private final IXmlStateSystemContainer fContainer;

    protected TmfXmlStateAttribute(ITmfXmlModelFactory modelFactory, Element attribute, IXmlStateSystemContainer container) {
        this.fContainer = container;
        switch (attribute.getAttribute("type")) {
            case "constant": {
                this.fType = StateAttributeType.CONSTANT;
                this.fName = this.getAttributeName(attribute);
                break;
            }
            case "eventField": {
                this.fType = StateAttributeType.EVENTFIELD;
                this.fName = this.getAttributeName(attribute);
                break;
            }
            case "location": {
                this.fType = StateAttributeType.LOCATION;
                this.fName = this.getAttributeName(attribute);
                break;
            }
            case "query": {
                List<@Nullable Element> childElements = XmlUtils.getChildElements(attribute);
                for (Element subAttributeNode : childElements) {
                    if (subAttributeNode == null) continue;
                    ITmfXmlStateAttribute subAttribute = modelFactory.createStateAttribute(subAttributeNode, this.fContainer);
                    this.fQueryList.add(subAttribute);
                }
                this.fType = StateAttributeType.QUERY;
                this.fName = null;
                break;
            }
            case "eventName": {
                this.fType = StateAttributeType.EVENTNAME;
                this.fName = this.getAttributeName(attribute);
                break;
            }
            case "": {
                this.fType = StateAttributeType.NONE;
                this.fName = null;
                break;
            }
            case "self": {
                this.fType = StateAttributeType.SELF;
                this.fName = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("TmfXmlStateAttribute constructor: The XML element is not of the right type");
            }
        }
    }

    private String getAttributeName(Element attribute) {
        return this.fContainer.getAttributeValue(attribute.getAttribute("value")).intern();
    }

    @Override
    public int getAttributeQuark(int startQuark, @Nullable TmfXmlScenarioInfo scenarioInfo) {
        return this.getAttributeQuark(null, startQuark, scenarioInfo);
    }

    protected abstract int getQuarkAbsoluteAndAdd(String ... var1) throws AttributeNotFoundException;

    protected abstract int getQuarkRelativeAndAdd(int var1, String ... var2) throws AttributeNotFoundException;

    protected @Nullable ITmfStateSystem getStateSystem() {
        return this.fContainer.getStateSystem();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getAttributeQuark(@Nullable ITmfEvent event, int startQuark, @Nullable TmfXmlScenarioInfo scenarioInfo) {
        ITmfStateSystem ss = this.getStateSystem();
        if (ss == null) {
            throw new IllegalStateException("The state system hasn't been initialized yet");
        }
        String name = NonNullUtils.nullToEmptyString((Object)this.fName);
        if (name.length() > 0 && name.charAt(0) == '#' && scenarioInfo == null) {
            throw new IllegalStateException("XML Attribute needs " + this.fName + " but the data is not available.");
        }
        name = name.equals("#currentState") ? ((TmfXmlScenarioInfo)NonNullUtils.checkNotNull((Object)scenarioInfo)).getActiveState() : this.fName;
        try {
            switch (this.fType) {
                case CONSTANT: {
                    if (name == null) {
                        throw new IllegalStateException("Invalid attribute name");
                    }
                    if (name.equals("#CurrentScenario")) {
                        return ((TmfXmlScenarioInfo)NonNullUtils.checkNotNull((Object)scenarioInfo)).getQuark();
                    }
                    if (startQuark == -1) {
                        return this.getQuarkAbsoluteAndAdd(name);
                    }
                    return this.getQuarkRelativeAndAdd(startQuark, name);
                }
                case EVENTFIELD: {
                    int quark = -1;
                    if (event == null) {
                        Activator.logWarning("XML State attribute: looking for an event field, but event is null");
                        return quark;
                    }
                    if (name == null) {
                        throw new IllegalStateException("Invalid attribute name");
                    }
                    ITmfEventField field = event.getContent().getField(new String[]{name});
                    if (field == null) {
                        if (!name.equalsIgnoreCase("cpu")) return -1;
                        Integer cpu = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event);
                        if (cpu == null) return -1;
                        return this.getQuarkRelativeAndAdd(startQuark, cpu.toString());
                    }
                    Object fieldValue = field.getValue();
                    if (fieldValue instanceof String) {
                        String fieldString = (String)fieldValue;
                        return this.getQuarkRelativeAndAdd(startQuark, fieldString);
                    }
                    if (fieldValue instanceof Long) {
                        Long fieldLong = (Long)fieldValue;
                        return this.getQuarkRelativeAndAdd(startQuark, fieldLong.toString());
                    }
                    if (!(fieldValue instanceof Integer)) return quark;
                    Integer fieldInterger = (Integer)fieldValue;
                    return this.getQuarkRelativeAndAdd(startQuark, fieldInterger.toString());
                }
                case QUERY: {
                    ITmfXmlStateAttribute attrib;
                    TmfStateValue value = TmfStateValue.nullValue();
                    int quarkQuery = -1;
                    Iterator<ITmfXmlStateAttribute> iterator = this.fQueryList.iterator();
                    while (iterator.hasNext() && (quarkQuery = (attrib = iterator.next()).getAttributeQuark(event, quarkQuery, scenarioInfo)) != -1) {
                    }
                    if (quarkQuery != -1) {
                        value = ss.queryOngoingState(quarkQuery);
                    }
                    switch (value.getType()) {
                        case INTEGER: {
                            int result = value.unboxInt();
                            return this.getQuarkRelativeAndAdd(startQuark, String.valueOf(result));
                        }
                        case LONG: {
                            long result = value.unboxLong();
                            return this.getQuarkRelativeAndAdd(startQuark, String.valueOf(result));
                        }
                        case STRING: {
                            String result = value.unboxStr();
                            return this.getQuarkRelativeAndAdd(startQuark, result);
                        }
                    }
                    return -1;
                }
                case LOCATION: {
                    TmfXmlLocation location;
                    int quark = startQuark;
                    String idLocation = name;
                    Iterator<TmfXmlLocation> iterator = this.fContainer.getLocations().iterator();
                    do {
                        if (iterator.hasNext()) continue;
                        return quark;
                    } while (!(location = iterator.next()).getId().equals(idLocation) || (quark = location.getLocationQuark(event, quark, scenarioInfo)) != -1);
                    return quark;
                }
                case EVENTNAME: {
                    int quark = -1;
                    if (event == null) {
                        Activator.logWarning("XML State attribute: looking for an eventname, but event is null");
                        return quark;
                    }
                    return this.getQuarkRelativeAndAdd(startQuark, event.getName());
                }
                case SELF: {
                    return startQuark;
                }
            }
            return startQuark;
        }
        catch (AttributeNotFoundException ae) {
            return -1;
        }
        catch (StateValueTypeException e) {
            Activator.logError("StateValueTypeException", e);
            return -1;
        }
    }

    public String toString() {
        return "TmfXmlStateAttribute " + (Object)((Object)this.fType) + ": " + this.fName;
    }

    private static enum StateAttributeType {
        NONE,
        CONSTANT,
        EVENTFIELD,
        QUERY,
        LOCATION,
        SELF,
        EVENTNAME;

    }
}

