/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.SimplePatternFormatter;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.PluralRules;

class QuantityFormatter {
    private static final int INDEX_COUNT = 6;
    private final SimplePatternFormatter[] templates;

    private static final int getPluralIndex(CharSequence pluralForm) {
        switch (pluralForm.length()) {
            case 3: {
                if ("one".contentEquals(pluralForm)) {
                    return 2;
                }
                if ("two".contentEquals(pluralForm)) {
                    return 3;
                }
                if (!"few".contentEquals(pluralForm)) break;
                return 4;
            }
            case 4: {
                if ("many".contentEquals(pluralForm)) {
                    return 5;
                }
                if (!"zero".contentEquals(pluralForm)) break;
                return 1;
            }
            case 5: {
                if (!"other".contentEquals(pluralForm)) break;
                return 0;
            }
        }
        return -1;
    }

    private QuantityFormatter(SimplePatternFormatter[] templates) {
        this.templates = templates;
    }

    public String format(double quantity, NumberFormat numberFormat, PluralRules pluralRules) {
        String formatStr = numberFormat.format(quantity);
        String variant = this.computeVariant(quantity, numberFormat, pluralRules);
        return this.getByVariant(variant).format(formatStr);
    }

    public SimplePatternFormatter getByVariant(CharSequence variant) {
        int idx = QuantityFormatter.getPluralIndex(variant);
        SimplePatternFormatter template = this.templates[idx < 0 ? 0 : idx];
        return template == null ? this.templates[0] : template;
    }

    private String computeVariant(double quantity, NumberFormat numberFormat, PluralRules pluralRules) {
        if (numberFormat instanceof DecimalFormat) {
            return pluralRules.select(((DecimalFormat)numberFormat).getFixedDecimal(quantity));
        }
        return pluralRules.select(quantity);
    }

    /* synthetic */ QuantityFormatter(SimplePatternFormatter[] simplePatternFormatterArray, QuantityFormatter quantityFormatter) {
        this(simplePatternFormatterArray);
    }

    static class Builder {
        private SimplePatternFormatter[] templates;

        Builder() {
        }

        boolean hasPatterns() {
            return this.templates != null;
        }

        public Builder add(CharSequence variant, String template) {
            int idx = QuantityFormatter.getPluralIndex(variant);
            if (idx < 0) {
                throw new IllegalArgumentException(variant.toString());
            }
            SimplePatternFormatter newT = SimplePatternFormatter.compile(template);
            if (newT.getPlaceholderCount() > 1) {
                throw new IllegalArgumentException("Extra placeholders: " + template);
            }
            this.ensureCapacity();
            this.templates[idx] = newT;
            return this;
        }

        public QuantityFormatter build() {
            if (this.templates == null || this.templates[0] == null) {
                throw new IllegalStateException("At least other variant must be set.");
            }
            QuantityFormatter result = new QuantityFormatter(this.templates, null);
            this.templates = null;
            return result;
        }

        public Builder reset() {
            this.templates = null;
            return this;
        }

        private void ensureCapacity() {
            if (this.templates == null) {
                this.templates = new SimplePatternFormatter[6];
            }
        }
    }
}

