/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.handler;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlAnalysisModuleSource;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.handler.Messages;
import org.eclipse.tracecompass.tmf.ui.dialog.TmfFileDialogFactory;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class ManageXMLAnalysisDialog
extends Dialog {
    private final String XML_FILTER_EXTENSION = "*.xml";
    private org.eclipse.swt.widgets.List fAnalysesList;
    private Button fDeleteButton;
    private Button fImportButton;
    private Button fExportButton;
    private Button fEditButton;
    private Label fInvalidFileLabel;

    public ManageXMLAnalysisDialog(Shell parent) {
        super(parent);
        this.setShellStyle(0x410 | this.getShellStyle());
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.ManageXMLAnalysisDialog_ManageXmlAnalysesFiles);
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        Composite listContainer = new Composite(composite, 0);
        listContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout lcgl = new GridLayout();
        lcgl.marginHeight = 0;
        lcgl.marginWidth = 0;
        listContainer.setLayout((Layout)lcgl);
        this.fAnalysesList = new org.eclipse.swt.widgets.List(listContainer, 2820);
        this.fAnalysesList.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fAnalysesList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ManageXMLAnalysisDialog.this.fAnalysesList.getSelectionCount() == 0) {
                    ManageXMLAnalysisDialog.this.fDeleteButton.setEnabled(false);
                    ManageXMLAnalysisDialog.this.fExportButton.setEnabled(false);
                    ManageXMLAnalysisDialog.this.fEditButton.setEnabled(false);
                } else {
                    ManageXMLAnalysisDialog.this.fDeleteButton.setEnabled(true);
                    ManageXMLAnalysisDialog.this.fExportButton.setEnabled(true);
                    ManageXMLAnalysisDialog.this.fEditButton.setEnabled(true);
                    ManageXMLAnalysisDialog.this.handleSelection(ManageXMLAnalysisDialog.this.fAnalysesList.getSelection());
                }
            }
        });
        this.fInvalidFileLabel = new Label(listContainer, 1);
        this.fInvalidFileLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fInvalidFileLabel.setForeground(this.getShell().getDisplay().getSystemColor(3));
        this.fInvalidFileLabel.setText(Messages.ManageXMLAnalysisDialog_FileValidationError);
        this.fInvalidFileLabel.setVisible(false);
        Composite buttonContainer = new Composite(composite, 0);
        buttonContainer.setLayout((Layout)new GridLayout());
        buttonContainer.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        this.fImportButton = new Button(buttonContainer, 8);
        this.fImportButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fImportButton.setText(Messages.ManageXMLAnalysisDialog_Import);
        this.fImportButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ManageXMLAnalysisDialog.this.importAnalysis();
            }
        });
        this.fExportButton = new Button(buttonContainer, 8);
        this.fExportButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fExportButton.setText(Messages.ManageXMLAnalysisDialog_Export);
        this.fExportButton.setEnabled(false);
        this.fExportButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ManageXMLAnalysisDialog.this.exportAnalysis();
            }
        });
        this.fEditButton = new Button(buttonContainer, 8);
        this.fEditButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fEditButton.setText(Messages.ManageXMLAnalysisDialog_Edit);
        this.fEditButton.setEnabled(false);
        this.fEditButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ManageXMLAnalysisDialog.this.editAnalysis();
            }
        });
        this.fDeleteButton = new Button(buttonContainer, 8);
        this.fDeleteButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fDeleteButton.setText(Messages.ManageXMLAnalysisDialog_Delete);
        this.fDeleteButton.setEnabled(false);
        this.fDeleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ManageXMLAnalysisDialog.this.deleteAnalysis();
            }
        });
        this.fillAnalysesList();
        this.getShell().setMinimumSize(300, 275);
        return composite;
    }

    private void handleSelection(String[] selection) {
        Map files = XmlUtils.listFiles();
        File file = (File)files.get(ManageXMLAnalysisDialog.createXmlFileString(selection[0]));
        if (file != null && XmlUtils.xmlValidate((File)file).isOK()) {
            this.fInvalidFileLabel.setVisible(false);
        } else {
            this.fInvalidFileLabel.setVisible(true);
        }
    }

    private static void deleteSupplementaryFile(String xmlFile) {
        IProject[] projects;
        ArrayList<IResource> resourceToDelete = new ArrayList<IResource>();
        List ids = XmlUtils.getAnalysisIdsFromFile((String)xmlFile);
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects(0);
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            TmfProjectElement pElement = TmfProjectRegistry.getProject((IProject)project);
            if (pElement != null) {
                ArrayList tElements = new ArrayList();
                tElements.addAll(pElement.getTracesFolder().getTraces());
                tElements.addAll(pElement.getExperimentsFolder().getExperiments());
                for (TmfCommonProjectElement tElement : tElements) {
                    boolean closeEditor = false;
                    IResource[] iResourceArray = tElement.getSupplementaryResources();
                    int n3 = iResourceArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IResource resource = iResourceArray[n4];
                        for (String id : ids) {
                            if (!resource.getName().startsWith(id)) continue;
                            resourceToDelete.add(resource);
                            closeEditor = true;
                        }
                        ++n4;
                    }
                    if (!closeEditor) continue;
                    tElement.closeEditors();
                }
            }
            ++n2;
        }
        for (IResource resource : resourceToDelete) {
            try {
                resource.delete(false, null);
            }
            catch (CoreException e) {
                Activator.logError(NLS.bind((String)Messages.ManageXMLAnalysisDialog_DeleteFileError, (Object)resource.getName()));
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, false);
    }

    private void fillAnalysesList() {
        this.fAnalysesList.removeAll();
        Map files = XmlUtils.listFiles();
        for (String file : files.keySet()) {
            Path path = new Path(file);
            this.fAnalysesList.add(path.removeFileExtension().toString());
        }
        this.fDeleteButton.setEnabled(false);
        this.fExportButton.setEnabled(false);
    }

    private void importAnalysis() {
        File file;
        FileDialog dialog = TmfFileDialogFactory.create((Shell)Display.getCurrent().getActiveShell(), (int)4096);
        dialog.setText(Messages.ManageXMLAnalysisDialog_SelectFileImport);
        dialog.setFilterNames(new String[]{String.valueOf(Messages.ManageXMLAnalysisDialog_ImportXmlFile) + " (*.xml)"});
        dialog.setFilterExtensions(new String[]{"*.xml"});
        String path = dialog.open();
        if (path != null && ManageXMLAnalysisDialog.loadXmlFile(file = new File(path), true)) {
            this.fillAnalysesList();
        }
    }

    private static boolean loadXmlFile(File file, boolean addFile) {
        IStatus status = XmlUtils.xmlValidate((File)file);
        if (status.isOK()) {
            ManageXMLAnalysisDialog.deleteSupplementaryFile(file.getName());
            if (addFile) {
                status = XmlUtils.addXmlFile((File)file);
            }
            if (status.isOK()) {
                XmlAnalysisModuleSource.notifyModuleChange();
                ManageXMLAnalysisDialog.refreshProject();
                return true;
            }
            Activator.logError(Messages.ManageXMLAnalysisDialog_ImportFileFailed);
            TraceUtils.displayErrorMsg((String)Messages.ManageXMLAnalysisDialog_ImportFileFailed, (String)status.getMessage());
        } else {
            Activator.logError(Messages.ManageXMLAnalysisDialog_ImportFileFailed);
            TraceUtils.displayErrorMsg((String)Messages.ManageXMLAnalysisDialog_ImportFileFailed, (String)status.getMessage());
        }
        return false;
    }

    private void exportAnalysis() {
        FileDialog dialog = TmfFileDialogFactory.create((Shell)Display.getCurrent().getActiveShell(), (int)8192);
        dialog.setText(NLS.bind((String)Messages.ManageXMLAnalysisDialog_SelectFileExport, (Object)this.fAnalysesList.getSelection()[0]));
        dialog.setFilterExtensions(new String[]{"*.xml", "*"});
        String selection = ManageXMLAnalysisDialog.createXmlFileString(this.fAnalysesList.getSelection()[0]);
        dialog.setFileName(selection);
        String path = dialog.open();
        if (path != null && !XmlUtils.exportXmlFile((String)selection, (String)path).isOK()) {
            Activator.logError(NLS.bind((String)Messages.ManageXMLAnalysisDialog_FailedToExport, (Object)selection));
        }
    }

    private void editAnalysis() {
        String selection = ManageXMLAnalysisDialog.createXmlFileString(this.fAnalysesList.getSelection()[0]);
        final @Nullable File file = (File)XmlUtils.listFiles().get(selection);
        if (file == null) {
            Activator.logError(NLS.bind((String)Messages.ManageXMLAnalysisDialog_FailedToEdit, (Object)selection));
            TraceUtils.displayErrorMsg((String)NLS.bind((String)Messages.ManageXMLAnalysisDialog_FailedToEdit, (Object)selection), (String)NLS.bind((String)Messages.ManageXMLAnalysisDialog_FailedToEdit, (Object)selection));
            return;
        }
        try {
            final IEditorPart editorPart = IDE.openEditorOnFileStore((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFileStore)EFS.getStore((URI)file.toURI()));
            editorPart.addPropertyListener(new IPropertyListener(){

                public void propertyChanged(Object source, int propId) {
                    if (257 == propId && !editorPart.isDirty()) {
                        ManageXMLAnalysisDialog.loadXmlFile(file, false);
                    }
                }
            });
            this.close();
        }
        catch (CoreException e) {
            Activator.logError(NLS.bind((String)Messages.ManageXMLAnalysisDialog_FailedToEdit, (Object)selection));
            TraceUtils.displayErrorMsg((String)NLS.bind((String)Messages.ManageXMLAnalysisDialog_FailedToEdit, (Object)selection), (String)e.getMessage());
        }
    }

    private void deleteAnalysis() {
        boolean confirm = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.ManageXMLAnalysisDialog_DeleteFile, (String)NLS.bind((String)Messages.ManageXMLAnalysisDialog_DeleteConfirmation, (Object)this.fAnalysesList.getSelection()[0]));
        if (confirm) {
            String selection = ManageXMLAnalysisDialog.createXmlFileString(this.fAnalysesList.getSelection()[0]);
            ManageXMLAnalysisDialog.deleteSupplementaryFile(selection);
            XmlUtils.deleteFile((String)selection);
            this.fillAnalysesList();
            this.fInvalidFileLabel.setVisible(false);
            XmlAnalysisModuleSource.notifyModuleChange();
            ManageXMLAnalysisDialog.refreshProject();
        }
    }

    private static void refreshProject() {
        TreeSelection sel;
        Object element;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart part = page.getActivePart();
        if (part == null) {
            return;
        }
        ISelectionProvider selectionProvider = part.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return;
        }
        ISelection selection = selectionProvider.getSelection();
        if (selection instanceof TreeSelection && (element = (sel = (TreeSelection)selection).getFirstElement()) instanceof TmfProjectModelElement) {
            ((TmfProjectModelElement)element).getProject().refresh();
        }
    }

    private static String createXmlFileString(String baseName) {
        IPath path = new Path(baseName).addFileExtension("xml");
        return path.toString();
    }
}

